/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import javax.jcr.Session;
import net.sf.cglib.proxy.LazyLoader;
import org.jcrom.ChildNodeMapper;
import org.jcrom.Mapper;
import org.jcrom.util.NodeFilter;

class ChildNodeListLoader
implements LazyLoader {
    private static final Logger logger = Logger.getLogger(ChildNodeListLoader.class.getName());
    private final Class objectClass;
    private final Object parentObject;
    private final String containerPath;
    private final Session session;
    private final Mapper mapper;
    private final int depth;
    private final NodeFilter nodeFilter;

    ChildNodeListLoader(Class objectClass, Object parentObject, String containerPath, Session session, Mapper mapper, int depth, NodeFilter nodeFilter) {
        this.objectClass = objectClass;
        this.parentObject = parentObject;
        this.containerPath = containerPath;
        this.session = session;
        this.mapper = mapper;
        this.depth = depth;
        this.nodeFilter = nodeFilter;
    }

    public Object loadObject() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy loading children list for " + this.containerPath);
        }
        Node childrenContainer = this.session.getRootNode().getNode(this.containerPath.substring(1));
        return ChildNodeMapper.getChildrenList(this.objectClass, childrenContainer, this.parentObject, this.mapper, this.depth, this.nodeFilter);
    }
}

