/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import javax.jcr.Session;
import net.sf.cglib.proxy.LazyLoader;
import org.jcrom.ChildNodeMapper;
import org.jcrom.Mapper;
import org.jcrom.util.NodeFilter;

class ChildNodeLoader
implements LazyLoader {
    private static final Logger logger = Logger.getLogger(ChildNodeLoader.class.getName());
    private final Class objectClass;
    private final Object parentObject;
    private final String containerPath;
    private final Session session;
    private final Mapper mapper;
    private final int depth;
    private final NodeFilter nodeFilter;
    private final boolean pathIsContainer;

    ChildNodeLoader(Class objectClass, Object parentObject, String containerPath, Session session, Mapper mapper, int depth, NodeFilter nodeFilter) {
        this(objectClass, parentObject, containerPath, session, mapper, depth, nodeFilter, true);
    }

    ChildNodeLoader(Class objectClass, Object parentObject, String containerPath, Session session, Mapper mapper, int depth, NodeFilter nodeFilter, boolean pathIsContainer) {
        this.objectClass = objectClass;
        this.parentObject = parentObject;
        this.containerPath = containerPath;
        this.session = session;
        this.mapper = mapper;
        this.depth = depth;
        this.nodeFilter = nodeFilter;
        this.pathIsContainer = pathIsContainer;
    }

    public Object loadObject() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy loading single child for " + this.containerPath);
        }
        Node node = this.pathIsContainer ? this.session.getRootNode().getNode(this.containerPath.substring(1)).getNodes().nextNode() : this.session.getRootNode().getNode(this.containerPath.substring(1));
        return ChildNodeMapper.getSingleChild(this.objectClass, node, this.parentObject, this.mapper, this.depth, this.nodeFilter);
    }
}

