/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.jcrom.Mapper;
import org.jcrom.ProxyFactory;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.ReflectionUtils;

class ChildNodeMapper {
    ChildNodeMapper() {
    }

    private static String getNodeName(Field field) {
        JcrChildNode jcrChildNode = field.getAnnotation(JcrChildNode.class);
        String name = field.getName();
        if (!jcrChildNode.name().equals("fieldName")) {
            name = jcrChildNode.name();
        }
        return name;
    }

    private static void removeChildren(Node containerNode) throws RepositoryException {
        NodeIterator nodeIterator = containerNode.getNodes();
        while (nodeIterator.hasNext()) {
            nodeIterator.nextNode().remove();
        }
    }

    private static Node createChildNodeContainer(Node node, String containerName, JcrChildNode jcrChildNode, Mapper mapper) throws RepositoryException {
        if (!node.hasNode(mapper.getCleanName(containerName))) {
            Node containerNode = node.addNode(mapper.getCleanName(containerName), jcrChildNode.containerNodeType());
            if (jcrChildNode != null && jcrChildNode.containerMixinTypes() != null) {
                for (String mixinType : jcrChildNode.containerMixinTypes()) {
                    if (!containerNode.canAddMixin(mixinType)) continue;
                    containerNode.addMixin(mixinType);
                }
            }
            return containerNode;
        }
        return node.getNode(mapper.getCleanName(containerName));
    }

    private static void addSingleChildToNode(Field field, JcrChildNode jcrChildNode, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        if (jcrChildNode.createContainerNode()) {
            Node childContainer = ChildNodeMapper.createChildNodeContainer(node, nodeName, jcrChildNode, mapper);
            if (!childContainer.hasNodes()) {
                if (field.get(obj) != null) {
                    mapper.addNode(childContainer, field.get(obj), null);
                }
            } else if (field.get(obj) != null) {
                Object childObj = field.get(obj);
                mapper.updateNode(childContainer.getNodes().nextNode(), childObj, childObj.getClass(), nodeFilter, depth + 1);
            } else {
                ChildNodeMapper.removeChildren(childContainer);
            }
        } else if (!node.hasNode(nodeName)) {
            if (field.get(obj) != null) {
                Object childObj = field.get(obj);
                Mapper.setNodeName(childObj, nodeName);
                mapper.addNode(node, childObj, null);
            }
        } else if (field.get(obj) != null) {
            Object childObj = field.get(obj);
            Mapper.setNodeName(childObj, nodeName);
            mapper.updateNode(node.getNode(nodeName), childObj, childObj.getClass(), nodeFilter, depth + 1);
        } else {
            NodeIterator nodeIterator = node.getNodes(nodeName);
            while (nodeIterator.hasNext()) {
                nodeIterator.nextNode().remove();
            }
        }
    }

    private static void addMultipleChildrenToNode(Field field, JcrChildNode jcrChildNode, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        Node childContainer = ChildNodeMapper.createChildNodeContainer(node, nodeName, jcrChildNode, mapper);
        List children = (List)field.get(obj);
        if (children != null && !children.isEmpty()) {
            if (childContainer.hasNodes()) {
                NodeIterator childNodes = childContainer.getNodes();
                while (childNodes.hasNext()) {
                    Node child = childNodes.nextNode();
                    Object childEntity = Mapper.findEntityByPath(children, child.getPath());
                    if (childEntity == null) {
                        child.remove();
                        continue;
                    }
                    mapper.updateNode(child, childEntity, childEntity.getClass(), nodeFilter, depth + 1);
                }
                for (int i = 0; i < children.size(); ++i) {
                    Object child = children.get(i);
                    String childPath = Mapper.getNodePath(child);
                    if (childPath != null && !childPath.equals("") && childContainer.hasNode(mapper.getCleanName(Mapper.getNodeName(child)))) continue;
                    mapper.addNode(childContainer, child, null);
                }
            } else {
                for (int i = 0; i < children.size(); ++i) {
                    mapper.addNode(childContainer, children.get(i), null);
                }
            }
        } else {
            ChildNodeMapper.removeChildren(childContainer);
        }
    }

    private static void addMapOfChildrenToNode(Field field, JcrChildNode jcrChildNode, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        Node childContainer = ChildNodeMapper.createChildNodeContainer(node, nodeName, jcrChildNode, mapper);
        Map childMap = (Map)field.get(obj);
        if (childMap != null && !childMap.isEmpty()) {
            Class paramClass = ReflectionUtils.getParameterizedClass(field, 1);
            if (childContainer.hasNodes()) {
                HashMap<String, String> mapWithCleanKeys = new HashMap<String, String>();
                for (String key : childMap.keySet()) {
                    String cleanKey = mapper.getCleanName(key);
                    if (childContainer.hasNode(cleanKey)) {
                        if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
                            childContainer.getNode(cleanKey).remove();
                            Node listContainer = childContainer.addNode(cleanKey);
                            List childList = (List)childMap.get(key);
                            for (int i = 0; i < childList.size(); ++i) {
                                mapper.addNode(listContainer, childList.get(i), null);
                            }
                        } else {
                            mapper.updateNode(childContainer.getNode(cleanKey), childMap.get(key), paramClass, nodeFilter, depth + 1);
                        }
                    } else {
                        ChildNodeMapper.addMapChild(paramClass, childContainer, childMap, key, cleanKey, mapper);
                    }
                    mapWithCleanKeys.put(cleanKey, "1");
                }
                NodeIterator childNodes = childContainer.getNodes();
                while (childNodes.hasNext()) {
                    Node child = childNodes.nextNode();
                    if (mapWithCleanKeys.containsKey(child.getName())) continue;
                    child.remove();
                }
            } else {
                for (String key : childMap.keySet()) {
                    String cleanKey = mapper.getCleanName(key);
                    ChildNodeMapper.addMapChild(paramClass, childContainer, childMap, key, cleanKey, mapper);
                }
            }
        } else {
            ChildNodeMapper.removeChildren(childContainer);
        }
    }

    private static void addMapChild(Class paramClass, Node childContainer, Map childMap, String key, String cleanKey, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
            List childList = (List)childMap.get(key);
            Node listContainer = childContainer.addNode(cleanKey);
            for (int i = 0; i < childList.size(); ++i) {
                mapper.addNode(listContainer, childList.get(i), null);
            }
        } else {
            Mapper.setNodeName(childMap.get(key), cleanKey);
            mapper.addNode(childContainer, childMap.get(key), null);
        }
    }

    private static void setChildren(Field field, Object obj, Node node, int depth, NodeFilter nodeFilter, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        JcrChildNode jcrChildNode = field.getAnnotation(JcrChildNode.class);
        String nodeName = ChildNodeMapper.getNodeName(field);
        if (nodeFilter == null || nodeFilter.isIncluded(field.getName(), depth)) {
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                ChildNodeMapper.addMultipleChildrenToNode(field, jcrChildNode, obj, nodeName, node, mapper, depth, nodeFilter);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                ChildNodeMapper.addMapOfChildrenToNode(field, jcrChildNode, obj, nodeName, node, mapper, depth, nodeFilter);
            } else {
                ChildNodeMapper.addSingleChildToNode(field, jcrChildNode, obj, nodeName, node, mapper, depth, nodeFilter);
            }
        }
    }

    static void addChildren(Field field, Object entity, Node node, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        ChildNodeMapper.setChildren(field, entity, node, -1, null, mapper);
    }

    static void updateChildren(Field field, Object obj, Node node, int depth, NodeFilter nodeFilter, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        ChildNodeMapper.setChildren(field, obj, node, depth, nodeFilter, mapper);
    }

    static List getChildrenList(Class childObjClass, Node childrenContainer, Object parentObj, Mapper mapper, int depth, NodeFilter nodeFilter) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        ArrayList<Object> children = new ArrayList<Object>();
        NodeIterator iterator = childrenContainer.getNodes();
        while (iterator.hasNext()) {
            Node childNode = iterator.nextNode();
            children.add(ChildNodeMapper.getSingleChild(childObjClass, childNode, parentObj, mapper, depth, nodeFilter));
        }
        return children;
    }

    private static Map getChildrenMap(Class mapParamClass, Node childrenContainer, Object parentObj, Mapper mapper, int depth, NodeFilter nodeFilter, JcrChildNode jcrChildNode) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        HashMap<String, Object> children = new HashMap<String, Object>();
        NodeIterator iterator = childrenContainer.getNodes();
        while (iterator.hasNext()) {
            Node childNode = iterator.nextNode();
            if (ReflectionUtils.implementsInterface(mapParamClass, List.class)) {
                if (jcrChildNode.lazy()) {
                    children.put(childNode.getName(), ProxyFactory.createChildNodeListProxy(Object.class, parentObj, childNode.getSession(), childNode.getPath(), mapper, depth, nodeFilter));
                    continue;
                }
                children.put(childNode.getName(), ChildNodeMapper.getChildrenList(Object.class, childNode, parentObj, mapper, depth, nodeFilter));
                continue;
            }
            if (jcrChildNode.lazy()) {
                children.put(childNode.getName(), ProxyFactory.createChildNodeProxy(mapper.findClassFromNode(Object.class, childNode), parentObj, childNode.getSession(), childNode.getPath(), mapper, depth, nodeFilter, false));
                continue;
            }
            children.put(childNode.getName(), ChildNodeMapper.getSingleChild(Object.class, childNode, parentObj, mapper, depth, nodeFilter));
        }
        return children;
    }

    static Object getSingleChild(Class childObjClass, Node childNode, Object obj, Mapper mapper, int depth, NodeFilter nodeFilter) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        childNode = mapper.checkIfVersionedChild(childNode);
        Object childObj = mapper.createInstanceForNode(childObjClass, childNode);
        childObj = mapper.mapNodeToClass(childObj, childNode, nodeFilter, obj, depth + 1);
        return childObj;
    }

    static void getChildrenFromNode(Field field, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        boolean childHasNodes;
        String nodeName = ChildNodeMapper.getNodeName(field);
        JcrChildNode jcrChildNode = field.getAnnotation(JcrChildNode.class);
        boolean bl = childHasNodes = node.hasNode(nodeName) && (node.getNode(nodeName).hasNodes() || node.getNode(nodeName).hasProperty("jcr:childVersionHistory"));
        if (node.hasNode(nodeName) && (childHasNodes || !jcrChildNode.createContainerNode() && !ReflectionUtils.implementsInterface(field.getType(), List.class) && !ReflectionUtils.implementsInterface(field.getType(), Map.class)) && nodeFilter.isIncluded(field.getName(), depth)) {
            Node childrenContainer = node.getNode(nodeName);
            childrenContainer = mapper.checkIfVersionedChild(childrenContainer);
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                Class childObjClass = ReflectionUtils.getParameterizedClass(field);
                List children = jcrChildNode.lazy() ? ProxyFactory.createChildNodeListProxy(childObjClass, obj, node.getSession(), childrenContainer.getPath(), mapper, depth, nodeFilter) : ChildNodeMapper.getChildrenList(childObjClass, childrenContainer, obj, mapper, depth, nodeFilter);
                field.set(obj, children);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                Class mapParamClass = ReflectionUtils.getParameterizedClass(field, 1);
                field.set(obj, ChildNodeMapper.getChildrenMap(mapParamClass, childrenContainer, obj, mapper, depth, nodeFilter, jcrChildNode));
            } else {
                Class<?> childObjClass = field.getType();
                if (childrenContainer.hasNodes() || !jcrChildNode.createContainerNode()) {
                    if (jcrChildNode.lazy()) {
                        field.set(obj, ProxyFactory.createChildNodeProxy(childObjClass, obj, node.getSession(), childrenContainer.getPath(), mapper, depth, nodeFilter, jcrChildNode.createContainerNode()));
                    } else if (jcrChildNode.createContainerNode()) {
                        field.set(obj, ChildNodeMapper.getSingleChild(childObjClass, childrenContainer.getNodes().nextNode(), obj, mapper, depth, nodeFilter));
                    } else {
                        field.set(obj, ChildNodeMapper.getSingleChild(childObjClass, childrenContainer, obj, mapper, depth, nodeFilter));
                    }
                }
            }
        }
    }
}

