/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import net.sf.cglib.proxy.LazyLoader;
import org.jcrom.FileNodeMapper;
import org.jcrom.Mapper;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.util.NodeFilter;

public class FileNodeLoader
implements LazyLoader {
    private static final Logger logger = Logger.getLogger(FileNodeLoader.class.getName());
    private final Class objectClass;
    private final Node fileContainer;
    private final Object parentObject;
    private final JcrFileNode jcrFileNode;
    private final int depth;
    private final NodeFilter nodeFilter;
    private final Mapper mapper;

    FileNodeLoader(Class objectClass, Node fileContainer, Object parentObject, JcrFileNode jcrFileNode, int depth, NodeFilter nodeFilter, Mapper mapper) {
        this.objectClass = objectClass;
        this.parentObject = parentObject;
        this.jcrFileNode = jcrFileNode;
        this.fileContainer = fileContainer;
        this.mapper = mapper;
        this.depth = depth;
        this.nodeFilter = nodeFilter;
    }

    public Object loadObject() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy loading file node for " + this.fileContainer.getPath());
        }
        return FileNodeMapper.getSingleFile(this.objectClass, this.fileContainer, this.parentObject, this.jcrFileNode, this.depth, this.nodeFilter, this.mapper);
    }
}

