/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.jcrom.JcrDataProvider;
import org.jcrom.JcrDataProviderImpl;
import org.jcrom.JcrFile;
import org.jcrom.Mapper;
import org.jcrom.ProxyFactory;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrNode;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileNodeMapper {
    FileNodeMapper() {
    }

    private static String getNodeName(Field field) {
        JcrFileNode jcrFileNode = field.getAnnotation(JcrFileNode.class);
        String name = field.getName();
        if (!jcrFileNode.name().equals("fieldName")) {
            name = jcrFileNode.name();
        }
        return name;
    }

    private static Node createFileFolderNode(JcrNode jcrNode, String containerName, Node parentNode, Mapper mapper) throws RepositoryException {
        if (!parentNode.hasNode(mapper.getCleanName(containerName))) {
            if (jcrNode != null && jcrNode.nodeType().equals("nt:unstructured")) {
                return parentNode.addNode(mapper.getCleanName(containerName));
            }
            return parentNode.addNode(mapper.getCleanName(containerName), "nt:folder");
        }
        return parentNode.getNode(mapper.getCleanName(containerName));
    }

    private static <T extends JcrFile> void setFileNodeProperties(Node contentNode, T file) throws RepositoryException, IOException {
        JcrDataProvider dataProvider;
        contentNode.setProperty("jcr:mimeType", file.getMimeType());
        contentNode.setProperty("jcr:lastModified", file.getLastModified());
        if (file.getEncoding() != null) {
            contentNode.setProperty("jcr:encoding", file.getEncoding());
        }
        if ((dataProvider = file.getDataProvider()) != null) {
            if (dataProvider.getType() == JcrDataProvider.TYPE.FILE && dataProvider.getFile() != null) {
                contentNode.setProperty("jcr:data", (InputStream)new FileInputStream(dataProvider.getFile()));
            } else if (dataProvider.getType() == JcrDataProvider.TYPE.BYTES && dataProvider.getBytes() != null) {
                contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(dataProvider.getBytes()));
            } else if (dataProvider.getType() == JcrDataProvider.TYPE.STREAM && dataProvider.getInputStream() != null) {
                contentNode.setProperty("jcr:data", dataProvider.getInputStream());
            }
        }
    }

    private static <T extends JcrFile> void addFileNode(JcrNode jcrNode, Node parentNode, T file, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        Node fileNode = jcrNode == null || jcrNode.nodeType().equals("nt:unstructured") ? parentNode.addNode(mapper.getCleanName(file.getName())) : parentNode.addNode(mapper.getCleanName(file.getName()), jcrNode.nodeType());
        if (jcrNode != null && jcrNode.mixinTypes() != null) {
            for (String mixinType : jcrNode.mixinTypes()) {
                if (!fileNode.canAddMixin(mixinType)) continue;
                fileNode.addMixin(mixinType);
            }
        }
        file.setName(fileNode.getName());
        file.setPath(fileNode.getPath());
        if (fileNode.hasProperty("jcr:uuid")) {
            Mapper.setUUID(file, fileNode.getUUID());
        }
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        FileNodeMapper.setFileNodeProperties(contentNode, file);
        mapper.addNode(fileNode, file, null, false);
    }

    static <T extends JcrFile> void addFileNode(Node fileNode, T file, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        file.setName(fileNode.getName());
        file.setPath(fileNode.getPath());
        if (fileNode.hasProperty("jcr:uuid")) {
            Mapper.setUUID(file, fileNode.getUUID());
        }
        Node contentNode = fileNode.hasNode("jcr:content") ? fileNode.getNode("jcr:content") : fileNode.addNode("jcr:content", "nt:resource");
        FileNodeMapper.setFileNodeProperties(contentNode, file);
    }

    private static <T extends JcrFile> void updateFileNode(Node fileNode, T file, NodeFilter nodeFilter, int depth, Mapper mapper) throws RepositoryException, IllegalAccessException, IOException {
        Node contentNode = fileNode.getNode("jcr:content");
        FileNodeMapper.setFileNodeProperties(contentNode, file);
        mapper.updateNode(fileNode, file, file.getClass(), nodeFilter, depth + 1);
    }

    private static void removeChildren(Node containerNode) throws RepositoryException {
        NodeIterator nodeIterator = containerNode.getNodes();
        while (nodeIterator.hasNext()) {
            nodeIterator.nextNode().remove();
        }
    }

    private static void addSingleFileToNode(Field field, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        JcrNode fileJcrNode = ReflectionUtils.getJcrNodeAnnotation(field.getType());
        Node fileContainer = FileNodeMapper.createFileFolderNode(fileJcrNode, nodeName, node, mapper);
        if (!fileContainer.hasNodes()) {
            if (field.get(obj) != null) {
                FileNodeMapper.addFileNode(fileJcrNode, fileContainer, (JcrFile)field.get(obj), mapper);
            }
        } else if (field.get(obj) != null) {
            FileNodeMapper.updateFileNode(fileContainer.getNodes().nextNode(), (JcrFile)field.get(obj), nodeFilter, depth, mapper);
        } else {
            FileNodeMapper.removeChildren(fileContainer);
        }
    }

    private static void updateFileList(List children, Node fileContainer, JcrNode fileJcrNode, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        if (children != null && !children.isEmpty()) {
            if (fileContainer.hasNodes()) {
                NodeIterator childNodes = fileContainer.getNodes();
                while (childNodes.hasNext()) {
                    Node child = childNodes.nextNode();
                    JcrFile childEntity = (JcrFile)Mapper.findEntityByPath(children, child.getPath());
                    if (childEntity == null) {
                        child.remove();
                        continue;
                    }
                    FileNodeMapper.updateFileNode(child, childEntity, nodeFilter, depth, mapper);
                }
                for (int i = 0; i < children.size(); ++i) {
                    Object child = children.get(i);
                    String childPath = Mapper.getNodePath(child);
                    if (childPath != null && !childPath.equals("") && fileContainer.hasNode(mapper.getCleanName(Mapper.getNodeName(child)))) continue;
                    FileNodeMapper.addFileNode(fileJcrNode, fileContainer, (JcrFile)child, mapper);
                }
            } else {
                for (int i = 0; i < children.size(); ++i) {
                    FileNodeMapper.addFileNode(fileJcrNode, fileContainer, (JcrFile)children.get(i), mapper);
                }
            }
        } else {
            FileNodeMapper.removeChildren(fileContainer);
        }
    }

    private static void addMultipleFilesToNode(Field field, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        JcrNode fileJcrNode = ReflectionUtils.getJcrNodeAnnotation(ReflectionUtils.getParameterizedClass(field));
        Node fileContainer = FileNodeMapper.createFileFolderNode(fileJcrNode, nodeName, node, mapper);
        List children = (List)field.get(obj);
        FileNodeMapper.updateFileList(children, fileContainer, fileJcrNode, mapper, depth, nodeFilter);
    }

    private static void addMapOfFilesToNode(Field field, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        Class fileClass = ReflectionUtils.implementsInterface(ReflectionUtils.getParameterizedClass(field, 1), List.class) ? ReflectionUtils.getTypeArgumentOfParameterizedClass(field, 1, 0) : ReflectionUtils.getParameterizedClass(field, 1);
        JcrNode fileJcrNode = ReflectionUtils.getJcrNodeAnnotation(fileClass);
        String cleanName = mapper.getCleanName(nodeName);
        Node fileContainer = node.hasNode(cleanName) ? node.getNode(cleanName) : node.addNode(cleanName);
        Map children = (Map)field.get(obj);
        if (children != null && !children.isEmpty()) {
            Class paramClass = ReflectionUtils.getParameterizedClass(field, 1);
            if (fileContainer.hasNodes()) {
                HashMap<String, String> mapWithCleanKeys = new HashMap<String, String>();
                for (String key : children.keySet()) {
                    String cleanKey = mapper.getCleanName(key);
                    if (fileContainer.hasNode(cleanKey)) {
                        if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
                            List childList = (List)children.get(key);
                            Node listContainer = FileNodeMapper.createFileFolderNode(fileJcrNode, cleanKey, fileContainer, mapper);
                            FileNodeMapper.updateFileList(childList, listContainer, fileJcrNode, mapper, depth, nodeFilter);
                        } else {
                            FileNodeMapper.updateFileNode(fileContainer.getNode(cleanKey), (JcrFile)children.get(key), nodeFilter, depth, mapper);
                        }
                    } else {
                        FileNodeMapper.addMapFile(paramClass, fileJcrNode, fileContainer, children, key, mapper);
                    }
                    mapWithCleanKeys.put(cleanKey, "1");
                }
                NodeIterator childNodes = fileContainer.getNodes();
                while (childNodes.hasNext()) {
                    Node child = childNodes.nextNode();
                    if (mapWithCleanKeys.containsKey(child.getName())) continue;
                    child.remove();
                }
            } else {
                for (String key : children.keySet()) {
                    FileNodeMapper.addMapFile(paramClass, fileJcrNode, fileContainer, children, key, mapper);
                }
            }
        } else {
            FileNodeMapper.removeChildren(fileContainer);
        }
    }

    private static void addMapFile(Class paramClass, JcrNode fileJcrNode, Node fileContainer, Map childMap, String key, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
            List childList = (List)childMap.get(key);
            Node listContainer = FileNodeMapper.createFileFolderNode(fileJcrNode, mapper.getCleanName(key), fileContainer, mapper);
            for (int i = 0; i < childList.size(); ++i) {
                FileNodeMapper.addFileNode(fileJcrNode, listContainer, (JcrFile)childList.get(i), mapper);
            }
        } else {
            FileNodeMapper.addFileNode(fileJcrNode, fileContainer, (JcrFile)childMap.get(key), mapper);
        }
    }

    private static void setFiles(Field field, Object obj, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        String nodeName = FileNodeMapper.getNodeName(field);
        if (nodeFilter == null || nodeFilter.isIncluded(field.getName(), depth)) {
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                FileNodeMapper.addMultipleFilesToNode(field, obj, nodeName, node, mapper, depth, nodeFilter);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                FileNodeMapper.addMapOfFilesToNode(field, obj, nodeName, node, mapper, depth, nodeFilter);
            } else {
                FileNodeMapper.addSingleFileToNode(field, obj, nodeName, node, mapper, depth, nodeFilter);
            }
        }
    }

    private static <T extends JcrFile> void mapNodeToFileObject(JcrFileNode jcrFileNode, T fileObj, Node fileNode, NodeFilter nodeFilter, Object parentObject, int depth, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        Node contentNode = fileNode.getNode("jcr:content");
        fileObj.setName(fileNode.getName());
        fileObj.setPath(fileNode.getPath());
        fileObj.setMimeType(contentNode.getProperty("jcr:mimeType").getString());
        fileObj.setLastModified(contentNode.getProperty("jcr:lastModified").getDate());
        if (contentNode.hasProperty("jcr:encoding")) {
            fileObj.setEncoding(contentNode.getProperty("jcr:encoding").getString());
        }
        if (jcrFileNode == null || jcrFileNode.loadType() == JcrFileNode.LoadType.STREAM) {
            JcrDataProviderImpl dataProvider = new JcrDataProviderImpl(JcrDataProvider.TYPE.STREAM, contentNode.getProperty("jcr:data").getStream(), contentNode.getProperty("jcr:data").getLength());
            fileObj.setDataProvider(dataProvider);
        } else if (jcrFileNode.loadType() == JcrFileNode.LoadType.BYTES) {
            JcrDataProviderImpl dataProvider = new JcrDataProviderImpl(JcrDataProvider.TYPE.BYTES, Mapper.readBytes(contentNode.getProperty("jcr:data").getStream()));
            fileObj.setDataProvider(dataProvider);
        }
        fileObj = (JcrFile)mapper.mapNodeToClass(fileObj, fileNode, nodeFilter, parentObject, depth + 1);
    }

    static void addFiles(Field field, Object obj, Node node, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        FileNodeMapper.setFiles(field, obj, node, mapper, -1, null);
    }

    static void updateFiles(Field field, Object obj, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        FileNodeMapper.setFiles(field, obj, node, mapper, depth, nodeFilter);
    }

    static List getFileList(Class childObjClass, Node fileContainer, Object obj, JcrFileNode jcrFileNode, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        ArrayList<JcrFile> children = new ArrayList<JcrFile>();
        NodeIterator iterator = fileContainer.getNodes();
        while (iterator.hasNext()) {
            JcrFile fileObj = (JcrFile)childObjClass.newInstance();
            FileNodeMapper.mapNodeToFileObject(jcrFileNode, fileObj, iterator.nextNode(), nodeFilter, obj, depth, mapper);
            children.add(fileObj);
        }
        return children;
    }

    static void mapSingleFile(JcrFile fileObj, Node fileNode, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        FileNodeMapper.mapNodeToFileObject(null, fileObj, fileNode, nodeFilter, obj, depth, mapper);
    }

    static JcrFile getSingleFile(Class childObjClass, Node fileContainer, Object obj, JcrFileNode jcrFileNode, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        JcrFile fileObj = (JcrFile)childObjClass.newInstance();
        FileNodeMapper.mapNodeToFileObject(jcrFileNode, fileObj, fileContainer.getNodes().nextNode(), nodeFilter, obj, depth, mapper);
        return fileObj;
    }

    private static Map getFileMap(Field field, Node fileContainer, JcrFileNode jcrFileNode, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        Class mapParamClass = ReflectionUtils.getParameterizedClass(field, 1);
        HashMap<String, Object> children = new HashMap<String, Object>();
        NodeIterator iterator = fileContainer.getNodes();
        while (iterator.hasNext()) {
            Node childNode = iterator.nextNode();
            if (ReflectionUtils.implementsInterface(mapParamClass, List.class)) {
                Class childObjClass = ReflectionUtils.getTypeArgumentOfParameterizedClass(field, 1, 0);
                if (jcrFileNode.lazy()) {
                    children.put(childNode.getName(), ProxyFactory.createFileNodeListProxy(childObjClass, fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper));
                    continue;
                }
                children.put(childNode.getName(), FileNodeMapper.getFileList(childObjClass, childNode, obj, jcrFileNode, depth, nodeFilter, mapper));
                continue;
            }
            if (jcrFileNode.lazy()) {
                children.put(childNode.getName(), ProxyFactory.createFileNodeProxy(mapParamClass, fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper));
                continue;
            }
            children.put(childNode.getName(), FileNodeMapper.getSingleFile(mapParamClass, fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper));
        }
        return children;
    }

    static void getFilesFromNode(Field field, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        String nodeName = FileNodeMapper.getNodeName(field);
        JcrFileNode jcrFileNode = field.getAnnotation(JcrFileNode.class);
        if (node.hasNode(nodeName) && nodeFilter.isIncluded(field.getName(), depth)) {
            Node fileContainer = node.getNode(nodeName);
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                Class childObjClass = ReflectionUtils.getParameterizedClass(field);
                List children = jcrFileNode.lazy() ? ProxyFactory.createFileNodeListProxy(childObjClass, fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper) : FileNodeMapper.getFileList(childObjClass, fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper);
                field.set(obj, children);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                field.set(obj, FileNodeMapper.getFileMap(field, fileContainer, jcrFileNode, obj, depth, nodeFilter, mapper));
            } else if (fileContainer.hasNodes()) {
                if (jcrFileNode.lazy()) {
                    field.set(obj, ProxyFactory.createFileNodeProxy(field.getType(), fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper));
                } else {
                    field.set(obj, FileNodeMapper.getSingleFile(field.getType(), fileContainer, obj, jcrFileNode, depth, nodeFilter, mapper));
                }
            }
        }
    }
}

