/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jcrom.JcrDataProvider;

public class JcrDataProviderImpl
implements JcrDataProvider {
    protected final JcrDataProvider.TYPE type;
    protected final byte[] bytes;
    protected final File file;
    protected final InputStream inputStream;
    protected final long contentLength;

    public JcrDataProviderImpl(JcrDataProvider.TYPE type, byte[] bytes) {
        this.type = type;
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
        this.file = null;
        this.inputStream = null;
        this.contentLength = bytes.length;
    }

    public JcrDataProviderImpl(JcrDataProvider.TYPE type, File file) {
        this.type = type;
        this.file = file;
        this.bytes = null;
        this.inputStream = null;
        this.contentLength = file.length();
    }

    public JcrDataProviderImpl(JcrDataProvider.TYPE type, InputStream inputStream) {
        this.type = type;
        this.inputStream = inputStream;
        this.bytes = null;
        this.file = null;
        this.contentLength = -1L;
    }

    public JcrDataProviderImpl(JcrDataProvider.TYPE type, InputStream inputStream, long length) {
        this.type = type;
        this.inputStream = inputStream;
        this.bytes = null;
        this.file = null;
        this.contentLength = length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public JcrDataProvider.TYPE getType() {
        return this.type;
    }

    public void writeToFile(File destination) throws IOException {
        if (this.type == JcrDataProvider.TYPE.BYTES) {
            JcrDataProviderImpl.write(this.bytes, destination);
        } else if (this.type == JcrDataProvider.TYPE.STREAM) {
            JcrDataProviderImpl.write(this.inputStream, destination);
        } else if (this.type == JcrDataProvider.TYPE.FILE) {
            JcrDataProviderImpl.write(this.file, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write(InputStream in, File destination) throws IOException {
        if (!destination.exists()) {
            destination.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(destination);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write(byte[] bytes, File destination) throws IOException {
        if (!destination.exists()) {
            destination.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(destination);
        try {
            fileOutputStream.write(bytes);
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write(File source, File destination) throws IOException {
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destination);
        int doneCnt = -1;
        int bufSize = 32768;
        byte[] buf = new byte[bufSize];
        try {
            while ((doneCnt = in.read(buf, 0, bufSize)) >= 0) {
                if (doneCnt == 0) {
                    Thread.yield();
                    continue;
                }
                out.write(buf, 0, doneCnt);
            }
            out.flush();
        }
        finally {
            in.close();
            out.close();
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }
}

