/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import net.sf.cglib.proxy.LazyLoader;
import org.jcrom.ChildNodeMapper;
import org.jcrom.FileNodeMapper;
import org.jcrom.JcrFile;
import org.jcrom.JcrMappingException;
import org.jcrom.PropertyMapper;
import org.jcrom.ReferenceMapper;
import org.jcrom.annotations.JcrBaseVersionCreated;
import org.jcrom.annotations.JcrBaseVersionName;
import org.jcrom.annotations.JcrCheckedout;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.annotations.JcrCreated;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrName;
import org.jcrom.annotations.JcrNode;
import org.jcrom.annotations.JcrParentNode;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrProperty;
import org.jcrom.annotations.JcrReference;
import org.jcrom.annotations.JcrSerializedProperty;
import org.jcrom.annotations.JcrUUID;
import org.jcrom.annotations.JcrVersionCreated;
import org.jcrom.annotations.JcrVersionName;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.PathUtils;
import org.jcrom.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Mapper {
    static final String DEFAULT_FIELDNAME = "fieldName";
    private final CopyOnWriteArraySet<Class> mappedClasses = new CopyOnWriteArraySet();
    private final boolean cleanNames;
    private final boolean dynamicInstantiation;
    private final ThreadLocal<Map<String, Object>> history = new ThreadLocal();

    Mapper(boolean cleanNames, boolean dynamicInstantiation) {
        this.cleanNames = cleanNames;
        this.dynamicInstantiation = dynamicInstantiation;
    }

    void clearHistory() {
        this.history.remove();
    }

    boolean isMapped(Class c) {
        return this.mappedClasses.contains(c);
    }

    void addMappedClass(Class c) {
        this.mappedClasses.add(c);
    }

    CopyOnWriteArraySet<Class> getMappedClasses() {
        return this.mappedClasses;
    }

    boolean isCleanNames() {
        return this.cleanNames;
    }

    boolean isDynamicInstantiation() {
        return this.dynamicInstantiation;
    }

    String getCleanName(String name) {
        if (name == null) {
            throw new JcrMappingException("Node name is null");
        }
        if (this.cleanNames) {
            return PathUtils.createValidName(name);
        }
        return name;
    }

    static Object findEntityByPath(List entities, String path) throws IllegalAccessException {
        for (int i = 0; i < entities.size(); ++i) {
            Object entity = entities.get(i);
            if (!path.equals(Mapper.getNodePath(entity))) continue;
            return entity;
        }
        return null;
    }

    private static Field findAnnotatedField(Object obj, Class annotationClass) {
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), false)) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    static Field findPathField(Object obj) {
        return Mapper.findAnnotatedField(obj, JcrPath.class);
    }

    static Field findNameField(Object obj) {
        return Mapper.findAnnotatedField(obj, JcrName.class);
    }

    static Field findUUIDField(Object obj) {
        return Mapper.findAnnotatedField(obj, JcrUUID.class);
    }

    static String getNodeName(Object object) throws IllegalAccessException {
        return (String)Mapper.findNameField(object).get(object);
    }

    static String getNodePath(Object object) throws IllegalAccessException {
        return (String)Mapper.findPathField(object).get(object);
    }

    static String getNodeUUID(Object object) throws IllegalAccessException {
        return (String)Mapper.findUUIDField(object).get(object);
    }

    static boolean hasMixinType(Node node, String mixinType) throws RepositoryException {
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!nodeType.getName().equals(mixinType)) continue;
            return true;
        }
        return false;
    }

    static void setBaseVersionInfo(Object object, String name, Calendar created) throws IllegalAccessException {
        Field baseCreated;
        Field baseName = Mapper.findAnnotatedField(object, JcrBaseVersionName.class);
        if (baseName != null) {
            baseName.set(object, name);
        }
        if ((baseCreated = Mapper.findAnnotatedField(object, JcrBaseVersionCreated.class)) != null) {
            if (baseCreated.getType() == Date.class) {
                baseCreated.set(object, created.getTime());
            } else if (baseCreated.getType() == Timestamp.class) {
                baseCreated.set(object, new Timestamp(created.getTimeInMillis()));
            } else if (baseCreated.getType() == Calendar.class) {
                baseCreated.set(object, created);
            }
        }
    }

    static void setNodeName(Object object, String name) throws IllegalAccessException {
        Mapper.findNameField(object).set(object, name);
    }

    static void setNodePath(Object object, String path) throws IllegalAccessException {
        Mapper.findPathField(object).set(object, path);
    }

    static void setUUID(Object object, String uuid) throws IllegalAccessException {
        Field uuidField = Mapper.findUUIDField(object);
        if (uuidField != null) {
            uuidField.set(object, uuid);
        }
    }

    Node checkIfVersionedChild(Node node) throws RepositoryException {
        if (node.hasProperty("jcr:childVersionHistory")) {
            Node versionNode = node.getSession().getNodeByUUID(node.getProperty("jcr:childVersionHistory").getString());
            NodeIterator it = versionNode.getNodes();
            while (it.hasNext()) {
                Node n = it.nextNode();
                if (n.getName().equals("jcr:rootVersion") || !n.isNodeType("nt:version") || !n.hasNode("jcr:frozenNode") || node.getPath().indexOf("/" + n.getName() + "/") == -1) continue;
                return n.getNode("jcr:frozenNode");
            }
            return node;
        }
        return node;
    }

    Class findClassFromNode(Class defaultClass, Node node) throws RepositoryException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (this.dynamicInstantiation) {
            String classNameProperty = "className";
            JcrNode jcrNode = ReflectionUtils.getJcrNodeAnnotation(defaultClass);
            if (jcrNode != null && !jcrNode.classNameProperty().equals("none")) {
                classNameProperty = jcrNode.classNameProperty();
            }
            if (node.hasProperty(classNameProperty)) {
                String className = node.getProperty(classNameProperty).getString();
                Class<?> c = Class.forName(className);
                if (this.isMapped(c)) {
                    return c;
                }
                throw new JcrMappingException("Trying to instantiate unmapped class: " + c.getName());
            }
            return defaultClass;
        }
        return defaultClass;
    }

    Object createInstanceForNode(Class objClass, Node node) throws RepositoryException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        return this.findClassFromNode(objClass, node).newInstance();
    }

    Object fromNode(Class entityClass, Node node, NodeFilter nodeFilter) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        this.history.set(new HashMap());
        Object obj = this.createInstanceForNode(entityClass, node);
        if (ReflectionUtils.extendsClass(obj.getClass(), JcrFile.class)) {
            FileNodeMapper.mapSingleFile((JcrFile)obj, node, null, 0, nodeFilter, this);
        }
        this.mapNodeToClass(obj, node, nodeFilter, null, 0);
        this.history.remove();
        return obj;
    }

    String updateNode(Node node, Object entity, NodeFilter nodeFilter) throws RepositoryException, IllegalAccessException, IOException {
        return this.updateNode(node, entity, entity.getClass(), nodeFilter, 0);
    }

    String updateNode(Node node, Object obj, Class objClass, NodeFilter nodeFilter, int depth) throws RepositoryException, IllegalAccessException, IOException {
        JcrNode jcrNode;
        obj = this.clearCglib(obj);
        if (!node.getName().equals(this.getCleanName(Mapper.getNodeName(obj)))) {
            if (node.getParent().getPath().equals("/")) {
                node.getSession().move(node.getPath(), node.getParent().getPath() + this.getCleanName(Mapper.getNodeName(obj)));
            } else {
                node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + this.getCleanName(Mapper.getNodeName(obj)));
            }
            Mapper.setNodeName(obj, node.getName());
            Mapper.setNodePath(obj, node.getPath());
        }
        if ((jcrNode = ReflectionUtils.getJcrNodeAnnotation(objClass)) != null && !jcrNode.classNameProperty().equals("none")) {
            node.setProperty(jcrNode.classNameProperty(), obj.getClass().getCanonicalName());
        }
        if (ReflectionUtils.extendsClass(obj.getClass(), JcrFile.class) && depth == 0) {
            FileNodeMapper.addFileNode(node, (JcrFile)obj, this);
        }
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(objClass, true)) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(JcrProperty.class)) {
                PropertyMapper.mapFieldToProperty(field, obj, node, this);
                continue;
            }
            if (field.isAnnotationPresent(JcrSerializedProperty.class)) {
                PropertyMapper.mapSerializedFieldToProperty(field, obj, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrChildNode.class) && nodeFilter.isDepthIncluded(depth)) {
                ChildNodeMapper.updateChildren(field, obj, node, depth, nodeFilter, this);
                continue;
            }
            if (field.isAnnotationPresent(JcrReference.class)) {
                ReferenceMapper.updateReferences(field, obj, node, nodeFilter);
                continue;
            }
            if (!field.isAnnotationPresent(JcrFileNode.class) || !nodeFilter.isDepthIncluded(depth)) continue;
            FileNodeMapper.updateFiles(field, obj, node, this, depth, nodeFilter);
        }
        return node.getName();
    }

    Node addNode(Node parentNode, Object entity, String[] mixinTypes) throws IllegalAccessException, RepositoryException, IOException {
        return this.addNode(parentNode, entity, mixinTypes, true);
    }

    Node addNode(Node parentNode, Object entity, String[] mixinTypes, boolean createNode) throws IllegalAccessException, RepositoryException, IOException {
        Node node;
        entity = this.clearCglib(entity);
        JcrNode jcrNode = ReflectionUtils.getJcrNodeAnnotation(entity.getClass());
        if (createNode) {
            node = jcrNode == null || jcrNode.nodeType().equals("nt:unstructured") ? parentNode.addNode(this.getCleanName(Mapper.getNodeName(entity))) : parentNode.addNode(this.getCleanName(Mapper.getNodeName(entity)), jcrNode.nodeType());
            if (mixinTypes != null) {
                for (String string : mixinTypes) {
                    if (!node.canAddMixin(string)) continue;
                    node.addMixin(string);
                }
            }
            if (jcrNode != null && jcrNode.mixinTypes() != null) {
                for (String string : jcrNode.mixinTypes()) {
                    if (!node.canAddMixin(string)) continue;
                    node.addMixin(string);
                }
            }
            Mapper.setNodeName(entity, node.getName());
            Mapper.setNodePath(entity, node.getPath());
            if (node.hasProperty("jcr:uuid")) {
                Mapper.setUUID(entity, node.getUUID());
            }
        } else {
            node = parentNode;
        }
        if (jcrNode != null && !jcrNode.classNameProperty().equals("none")) {
            node.setProperty(jcrNode.classNameProperty(), entity.getClass().getCanonicalName());
        }
        if (ReflectionUtils.extendsClass(entity.getClass(), JcrFile.class)) {
            FileNodeMapper.addFileNode(node, (JcrFile)entity, this);
        }
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(entity.getClass(), true)) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(JcrProperty.class)) {
                PropertyMapper.mapFieldToProperty(field, entity, node, this);
                continue;
            }
            if (field.isAnnotationPresent(JcrSerializedProperty.class)) {
                PropertyMapper.mapSerializedFieldToProperty(field, entity, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrChildNode.class)) {
                ChildNodeMapper.addChildren(field, entity, node, this);
                continue;
            }
            if (field.isAnnotationPresent(JcrReference.class)) {
                ReferenceMapper.addReferences(field, entity, node);
                continue;
            }
            if (!field.isAnnotationPresent(JcrFileNode.class)) continue;
            FileNodeMapper.addFiles(field, entity, node, this);
        }
        return node;
    }

    private boolean isVersionable(Node node) throws RepositoryException {
        for (NodeType mixinType : node.getMixinNodeTypes()) {
            if (!mixinType.getName().equals("mix:versionable")) continue;
            return true;
        }
        return false;
    }

    Object mapNodeToClass(Object obj, Node node, NodeFilter nodeFilter, Object parentObject, int depth) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        if (!ReflectionUtils.extendsClass(obj.getClass(), JcrFile.class)) {
            Mapper.setNodeName(obj, node.getName());
        }
        if (this.history.get() == null) {
            this.history.set(new HashMap());
        }
        if (this.history.get().containsKey(node.getPath())) {
            return this.history.get().get(node.getPath());
        }
        this.history.get().put(node.getPath(), obj);
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), false)) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(JcrProperty.class)) {
                PropertyMapper.mapPropertyToField(obj, field, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrSerializedProperty.class)) {
                PropertyMapper.mapSerializedPropertyToField(obj, field, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrUUID.class)) {
                if (!node.hasProperty("jcr:uuid")) continue;
                field.set(obj, node.getUUID());
                continue;
            }
            if (field.isAnnotationPresent(JcrBaseVersionName.class)) {
                if (!this.isVersionable(node)) continue;
                field.set(obj, node.getBaseVersion().getName());
                continue;
            }
            if (field.isAnnotationPresent(JcrBaseVersionCreated.class)) {
                if (!this.isVersionable(node)) continue;
                field.set(obj, PropertyMapper.getValue(field.getType(), node.getSession().getValueFactory().createValue(node.getBaseVersion().getCreated())));
                continue;
            }
            if (field.isAnnotationPresent(JcrVersionName.class)) {
                if (node.getParent() != null && node.getParent().isNodeType("nt:version")) {
                    field.set(obj, node.getParent().getName());
                    continue;
                }
                if (!this.isVersionable(node)) continue;
                field.set(obj, node.getBaseVersion().getName());
                continue;
            }
            if (field.isAnnotationPresent(JcrVersionCreated.class)) {
                if (node.getParent() != null && node.getParent().isNodeType("nt:version")) {
                    Version version = (Version)node.getParent();
                    field.set(obj, PropertyMapper.getValue(field.getType(), node.getSession().getValueFactory().createValue(version.getCreated())));
                    continue;
                }
                if (!this.isVersionable(node)) continue;
                field.set(obj, PropertyMapper.getValue(field.getType(), node.getSession().getValueFactory().createValue(node.getBaseVersion().getCreated())));
                continue;
            }
            if (field.isAnnotationPresent(JcrCheckedout.class)) {
                field.set(obj, node.isCheckedOut());
                continue;
            }
            if (field.isAnnotationPresent(JcrCreated.class)) {
                if (!node.hasProperty("jcr:created")) continue;
                field.set(obj, PropertyMapper.getValue(field.getType(), node.getProperty("jcr:created").getValue()));
                continue;
            }
            if (field.isAnnotationPresent(JcrParentNode.class)) {
                if (parentObject == null || !field.getType().isInstance(parentObject)) continue;
                field.set(obj, parentObject);
                continue;
            }
            if (field.isAnnotationPresent(JcrChildNode.class) && nodeFilter.isDepthIncluded(depth)) {
                ChildNodeMapper.getChildrenFromNode(field, node, obj, depth, nodeFilter, this);
                continue;
            }
            if (field.isAnnotationPresent(JcrReference.class)) {
                ReferenceMapper.getReferencesFromNode(field, node, obj, depth, nodeFilter, this);
                continue;
            }
            if (field.isAnnotationPresent(JcrFileNode.class) && nodeFilter.isDepthIncluded(depth)) {
                FileNodeMapper.getFilesFromNode(field, node, obj, depth, nodeFilter, this);
                continue;
            }
            if (!field.isAnnotationPresent(JcrPath.class)) continue;
            field.set(obj, node.getPath());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
        return out.toByteArray();
    }

    private Object clearCglib(Object obj) throws IllegalAccessException {
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), true)) {
            field.setAccessible(true);
            if (!field.getName().equals("CGLIB$LAZY_LOADER_0")) continue;
            if (field.get(obj) != null) {
                return field.get(obj);
            }
            return this.triggerLazyLoading(obj);
        }
        return obj;
    }

    private Object triggerLazyLoading(Object obj) throws IllegalAccessException {
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), false)) {
            field.setAccessible(true);
            if (!field.getName().equals("CGLIB$CALLBACK_0")) continue;
            try {
                return ((LazyLoader)field.get(obj)).loadObject();
            }
            catch (Exception e) {
                throw new JcrMappingException("Could not trigger lazy loading", e);
            }
        }
        return obj;
    }
}

