/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.jcrom.Mapper;
import org.jcrom.annotations.JcrProperty;
import org.jcrom.annotations.JcrSerializedProperty;
import org.jcrom.util.ReflectionUtils;

class PropertyMapper {
    PropertyMapper() {
    }

    static void mapPropertiesToMap(Object obj, Field field, Class valueType, PropertyIterator propIterator) throws RepositoryException, IOException, IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (propIterator.hasNext()) {
            Property p = propIterator.nextProperty();
            if (p.getName().startsWith("jcr:") || p.getName().startsWith("nt:")) continue;
            if (valueType.isArray()) {
                if (p.getDefinition().isMultiple()) {
                    map.put(p.getName(), PropertyMapper.valuesToArray(valueType.getComponentType(), p.getValues()));
                    continue;
                }
                Value[] values = new Value[]{p.getValue()};
                map.put(p.getName(), PropertyMapper.valuesToArray(valueType.getComponentType(), values));
                continue;
            }
            map.put(p.getName(), PropertyMapper.getValue(valueType, p.getValue()));
        }
        field.set(obj, map);
    }

    private static Object[] valuesToArray(Class type, Value[] values) throws RepositoryException, IOException {
        Object[] arr = (Object[])Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            arr[i] = PropertyMapper.getValue(type, values[i]);
        }
        return arr;
    }

    static void mapSerializedPropertyToField(Object obj, Field field, Node node) throws RepositoryException, IOException, IllegalAccessException, ClassNotFoundException {
        String propertyName = PropertyMapper.getSerializedPropertyName(field);
        if (node.hasProperty(propertyName)) {
            Property p = node.getProperty(propertyName);
            field.set(obj, PropertyMapper.deserialize(p.getStream()));
        }
    }

    private static Locale parseLocale(String localeString) {
        if (localeString != null && localeString.length() > 0) {
            StringTokenizer st = new StringTokenizer(localeString, "_");
            String language = st.hasMoreElements() ? st.nextToken() : Locale.getDefault().getLanguage();
            String country = st.hasMoreElements() ? st.nextToken() : "";
            String variant = st.hasMoreElements() ? st.nextToken() : "";
            return new Locale(language, country, variant);
        }
        return null;
    }

    static Value createValue(Class c, Object fieldValue, ValueFactory valueFactory) {
        if (c == String.class) {
            return valueFactory.createValue((String)fieldValue);
        }
        if (c == Date.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)fieldValue);
            return valueFactory.createValue(cal);
        }
        if (c == Timestamp.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Timestamp)fieldValue).getTime());
            return valueFactory.createValue(cal);
        }
        if (c == Calendar.class) {
            return valueFactory.createValue((Calendar)fieldValue);
        }
        if (c == InputStream.class) {
            return valueFactory.createValue((InputStream)fieldValue);
        }
        if (c.isArray() && c.getComponentType() == Byte.TYPE) {
            return valueFactory.createValue((InputStream)new ByteArrayInputStream((byte[])fieldValue));
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return valueFactory.createValue((long)((Integer)fieldValue).intValue());
        }
        if (c == Long.class || c == Long.TYPE) {
            return valueFactory.createValue(((Long)fieldValue).longValue());
        }
        if (c == Double.class || c == Double.TYPE) {
            return valueFactory.createValue(((Double)fieldValue).doubleValue());
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return valueFactory.createValue(((Boolean)fieldValue).booleanValue());
        }
        if (c == Locale.class) {
            return valueFactory.createValue(((Locale)fieldValue).toString());
        }
        if (c.isEnum()) {
            return valueFactory.createValue(fieldValue.toString());
        }
        return null;
    }

    static Object getValue(Class c, Value value) throws RepositoryException, IOException {
        if (c == String.class) {
            return value.getString();
        }
        if (c == Date.class) {
            return value.getDate().getTime();
        }
        if (c == Timestamp.class) {
            return new Timestamp(value.getDate().getTimeInMillis());
        }
        if (c == Calendar.class) {
            return value.getDate();
        }
        if (c == InputStream.class) {
            return value.getStream();
        }
        if (c.isArray() && c.getComponentType() == Byte.TYPE) {
            return Mapper.readBytes(value.getStream());
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return (int)value.getDouble();
        }
        if (c == Long.class || c == Long.TYPE) {
            return value.getLong();
        }
        if (c == Double.class || c == Double.TYPE) {
            return value.getDouble();
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return value.getBoolean();
        }
        if (c == Locale.class) {
            return PropertyMapper.parseLocale(value.getString());
        }
        if (c.isEnum()) {
            return Enum.valueOf(c, value.getString());
        }
        return null;
    }

    private static String getSerializedPropertyName(Field field) {
        JcrSerializedProperty jcrProperty = field.getAnnotation(JcrSerializedProperty.class);
        String propertyName = field.getName();
        if (!jcrProperty.name().equals("fieldName")) {
            propertyName = jcrProperty.name();
        }
        return propertyName;
    }

    private static String getPropertyName(Field field) {
        JcrProperty jcrProperty = field.getAnnotation(JcrProperty.class);
        String name = field.getName();
        if (!jcrProperty.name().equals("fieldName")) {
            name = jcrProperty.name();
        }
        return name;
    }

    static void mapPropertyToField(Object obj, Field field, Node node) throws RepositoryException, IllegalAccessException, IOException {
        String name = PropertyMapper.getPropertyName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
            Class valueType = ReflectionUtils.getParameterizedClass(field, 1);
            Node childrenContainer = node.getNode(name);
            PropertyIterator propIterator = childrenContainer.getProperties();
            PropertyMapper.mapPropertiesToMap(obj, field, valueType, propIterator);
        } else if (node.hasProperty(name)) {
            Property p = node.getProperty(name);
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                ArrayList<Object> properties = new ArrayList<Object>();
                Class paramClass = ReflectionUtils.getParameterizedClass(field);
                for (Value value : p.getValues()) {
                    properties.add(PropertyMapper.getValue(paramClass, value));
                }
                field.set(obj, properties);
            } else if (field.getType().isArray() && field.getType().getComponentType() != Byte.TYPE) {
                Value[] values = p.getValues();
                if (field.getType().getComponentType() == Integer.TYPE) {
                    int[] arr = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = (int)values[i].getDouble();
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Long.TYPE) {
                    long[] arr = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = values[i].getLong();
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Double.TYPE) {
                    double[] arr = new double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = values[i].getDouble();
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Boolean.TYPE) {
                    boolean[] arr = new boolean[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = values[i].getBoolean();
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Locale.class) {
                    Locale[] arr = new Locale[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = PropertyMapper.parseLocale(values[i].getString());
                    }
                    field.set(obj, arr);
                } else {
                    Object[] arr = PropertyMapper.valuesToArray(field.getType().getComponentType(), values);
                    field.set(obj, arr);
                }
            } else {
                field.set(obj, PropertyMapper.getValue(field.getType(), p.getValue()));
            }
        }
    }

    static void mapSerializedFieldToProperty(Field field, Object obj, Node node) throws IllegalAccessException, RepositoryException, IOException {
        String propertyName = PropertyMapper.getSerializedPropertyName(field);
        Object fieldValue = field.get(obj);
        if (fieldValue != null) {
            node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(PropertyMapper.serialize(fieldValue)));
        } else {
            node.setProperty(propertyName, (Value)null);
        }
    }

    private static void addChildMap(Field field, Object obj, Node node, String nodeName, Mapper mapper) throws RepositoryException, IllegalAccessException {
        Map map = (Map)field.get(obj);
        boolean nullOrEmpty = map == null || map.isEmpty();
        NodeIterator nodeIterator = node.getNodes(nodeName);
        while (nodeIterator.hasNext()) {
            nodeIterator.nextNode().remove();
        }
        Node childContainer = node.addNode(mapper.getCleanName(nodeName));
        if (!nullOrEmpty) {
            for (Map.Entry entry : map.entrySet()) {
                PropertyMapper.mapToProperty((String)entry.getKey(), ReflectionUtils.getParameterizedClass(field, 1), null, entry.getValue(), childContainer);
            }
        }
    }

    static void mapFieldToProperty(Field field, Object obj, Node node, Mapper mapper) throws RepositoryException, IllegalAccessException {
        String name = PropertyMapper.getPropertyName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
            PropertyMapper.addChildMap(field, obj, node, name, mapper);
        } else {
            Class paramClass = ReflectionUtils.implementsInterface(field.getType(), List.class) ? ReflectionUtils.getParameterizedClass(field) : null;
            PropertyMapper.mapToProperty(name, field.getType(), paramClass, field.get(obj), node);
        }
    }

    static void mapToProperty(String propertyName, Class type, Class paramClass, Object propertyValue, Node node) throws RepositoryException {
        if (propertyValue != null) {
            ValueFactory valueFactory = node.getSession().getValueFactory();
            if (ReflectionUtils.implementsInterface(type, List.class)) {
                List fieldValues = (List)propertyValue;
                if (!fieldValues.isEmpty()) {
                    Value[] values = new Value[fieldValues.size()];
                    for (int i = 0; i < fieldValues.size(); ++i) {
                        values[i] = PropertyMapper.createValue(paramClass, fieldValues.get(i), valueFactory);
                    }
                    node.setProperty(propertyName, values);
                } else {
                    node.setProperty(propertyName, new Value[0]);
                }
            } else if (type.isArray() && type.getComponentType() != Byte.TYPE) {
                Value[] values;
                if (type.getComponentType() == Integer.TYPE) {
                    int[] ints = (int[])propertyValue;
                    values = new Value[ints.length];
                    for (int i = 0; i < ints.length; ++i) {
                        values[i] = PropertyMapper.createValue(Integer.TYPE, ints[i], valueFactory);
                    }
                } else if (type.getComponentType() == Long.TYPE) {
                    long[] longs = (long[])propertyValue;
                    values = new Value[longs.length];
                    for (int i = 0; i < longs.length; ++i) {
                        values[i] = PropertyMapper.createValue(Long.TYPE, longs[i], valueFactory);
                    }
                } else if (type.getComponentType() == Double.TYPE) {
                    double[] doubles = (double[])propertyValue;
                    values = new Value[doubles.length];
                    for (int i = 0; i < doubles.length; ++i) {
                        values[i] = PropertyMapper.createValue(Double.TYPE, doubles[i], valueFactory);
                    }
                } else if (type.getComponentType() == Boolean.TYPE) {
                    boolean[] booleans = (boolean[])propertyValue;
                    values = new Value[booleans.length];
                    for (int i = 0; i < booleans.length; ++i) {
                        values[i] = PropertyMapper.createValue(Boolean.TYPE, booleans[i], valueFactory);
                    }
                } else if (type.getComponentType() == Locale.class) {
                    Locale[] locales = (Locale[])propertyValue;
                    values = new Value[locales.length];
                    for (int i = 0; i < locales.length; ++i) {
                        values[i] = PropertyMapper.createValue(Locale.class, locales[i], valueFactory);
                    }
                } else {
                    Object[] objects = (Object[])propertyValue;
                    values = new Value[objects.length];
                    for (int i = 0; i < objects.length; ++i) {
                        values[i] = PropertyMapper.createValue(type.getComponentType(), objects[i], valueFactory);
                    }
                }
                node.setProperty(propertyName, values);
            } else {
                Value value = PropertyMapper.createValue(type, propertyValue, valueFactory);
                if (value != null) {
                    node.setProperty(propertyName, value);
                }
            }
        } else if (ReflectionUtils.implementsInterface(type, List.class)) {
            node.setProperty(propertyName, (Value[])null);
        } else {
            node.setProperty(propertyName, (Value)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        try {
            out.writeObject(obj);
        }
        finally {
            out.close();
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserialize(InputStream byteStream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(byteStream);
        try {
            Object object = in.readObject();
            return object;
        }
        finally {
            in.close();
        }
    }
}

