/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import javax.jcr.Session;
import net.sf.cglib.proxy.LazyLoader;
import org.jcrom.Mapper;
import org.jcrom.ReferenceMapper;
import org.jcrom.util.NodeFilter;

public class ReferenceListLoader
implements LazyLoader {
    private static final Logger logger = Logger.getLogger(ReferenceListLoader.class.getName());
    private final Class objClass;
    private final Object parentObject;
    private final Session session;
    private final String nodePath;
    private final String propertyName;
    private final Mapper mapper;
    private final int depth;
    private final NodeFilter nodeFilter;
    private final Field field;

    ReferenceListLoader(Class objClass, Object parentObject, String nodePath, String propertyName, Session session, Mapper mapper, int depth, NodeFilter nodeFilter, Field field) {
        this.objClass = objClass;
        this.parentObject = parentObject;
        this.nodePath = nodePath;
        this.propertyName = propertyName;
        this.session = session;
        this.mapper = mapper;
        this.depth = depth;
        this.nodeFilter = nodeFilter;
        this.field = field;
    }

    public Object loadObject() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy loading reference list for " + this.nodePath + " " + this.propertyName);
        }
        Node node = this.session.getRootNode().getNode(this.nodePath.substring(1));
        return ReferenceMapper.getReferenceList(this.field, this.propertyName, this.objClass, node, this.parentObject, this.depth, this.nodeFilter, this.mapper);
    }
}

