/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.jcrom.Mapper;
import org.jcrom.ProxyFactory;
import org.jcrom.annotations.JcrReference;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceMapper {
    ReferenceMapper() {
    }

    private static String getPropertyName(Field field) {
        JcrReference jcrReference = field.getAnnotation(JcrReference.class);
        String name = field.getName();
        if (!jcrReference.name().equals("fieldName")) {
            name = jcrReference.name();
        }
        return name;
    }

    private static String relativePath(String path) {
        if (path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    private static List<Value> getReferenceValues(List references, Session session, JcrReference jcrReference) throws IllegalAccessException, RepositoryException {
        ArrayList<Value> refValues = new ArrayList<Value>();
        for (int i = 0; i < references.size(); ++i) {
            if (jcrReference.byPath()) {
                String referencePath = Mapper.getNodePath(references.get(i));
                if (referencePath == null || referencePath.equals("") || !session.getRootNode().hasNode(ReferenceMapper.relativePath(referencePath))) continue;
                refValues.add(session.getValueFactory().createValue(referencePath));
                continue;
            }
            String referenceUUID = Mapper.getNodeUUID(references.get(i));
            if (referenceUUID == null || referenceUUID.equals("")) continue;
            Node referencedNode = session.getNodeByUUID(referenceUUID);
            refValues.add(session.getValueFactory().createValue(referencedNode));
        }
        return refValues;
    }

    private static void addSingleReferenceToNode(Field field, Object obj, String propertyName, Node node) throws IllegalAccessException, RepositoryException {
        JcrReference jcrReference = field.getAnnotation(JcrReference.class);
        Object referenceObject = field.get(obj);
        if (referenceObject != null) {
            ReferenceMapper.mapSingleReference(jcrReference, referenceObject, node, propertyName);
        } else {
            node.setProperty(propertyName, (Value)null);
        }
    }

    private static void addMultipleReferencesToNode(Field field, Object obj, String propertyName, Node node) throws IllegalAccessException, RepositoryException {
        JcrReference jcrReference = field.getAnnotation(JcrReference.class);
        List references = (List)field.get(obj);
        if (references != null && !references.isEmpty()) {
            List<Value> refValues = ReferenceMapper.getReferenceValues(references, node.getSession(), jcrReference);
            if (!refValues.isEmpty()) {
                node.setProperty(propertyName, refValues.toArray(new Value[refValues.size()]));
            } else {
                node.setProperty(propertyName, (Value[])null);
            }
        } else {
            node.setProperty(propertyName, (Value[])null);
        }
    }

    private static void mapSingleReference(JcrReference jcrReference, Object referenceObject, Node containerNode, String propertyName) throws IllegalAccessException, RepositoryException {
        if (jcrReference.byPath()) {
            String referencePath = Mapper.getNodePath(referenceObject);
            if (referencePath != null && !referencePath.equals("") && containerNode.getSession().getRootNode().hasNode(ReferenceMapper.relativePath(referencePath))) {
                containerNode.setProperty(propertyName, containerNode.getSession().getValueFactory().createValue(referencePath));
            }
        } else {
            String referenceUUID = Mapper.getNodeUUID(referenceObject);
            if (referenceUUID != null && !referenceUUID.equals("")) {
                Node referencedNode = containerNode.getSession().getNodeByUUID(referenceUUID);
                containerNode.setProperty(propertyName, referencedNode);
            } else {
                containerNode.setProperty(propertyName, (Value)null);
            }
        }
    }

    private static void addMapOfReferencesToNode(Field field, Object obj, String containerName, Node node) throws IllegalAccessException, RepositoryException {
        JcrReference jcrReference = field.getAnnotation(JcrReference.class);
        if (node.hasNode(containerName)) {
            node.getNode(containerName).remove();
        }
        Node referenceContainer = node.addNode(containerName);
        Map referenceMap = (Map)field.get(obj);
        if (referenceMap != null && !referenceMap.isEmpty()) {
            Class paramClass = ReflectionUtils.getParameterizedClass(field, 1);
            for (String key : referenceMap.keySet()) {
                if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
                    List references = (List)referenceMap.get(key);
                    List<Value> refValues = ReferenceMapper.getReferenceValues(references, referenceContainer.getSession(), jcrReference);
                    if (refValues.isEmpty()) continue;
                    referenceContainer.setProperty(key, refValues.toArray(new Value[refValues.size()]));
                    continue;
                }
                Object referenceObject = referenceMap.get(key);
                ReferenceMapper.mapSingleReference(jcrReference, referenceObject, referenceContainer, key);
            }
        }
    }

    private static void setReferenceProperties(Field field, Object obj, Node node, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException {
        String propertyName = ReferenceMapper.getPropertyName(field);
        if (nodeFilter == null || nodeFilter.isNameIncluded(field.getName())) {
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                ReferenceMapper.addMultipleReferencesToNode(field, obj, propertyName, node);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                ReferenceMapper.addMapOfReferencesToNode(field, obj, propertyName, node);
            } else {
                ReferenceMapper.addSingleReferenceToNode(field, obj, propertyName, node);
            }
        }
    }

    static void addReferences(Field field, Object obj, Node node) throws IllegalAccessException, RepositoryException {
        ReferenceMapper.setReferenceProperties(field, obj, node, null);
    }

    static void updateReferences(Field field, Object obj, Node node, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException {
        ReferenceMapper.setReferenceProperties(field, obj, node, nodeFilter);
    }

    private static Node getSingleReferencedNode(JcrReference jcrReference, Value value, Session session) throws RepositoryException {
        if (jcrReference.byPath()) {
            if (session.getRootNode().hasNode(ReferenceMapper.relativePath(value.getString()))) {
                return session.getRootNode().getNode(ReferenceMapper.relativePath(value.getString()));
            }
        } else {
            return session.getNodeByUUID(value.getString());
        }
        return null;
    }

    static Object createReferencedObject(Field field, Value value, Object obj, Session session, Class referenceObjClass, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        JcrReference jcrReference = field.getAnnotation(JcrReference.class);
        Node referencedNode = null;
        if (jcrReference.byPath()) {
            if (session.getRootNode().hasNode(ReferenceMapper.relativePath(value.getString()))) {
                referencedNode = session.getRootNode().getNode(ReferenceMapper.relativePath(value.getString()));
            }
        } else {
            referencedNode = session.getNodeByUUID(value.getString());
        }
        if (referencedNode != null) {
            Object referencedObject = mapper.createInstanceForNode(referenceObjClass, referencedNode);
            if (nodeFilter.isIncluded(field.getName(), depth)) {
                referencedObject = mapper.mapNodeToClass(referencedObject, referencedNode, nodeFilter, null, depth + 1);
            } else if (jcrReference.byPath()) {
                Mapper.setNodePath(referencedObject, value.getString());
            } else {
                Mapper.setUUID(referencedObject, value.getString());
            }
            return referencedObject;
        }
        return null;
    }

    static List getReferenceList(Field field, String propertyName, Class referenceObjClass, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        ArrayList<Object> references = new ArrayList<Object>();
        if (node.hasProperty(propertyName)) {
            Value[] refValues;
            for (Value value : refValues = node.getProperty(propertyName).getValues()) {
                Object referencedObject = ReferenceMapper.createReferencedObject(field, value, obj, node.getSession(), referenceObjClass, depth, nodeFilter, mapper);
                references.add(referencedObject);
            }
        }
        return references;
    }

    static Map getReferenceMap(Field field, String containerName, Class mapParamClass, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper, JcrReference jcrReference) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        HashMap<String, Object> references = new HashMap<String, Object>();
        if (node.hasNode(containerName)) {
            Node containerNode = node.getNode(containerName);
            PropertyIterator propertyIterator = containerNode.getProperties();
            while (propertyIterator.hasNext()) {
                Property p = propertyIterator.nextProperty();
                if (p.getName().startsWith("jcr:")) continue;
                if (ReflectionUtils.implementsInterface(mapParamClass, List.class)) {
                    if (jcrReference.lazy()) {
                        references.put(p.getName(), ProxyFactory.createReferenceListProxy(Object.class, obj, containerNode.getPath(), p.getName(), node.getSession(), mapper, depth, nodeFilter, field));
                        continue;
                    }
                    references.put(p.getName(), ReferenceMapper.getReferenceList(field, p.getName(), Object.class, containerNode, obj, depth, nodeFilter, mapper));
                    continue;
                }
                if (jcrReference.lazy()) {
                    Node referencedNode = ReferenceMapper.getSingleReferencedNode(jcrReference, p.getValue(), node.getSession());
                    references.put(p.getName(), ProxyFactory.createReferenceProxy(mapper.findClassFromNode(Object.class, referencedNode), obj, containerNode.getPath(), p.getName(), node.getSession(), mapper, depth, nodeFilter, field));
                    continue;
                }
                references.put(p.getName(), ReferenceMapper.createReferencedObject(field, p.getValue(), obj, containerNode.getSession(), Object.class, depth, nodeFilter, mapper));
            }
        }
        return references;
    }

    static void getReferencesFromNode(Field field, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        String propertyName = ReferenceMapper.getPropertyName(field);
        JcrReference jcrReference = field.getAnnotation(JcrReference.class);
        if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
            Class referenceObjClass = ReflectionUtils.getParameterizedClass(field);
            if (jcrReference.lazy()) {
                field.set(obj, ProxyFactory.createReferenceListProxy(referenceObjClass, obj, node.getPath(), propertyName, node.getSession(), mapper, depth, nodeFilter, field));
            } else {
                field.set(obj, ReferenceMapper.getReferenceList(field, propertyName, referenceObjClass, node, obj, depth, nodeFilter, mapper));
            }
        } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
            Class mapParamClass = ReflectionUtils.getParameterizedClass(field, 1);
            field.set(obj, ReferenceMapper.getReferenceMap(field, propertyName, mapParamClass, node, obj, depth, nodeFilter, mapper, jcrReference));
        } else if (node.hasProperty(propertyName)) {
            Class<?> referenceObjClass = field.getType();
            if (jcrReference.lazy()) {
                field.set(obj, ProxyFactory.createReferenceProxy(referenceObjClass, obj, node.getPath(), propertyName, node.getSession(), mapper, depth, nodeFilter, field));
            } else {
                field.set(obj, ReferenceMapper.createReferencedObject(field, node.getProperty(propertyName).getValue(), obj, node.getSession(), referenceObjClass, depth, nodeFilter, mapper));
            }
        }
    }
}

