/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.dao;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.jcrom.JcrMappingException;
import org.jcrom.Jcrom;
import org.jcrom.annotations.JcrNode;
import org.jcrom.dao.JcrDAO;
import org.jcrom.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJcrDAO<T>
implements JcrDAO<T> {
    protected final Jcrom jcrom;
    protected final Session session;
    protected final Class<T> entityClass;
    protected final String[] mixinTypes;
    protected final boolean isVersionable;

    public AbstractJcrDAO(Class<T> entityClass, Jcrom jcrom) {
        this(entityClass, null, jcrom, new String[0]);
    }

    public AbstractJcrDAO(Class<T> entityClass, Session session, Jcrom jcrom) {
        this(entityClass, session, jcrom, new String[0]);
    }

    public AbstractJcrDAO(Class<T> entityClass, Session session, Jcrom jcrom, String[] mixinTypes) {
        this.entityClass = entityClass;
        this.session = session;
        this.jcrom = jcrom;
        this.mixinTypes = new String[mixinTypes.length];
        System.arraycopy(mixinTypes, 0, this.mixinTypes, 0, mixinTypes.length);
        this.isVersionable = this.checkIfVersionable();
    }

    protected Session getSession() {
        return this.session;
    }

    private boolean checkIfVersionable() {
        for (String mixinType : this.mixinTypes) {
            if (!mixinType.equals("mix:versionable")) continue;
            return true;
        }
        JcrNode jcrNode = ReflectionUtils.getJcrNodeAnnotation(this.entityClass);
        if (jcrNode != null && jcrNode.mixinTypes() != null) {
            for (String mixinType : jcrNode.mixinTypes()) {
                if (!mixinType.equals("mix:versionable")) continue;
                return true;
            }
        }
        return false;
    }

    protected String relativePath(String absolutePath) {
        if (absolutePath.startsWith("/")) {
            return absolutePath.substring(1);
        }
        return absolutePath;
    }

    @Override
    public T create(T entity) {
        return this.create(this.jcrom.getPath(entity), entity);
    }

    @Override
    public T create(String parentNodePath, T entity) {
        try {
            String entityName = this.jcrom.getName(entity);
            if (entityName == null || entityName.equals("")) {
                throw new JcrMappingException("The name of the entity being created is empty!");
            }
            if (parentNodePath == null || parentNodePath.equals("")) {
                throw new JcrMappingException("The parent path of the entity being created is empty!");
            }
            Node parentNode = parentNodePath.equals("/") ? this.getSession().getRootNode() : this.getSession().getRootNode().getNode(this.relativePath(parentNodePath));
            Node newNode = this.jcrom.addNode(parentNode, entity, this.mixinTypes);
            this.getSession().save();
            if (this.isVersionable) {
                this.checkinRecursively(newNode);
            }
            return entity;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not create node", e);
        }
    }

    private void checkinRecursively(Node node) {
        try {
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                this.checkinRecursively(it.nextNode());
            }
            if (node.isCheckedOut() && node.isNodeType("mix:versionable")) {
                node.checkin();
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not perform check-in", e);
        }
    }

    private void checkoutRecursively(Node node) {
        try {
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                this.checkoutRecursively(it.nextNode());
            }
            if (!node.isCheckedOut() && node.isNodeType("mix:versionable")) {
                node.checkout();
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not perform check-in", e);
        }
    }

    @Override
    public String update(T entity) {
        return this.update(entity, "*", -1);
    }

    @Override
    public String update(T entity, String childNodeFilter, int maxDepth) {
        Node node;
        try {
            node = this.getSession().getRootNode().getNode(this.relativePath(this.jcrom.getPath(entity)));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", e);
        }
        return this.update(node, entity, childNodeFilter, maxDepth);
    }

    @Override
    public String updateByUUID(T entity, String uuid) {
        return this.updateByUUID(entity, uuid, "*", -1);
    }

    @Override
    public String updateByUUID(T entity, String uuid, String childNodeFilter, int maxDepth) {
        Node node;
        try {
            node = this.getSession().getNodeByUUID(uuid);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", e);
        }
        return this.update(node, entity, childNodeFilter, maxDepth);
    }

    protected String update(Node node, T entity, String childNodeFilter, int maxDepth) {
        try {
            if (this.isVersionable) {
                this.checkoutRecursively(node);
            }
            String name = this.jcrom.updateNode(node, entity, childNodeFilter, maxDepth);
            this.getSession().save();
            if (this.isVersionable) {
                this.checkinRecursively(node);
            }
            return name;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", e);
        }
    }

    protected boolean hasMixinType(Node node, String mixinType) throws RepositoryException {
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!nodeType.getName().equals(mixinType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void move(T entity, String newParentPath) {
        try {
            String sourcePath = this.jcrom.getPath(entity);
            String entityName = this.jcrom.getName(entity);
            Node oldParent = null;
            Node newParent = null;
            if (this.isVersionable) {
                oldParent = this.getSession().getRootNode().getNode(this.relativePath(sourcePath)).getParent();
                Node node = newParent = newParentPath.equals("/") ? this.getSession().getRootNode() : this.getSession().getRootNode().getNode(this.relativePath(newParentPath));
                if (this.hasMixinType(oldParent, "mix:versionable")) {
                    oldParent.checkout();
                }
                if (this.hasMixinType(newParent, "mix:versionable")) {
                    newParent.checkout();
                }
            }
            if (newParentPath.equals("/")) {
                this.getSession().move(sourcePath, newParentPath + entityName);
            } else {
                this.getSession().move(sourcePath, newParentPath + "/" + entityName);
            }
            this.getSession().save();
            if (this.isVersionable) {
                if (this.hasMixinType(oldParent, "mix:versionable") && oldParent.isCheckedOut()) {
                    oldParent.checkin();
                }
                if (this.hasMixinType(newParent, "mix:versionable") && newParent.isCheckedOut()) {
                    newParent.checkin();
                }
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not move node", e);
        }
    }

    @Override
    public void remove(String path) {
        try {
            Node parent = null;
            if (this.isVersionable && this.hasMixinType(parent = this.getSession().getRootNode().getNode(this.relativePath(path)).getParent(), "mix:versionable")) {
                parent.checkout();
            }
            this.getSession().getRootNode().getNode(this.relativePath(path)).remove();
            this.getSession().save();
            if (this.isVersionable && this.hasMixinType(parent, "mix:versionable") && parent.isCheckedOut()) {
                parent.checkin();
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove node", e);
        }
    }

    @Override
    public void removeByUUID(String uuid) {
        try {
            Node node = this.getSession().getNodeByUUID(uuid);
            Node parent = null;
            if (this.isVersionable && this.hasMixinType(parent = node.getParent(), "mix:versionable")) {
                parent.checkout();
            }
            node.remove();
            this.getSession().save();
            if (this.isVersionable && this.hasMixinType(parent, "mix:versionable") && parent.isCheckedOut()) {
                parent.checkin();
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove node", e);
        }
    }

    @Override
    public boolean exists(String path) {
        try {
            return this.getSession().getRootNode().hasNode(this.relativePath(path));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not check if node exists", e);
        }
    }

    @Override
    public T get(String path) {
        return this.get(path, "*", -1);
    }

    @Override
    public T get(String path, String childNodeFilter, int maxDepth) {
        if (this.exists(path)) {
            Node node;
            try {
                node = this.getSession().getRootNode().getNode(this.relativePath(path));
            }
            catch (RepositoryException e) {
                throw new JcrMappingException("Could not get node", e);
            }
            return this.jcrom.fromNode(this.entityClass, node, childNodeFilter, maxDepth);
        }
        return null;
    }

    @Override
    public T loadByUUID(String uuid) {
        return this.loadByUUID(uuid, "*", -1);
    }

    @Override
    public T loadByUUID(String uuid, String childNodeFilter, int maxDepth) {
        Node node;
        try {
            node = this.getSession().getNodeByUUID(uuid);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not load node", e);
        }
        return this.jcrom.fromNode(this.entityClass, node, childNodeFilter, maxDepth);
    }

    @Override
    public T getVersion(String path, String versionName) {
        return this.getVersion(path, versionName, "*", -1);
    }

    @Override
    public T getVersion(String path, String versionName, String childNodeFilter, int maxDepth) {
        try {
            return this.getVersion(this.getSession().getRootNode().getNode(this.relativePath(path)), versionName, childNodeFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", e);
        }
    }

    @Override
    public T getVersionByUUID(String uuid, String versionName) {
        return this.getVersionByUUID(uuid, versionName, "*", -1);
    }

    @Override
    public T getVersionByUUID(String uuid, String versionName, String childNodeFilter, int maxDepth) {
        try {
            return this.getVersion(this.getSession().getNodeByUUID(uuid), versionName, childNodeFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", e);
        }
    }

    protected T getVersion(Node node, String versionName, String childNodeFilter, int maxDepth) {
        try {
            VersionHistory versionHistory = node.getVersionHistory();
            Version version = versionHistory.getVersion(versionName);
            return this.jcrom.fromNode(this.entityClass, version.getNodes().nextNode(), childNodeFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", e);
        }
    }

    @Override
    public void restoreVersion(String path, String versionName) {
        this.restoreVersion(path, versionName, true);
    }

    @Override
    public void restoreVersionByUUID(String uuid, String versionName) {
        this.restoreVersionByUUID(uuid, versionName, true);
    }

    @Override
    public void restoreVersion(String path, String versionName, boolean removeExisting) {
        try {
            this.restoreVersion(this.getSession().getRootNode().getNode(this.relativePath(path)), versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", e);
        }
    }

    @Override
    public void restoreVersionByUUID(String uuid, String versionName, boolean removeExisting) {
        try {
            this.restoreVersion(this.getSession().getNodeByUUID(uuid), versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", e);
        }
    }

    protected void restoreVersion(Node node, String versionName, boolean removeExisting) {
        try {
            node.checkout();
            node.restore(versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", e);
        }
    }

    @Override
    public void removeVersion(String path, String versionName) {
        try {
            this.removeVersion(this.getSession().getRootNode().getNode(this.relativePath(path)), versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", e);
        }
    }

    @Override
    public void removeVersionByUUID(String uuid, String versionName) {
        try {
            this.removeVersion(this.getSession().getNodeByUUID(uuid), versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", e);
        }
    }

    protected void removeVersion(Node node, String versionName) {
        try {
            node.getVersionHistory().removeVersion(versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", e);
        }
    }

    @Override
    public long getVersionSize(String path) {
        try {
            return this.getVersionSize(this.getSession().getRootNode().getNode(this.relativePath(path)));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", e);
        }
    }

    @Override
    public long getVersionSizeByUUID(String uuid) {
        try {
            return this.getVersionSize(this.getSession().getNodeByUUID(uuid));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", e);
        }
    }

    protected long getVersionSize(Node node) {
        try {
            VersionHistory versionHistory = node.getVersionHistory();
            return versionHistory.getAllVersions().getSize() - 1L;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", e);
        }
    }

    @Override
    public List<T> getVersionList(String path) {
        try {
            return this.getVersionList(this.getSession().getRootNode().getNode(this.relativePath(path)), "*", -1);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public List<T> getVersionList(String path, String childNameFilter, int maxDepth) {
        try {
            return this.getVersionList(this.getSession().getRootNode().getNode(this.relativePath(path)), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public List<T> getVersionList(String path, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            return this.getVersionList(this.getSession().getRootNode().getNode(this.relativePath(path)), childNameFilter, maxDepth, startIndex, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public List<T> getVersionListByUUID(String uuid) {
        try {
            return this.getVersionList(this.getSession().getNodeByUUID(uuid), "*", -1);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public List<T> getVersionListByUUID(String uuid, String childNameFilter, int maxDepth) {
        try {
            return this.getVersionList(this.getSession().getNodeByUUID(uuid), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public List<T> getVersionListByUUID(String uuid, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            return this.getVersionList(this.getSession().getNodeByUUID(uuid), childNameFilter, maxDepth, startIndex, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    protected List<T> getVersionList(Node node, String childNameFilter, int maxDepth) {
        try {
            ArrayList<T> versionList = new ArrayList<T>();
            VersionHistory versionHistory = node.getVersionHistory();
            VersionIterator versionIterator = versionHistory.getAllVersions();
            versionIterator.skip(1L);
            while (versionIterator.hasNext()) {
                Version version = versionIterator.nextVersion();
                NodeIterator nodeIterator = version.getNodes();
                while (nodeIterator.hasNext()) {
                    T entityVersion = this.jcrom.fromNode(this.entityClass, nodeIterator.nextNode(), childNameFilter, maxDepth);
                    this.jcrom.setBaseVersionInfo(entityVersion, node.getBaseVersion().getName(), node.getBaseVersion().getCreated());
                    versionList.add(entityVersion);
                }
            }
            return versionList;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    protected List<T> getVersionList(Node node, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            ArrayList<T> versionList = new ArrayList<T>();
            VersionHistory versionHistory = node.getVersionHistory();
            VersionIterator versionIterator = versionHistory.getAllVersions();
            versionIterator.skip(1L + startIndex);
            for (long counter = 0L; versionIterator.hasNext() && counter != resultSize; ++counter) {
                Version version = versionIterator.nextVersion();
                NodeIterator nodeIterator = version.getNodes();
                while (nodeIterator.hasNext()) {
                    versionList.add(this.jcrom.fromNode(this.entityClass, nodeIterator.nextNode(), childNameFilter, maxDepth));
                }
            }
            return versionList;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public long getSize(String rootPath) {
        try {
            NodeIterator nodeIterator = this.getSession().getRootNode().getNode(this.relativePath(rootPath)).getNodes();
            return nodeIterator.getSize();
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get list size", e);
        }
    }

    @Override
    public List<T> findAll(String rootPath) {
        return this.findAll(rootPath, "*", -1);
    }

    @Override
    public List<T> findAll(String rootPath, long startIndex, long resultSize) {
        return this.findAll(rootPath, "*", -1, startIndex, resultSize);
    }

    @Override
    public List<T> findAll(String rootPath, String childNameFilter, int maxDepth) {
        try {
            return this.toList(this.getSession().getRootNode().getNode(this.relativePath(rootPath)).getNodes(), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes", e);
        }
    }

    @Override
    public List<T> findAll(String rootPath, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            NodeIterator nodeIterator = this.getSession().getRootNode().getNode(this.relativePath(rootPath)).getNodes();
            nodeIterator.skip(startIndex);
            return this.toList(nodeIterator, childNameFilter, maxDepth, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes", e);
        }
    }

    protected List<T> findByXPath(String xpath, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            QueryManager queryManager = this.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xpath, "xpath");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            nodeIterator.skip(startIndex);
            return this.toList(nodeIterator, childNameFilter, maxDepth, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes by XPath", e);
        }
    }

    protected List<T> findByXPath(String xpath, String childNameFilter, int maxDepth) {
        try {
            QueryManager queryManager = this.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xpath, "xpath");
            QueryResult result = query.execute();
            return this.toList(result.getNodes(), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes by XPath", e);
        }
    }

    protected List<T> toList(NodeIterator nodeIterator, String childNameFilter, int maxDepth) {
        ArrayList<T> objects = new ArrayList<T>();
        while (nodeIterator.hasNext()) {
            objects.add(this.jcrom.fromNode(this.entityClass, nodeIterator.nextNode(), childNameFilter, maxDepth));
        }
        return objects;
    }

    protected List<T> toList(NodeIterator nodeIterator, String childNameFilter, int maxDepth, long resultSize) {
        ArrayList<T> objects = new ArrayList<T>();
        for (long counter = 0L; nodeIterator.hasNext() && counter != resultSize; ++counter) {
            objects.add(this.jcrom.fromNode(this.entityClass, nodeIterator.nextNode(), childNameFilter, maxDepth));
        }
        return objects;
    }
}

