/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util;

import java.util.HashSet;
import java.util.Set;

public class NameFilter {
    private final String filterStr;
    private final boolean exclusion;
    private final boolean all;
    private final Set<String> names;

    public NameFilter(String filterStr) {
        this.filterStr = filterStr;
        this.names = new HashSet<String>();
        if (filterStr == null) {
            this.exclusion = false;
            this.all = true;
        } else if ((filterStr = filterStr.trim()).startsWith("-")) {
            filterStr = filterStr.substring(1);
            this.exclusion = true;
            this.all = false;
            this.addToSet(filterStr);
        } else if (filterStr.equals("none")) {
            this.exclusion = true;
            this.all = true;
        } else {
            this.exclusion = false;
            if (filterStr.equals("*")) {
                this.all = true;
            } else {
                this.all = false;
                this.addToSet(filterStr);
            }
        }
    }

    public String getFilterStr() {
        return this.filterStr;
    }

    private void addToSet(String filterStr) {
        String[] nameArray;
        for (String nodeName : nameArray = filterStr.split(",")) {
            this.names.add(nodeName);
        }
    }

    public boolean isIncluded(String name) {
        if (this.exclusion) {
            if (this.all) {
                return false;
            }
            return !this.names.contains(name);
        }
        if (this.all) {
            return true;
        }
        return this.names.contains(name);
    }
}

