/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.remote.RemoteNodeDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.remote.RemotePropertyDefinition;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;

public class ClientNodeType
extends ClientObject
implements NodeType {
    private RemoteNodeType remote;

    public ClientNodeType(RemoteNodeType remote, LocalAdapterFactory factory) {
        super(factory);
        this.remote = remote;
    }

    private NodeDefinition[] getNodeDefArray(RemoteNodeDefinition[] remotes) {
        if (remotes != null) {
            NodeDefinition[] defs = new NodeDefinition[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                defs[i] = this.getFactory().getNodeDef(remotes[i]);
            }
            return defs;
        }
        return new NodeDefinition[0];
    }

    protected PropertyDefinition[] getPropertyDefArray(RemotePropertyDefinition[] remotes) {
        if (remotes != null) {
            PropertyDefinition[] defs = new PropertyDefinition[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                defs[i] = this.getFactory().getPropertyDef(remotes[i]);
            }
            return defs;
        }
        return new PropertyDefinition[0];
    }

    public String getName() {
        try {
            return this.remote.getName();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isMixin() {
        try {
            return this.remote.isMixin();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean hasOrderableChildNodes() {
        try {
            return this.remote.hasOrderableChildNodes();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeType[] getSupertypes() {
        try {
            return this.getNodeTypeArray(this.remote.getSupertypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeType[] getDeclaredSupertypes() {
        try {
            return this.getNodeTypeArray(this.remote.getDeclaredSupertypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isNodeType(String type) {
        try {
            return this.remote.isNodeType(type);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        try {
            return this.getPropertyDefArray(this.remote.getPropertyDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        try {
            return this.getPropertyDefArray(this.remote.getDeclaredPropertyDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        try {
            return this.getNodeDefArray(this.remote.getChildNodeDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        try {
            return this.getNodeDefArray(this.remote.getDeclaredChildNodeDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canSetProperty(String name, Value value) {
        try {
            return this.remote.canSetProperty(name, SerialValueFactory.makeSerialValue(value));
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to serialize value", e);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canSetProperty(String name, Value[] values) {
        try {
            Value[] serials = SerialValueFactory.makeSerialValueArray(values);
            return this.remote.canSetProperty(name, serials);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to serialize values", e);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canAddChildNode(String name) {
        try {
            return this.remote.canAddChildNode(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canAddChildNode(String name, String type) {
        try {
            return this.remote.canAddChildNode(name, type);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canRemoveItem(String name) {
        try {
            return this.remote.canRemoveItem(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public String getPrimaryItemName() {
        try {
            return this.remote.getPrimaryItemName();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canRemoveNode(String nodeName) {
        throw new RuntimeException("TODO: JCRRMI-26");
    }

    public boolean canRemoveProperty(String propertyName) {
        throw new RuntimeException("TODO: JCRRMI-26");
    }

    public NodeTypeIterator getDeclaredSubtypes() {
        throw new RuntimeException("TODO: JCRRMI-26");
    }

    public NodeTypeIterator getSubtypes() {
        throw new RuntimeException("TODO: JCRRMI-26");
    }

    public String[] getDeclaredSupertypeNames() {
        throw new RuntimeException("TODO: JCRRMI-26");
    }

    public boolean isAbstract() {
        try {
            return this.remote.isAbstract();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isQueryable() {
        throw new RuntimeException("TODO: JCRRMI-26");
    }
}

