/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.feed;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedParser
implements Parser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"rss+xml"), MediaType.application((String)"atom+xml"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        SyndFeed feed = null;
        try {
            SyndFeedInput feedInput = new SyndFeedInput();
            InputSource input = new InputSource(stream);
            feed = feedInput.build(input);
        }
        catch (Exception e) {
            throw new TikaException(e.getMessage());
        }
        String feedLink = feed.getLink();
        String feedDesc = FeedParser.stripTags(feed.getDescriptionEx());
        String feedTitle = FeedParser.stripTags(feed.getTitleEx());
        metadata.set("title", feedTitle);
        metadata.set("description", feedDesc);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        List entries = feed.getEntries();
        for (SyndEntry entry : entries) {
            String link = entry.getLink();
            if (link == null) continue;
            SyndContent description = entry.getDescription();
            String title = FeedParser.stripTags(entry.getTitleEx());
            xhtml.startElement("a", "href", link);
            xhtml.characters(title);
            xhtml.endElement("a");
            xhtml.startElement("p");
            if (description != null) {
                xhtml.characters(description.getValue());
            }
            xhtml.endElement("p");
        }
        xhtml.endDocument();
    }

    private static String stripTags(SyndContent c) {
        if (c == null) {
            return "";
        }
        String value = c.getValue();
        String[] parts = value.split("<[^>]*>");
        StringBuffer buf = new StringBuffer();
        for (String part : parts) {
            buf.append(part);
        }
        return buf.toString().trim();
    }
}

