/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.MetadataExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFExcelExtractorDecorator
extends AbstractOOXMLExtractor {
    private final DataFormatter formatter;
    private final XSSFExcelExtractor extractor;
    private static final String TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    public XSSFExcelExtractorDecorator(XSSFExcelExtractor extractor, Locale locale) {
        super((POIXMLTextExtractor)extractor, TYPE);
        this.extractor = extractor;
        this.formatter = new DataFormatter(locale);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XSSFWorkbook document = (XSSFWorkbook)this.extractor.getDocument();
        for (int i = 0; i < document.getNumberOfSheets(); ++i) {
            xhtml.startElement("div");
            XSSFSheet sheet = document.getSheetAt(i);
            xhtml.element("h1", document.getSheetName(i));
            this.extractHeaderFooter((HeaderFooter)sheet.getFirstHeader(), xhtml);
            this.extractHeaderFooter((HeaderFooter)sheet.getOddHeader(), xhtml);
            this.extractHeaderFooter((HeaderFooter)sheet.getEvenHeader(), xhtml);
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            for (Row rawR : sheet) {
                xhtml.startElement("tr");
                Row row = rawR;
                Iterator ri = row.cellIterator();
                while (ri.hasNext()) {
                    xhtml.startElement("td");
                    Cell cell = (Cell)ri.next();
                    int type = cell.getCellType();
                    if (type == 2) {
                        type = cell.getCachedFormulaResultType();
                    }
                    if (type == 1) {
                        xhtml.characters(cell.getRichStringCellValue().getString());
                    } else if (type == 0) {
                        CellStyle style = cell.getCellStyle();
                        xhtml.characters(this.formatter.formatRawCellContents(cell.getNumericCellValue(), (int)style.getDataFormat(), style.getDataFormatString()));
                    } else {
                        XSSFCell xc = (XSSFCell)cell;
                        String rawValue = xc.getRawValue();
                        if (rawValue != null) {
                            xhtml.characters(rawValue);
                        }
                    }
                    Comment comment = cell.getCellComment();
                    if (comment != null) {
                        xhtml.characters(comment.getString().getString());
                    }
                    xhtml.endElement("td");
                }
                xhtml.endElement("tr");
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
            this.extractHeaderFooter((HeaderFooter)sheet.getFirstFooter(), xhtml);
            this.extractHeaderFooter((HeaderFooter)sheet.getOddFooter(), xhtml);
            this.extractHeaderFooter((HeaderFooter)sheet.getEvenFooter(), xhtml);
            xhtml.endElement("div");
        }
    }

    private void extractHeaderFooter(HeaderFooter hf, XHTMLContentHandler xhtml) throws SAXException {
        String content = ExcelExtractor._extractHeaderFooter((HeaderFooter)hf);
        if (content.length() > 0) {
            xhtml.element("p", content);
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        XSSFWorkbook document = (XSSFWorkbook)this.extractor.getDocument();
        for (XSSFSheet sheet : document) {
            PackagePart part = sheet.getPackagePart();
            parts.add(part);
            try {
                PackagePartName relName;
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.VML_DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Broken OOXML file", (Throwable)e);
            }
        }
        return parts;
    }

    @Override
    public MetadataExtractor getMetadataExtractor() {
        return new MetadataExtractor((POIXMLTextExtractor)this.extractor, TYPE){

            public void extract(Metadata metadata) throws TikaException {
                super.extract(metadata);
                metadata.set("protected", "false");
                XSSFWorkbook document = (XSSFWorkbook)XSSFExcelExtractorDecorator.this.extractor.getDocument();
                for (int i = 0; i < document.getNumberOfSheets(); ++i) {
                    XSSFSheet sheet = document.getSheetAt(i);
                    if (!sheet.getProtect()) continue;
                    metadata.set("protected", "true");
                }
            }
        };
    }
}

