/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.security.Principal;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.RepositoryStub;
import org.apache.jackrabbit.test.RepositoryStubException;

public class JNDIRepositoryStub
extends RepositoryStub {
    public static final String REPOSITORY_LOOKUP_PROP = "javax.jcr.tck.jndi.repository_lookup_name";
    private Repository repository = null;

    public JNDIRepositoryStub(Properties env) {
        super(env);
    }

    public synchronized Repository getRepository() throws RepositoryStubException {
        if (this.repository == null) {
            try {
                String lookupName = this.environment.getProperty(REPOSITORY_LOOKUP_PROP);
                if (lookupName == null) {
                    throw new RepositoryStubException("Property javax.jcr.tck.jndi.repository_lookup_name not defined!");
                }
                InitialContext initial = new InitialContext(this.environment);
                Object obj = initial.lookup(lookupName);
                this.repository = (Repository)PortableRemoteObject.narrow((Object)obj, (Class)Repository.class);
            }
            catch (ClassCastException e) {
                throw new RepositoryStubException("Object cannot be narrowed to javax.jcr.Repository: " + e);
            }
            catch (NamingException e) {
                throw new RepositoryStubException(e.getMessage());
            }
        }
        return this.repository;
    }

    public Principal getKnownPrincipal(Session session) throws RepositoryException {
        throw new RepositoryException("TDB");
    }

    public Principal getUnknownPrincipal(Session session) throws RepositoryException, NotExecutableException {
        throw new RepositoryException("TDB");
    }
}

