/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class ReferencesTest
extends AbstractJCRTest {
    public void testReferences() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixReferenceable);
        this.testRootNode.save();
        ReferencesTest.assertTrue((String)"test node should be mix:referenceable", (boolean)n1.isNodeType(this.mixReferenceable));
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        Value[] values = new Value[]{this.superuser.getValueFactory().createValue(n1)};
        this.ensureCanSetProperty(n2, this.propertyName1, values);
        Property p1 = n2.setProperty(this.propertyName1, values);
        this.testRootNode.save();
        PropertyIterator iter = n1.getReferences();
        if (iter.hasNext()) {
            ReferencesTest.assertEquals((String)"Wrong referer", (String)iter.nextProperty().getPath(), (String)p1.getPath());
        } else {
            ReferencesTest.fail((String)"no referer");
        }
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        n3.setProperty(this.propertyName1, n1);
        this.testRootNode.save();
        iter = n1.getReferences();
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            if (n2 != null && p.getParent().getPath().equals(n2.getPath())) {
                n2 = null;
                continue;
            }
            if (n3 != null && p.getParent().getPath().equals(n3.getPath())) {
                n3 = null;
                continue;
            }
            ReferencesTest.fail((String)("too many referers: " + p.getPath()));
        }
        if (n2 != null) {
            ReferencesTest.fail((String)("referer not in references set: " + n2.getPath()));
        }
        if (n3 != null) {
            ReferencesTest.fail((String)("referer not in references set: " + n3.getPath()));
        }
        this.testRootNode.getNode(this.nodeName3).getProperty(this.propertyName1).remove();
        this.testRootNode.save();
        iter = n1.getReferences();
        if (iter.hasNext()) {
            ReferencesTest.assertEquals((String)"Wrong referer", (String)iter.nextProperty().getParent().getPath(), (String)this.testRootNode.getNode(this.nodeName2).getPath());
        } else {
            ReferencesTest.fail((String)"no referer");
        }
        if (iter.hasNext()) {
            ReferencesTest.fail((String)("too many referers: " + iter.nextProperty().getPath()));
        }
        this.testRootNode.getNode(this.nodeName2).getProperty(this.propertyName1).setValue(new Value[0]);
        this.testRootNode.save();
        iter = n1.getReferences();
        if (iter.hasNext()) {
            ReferencesTest.fail((String)("too many referers: " + iter.nextProperty().getPath()));
        }
    }

    public void testGetReferencesWithName() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixReferenceable);
        this.testRootNode.save();
        ReferencesTest.assertTrue((String)"test node should be mix:referenceable", (boolean)n1.isNodeType(this.mixReferenceable));
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        Value[] values = new Value[]{this.superuser.getValueFactory().createValue(n1)};
        this.ensureCanSetProperty(n2, this.propertyName1, values);
        this.ensureCanSetProperty(n2, this.propertyName2, values);
        this.ensureCanSetProperty(n3, this.propertyName1, values);
        Property p1 = n2.setProperty(this.propertyName1, values);
        Property p2 = n2.setProperty(this.propertyName2, values);
        Property p3 = n3.setProperty(this.propertyName1, n1);
        this.testRootNode.save();
        PropertyIterator iter = n1.getReferences(this.propertyName1);
        HashSet<String> results = new HashSet<String>();
        while (iter.hasNext()) {
            results.add(iter.nextProperty().getPath());
        }
        ReferencesTest.assertEquals((String)"wrong number of references reported", (int)2, (int)results.size());
        ReferencesTest.assertTrue((String)("missing reference property: " + p1.getPath()), (boolean)results.contains(p1.getPath()));
        ReferencesTest.assertTrue((String)("missing reference property: " + p3.getPath()), (boolean)results.contains(p3.getPath()));
        iter = n1.getReferences(this.propertyName2);
        results.clear();
        while (iter.hasNext()) {
            results.add(iter.nextProperty().getPath());
        }
        ReferencesTest.assertEquals((String)"wrong number of references reported", (int)1, (int)results.size());
        ReferencesTest.assertTrue((String)("missing reference property: " + p2.getPath()), (boolean)results.contains(p2.getPath()));
        this.testRootNode.getNode(this.nodeName3).getProperty(this.propertyName1).remove();
        this.testRootNode.save();
        iter = n1.getReferences(this.propertyName1);
        results.clear();
        while (iter.hasNext()) {
            results.add(iter.nextProperty().getPath());
        }
        ReferencesTest.assertEquals((String)"wrong number of references reported", (int)1, (int)results.size());
        ReferencesTest.assertTrue((String)("missing reference property: " + p1.getPath()), (boolean)results.contains(p1.getPath()));
        p1.remove();
        this.testRootNode.save();
        iter = n1.getReferences(this.propertyName1);
        results.clear();
        while (iter.hasNext()) {
            results.add(iter.nextProperty().getPath());
        }
        ReferencesTest.assertEquals((String)"wrong number of references reported", (int)0, (int)results.size());
    }

    public void testReferenceTarget() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixReferenceable);
        this.testRootNode.save();
        ReferencesTest.assertTrue((String)"test node should be mix:referenceable", (boolean)n1.isNodeType(this.mixReferenceable));
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.ensureCanSetProperty(n2, this.propertyName1, n2.getSession().getValueFactory().createValue(n1));
        n2.setProperty(this.propertyName1, n1);
        this.testRootNode.save();
        ReferencesTest.assertEquals((String)"Wrong reference target.", (String)n2.getProperty(this.propertyName1).getNode().getUUID(), (String)n1.getUUID());
        n2.remove();
        this.testRootNode.save();
    }

    public void testAlterReference() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixReferenceable);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(n2, this.mixReferenceable);
        this.testRootNode.save();
        ReferencesTest.assertTrue((String)"test node should be mix:referenceable", (boolean)n1.isNodeType(this.mixReferenceable));
        ReferencesTest.assertTrue((String)"test node should be mix:referenceable", (boolean)n2.isNodeType(this.mixReferenceable));
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.ensureCanSetProperty(n3, this.propertyName1, n3.getSession().getValueFactory().createValue(n1));
        n3.setProperty(this.propertyName1, n1);
        this.testRootNode.save();
        ReferencesTest.assertEquals((String)"Wrong reference target.", (String)n3.getProperty(this.propertyName1).getNode().getUUID(), (String)n1.getUUID());
        PropertyIterator iter = n1.getReferences();
        if (iter.hasNext()) {
            ReferencesTest.assertEquals((String)"Wrong referer", (String)iter.nextProperty().getParent().getPath(), (String)n3.getPath());
        } else {
            ReferencesTest.fail((String)"no referer");
        }
        if (iter.hasNext()) {
            ReferencesTest.fail((String)("too many referers: " + iter.nextProperty().getPath()));
        }
        n3.setProperty(this.propertyName1, n2);
        n3.save();
        ReferencesTest.assertEquals((String)"Wrong reference target.", (String)n3.getProperty(this.propertyName1).getNode().getUUID(), (String)n2.getUUID());
        iter = n1.getReferences();
        if (iter.hasNext()) {
            ReferencesTest.fail((String)("too many referers: " + iter.nextProperty().getPath()));
        }
        if ((iter = n2.getReferences()).hasNext()) {
            ReferencesTest.assertEquals((String)"Wrong referer", (String)iter.nextProperty().getParent().getPath(), (String)n3.getPath());
        } else {
            ReferencesTest.fail((String)"no referers");
        }
        if (iter.hasNext()) {
            ReferencesTest.fail((String)("too many referers: " + iter.nextProperty().getPath()));
        }
        n3.setProperty(this.propertyName1, "Hello, world.");
        n3.save();
        iter = n2.getReferences();
        if (iter.hasNext()) {
            ReferencesTest.fail((String)("too many referers: " + iter.nextProperty().getPath()));
        }
    }

    public void testNonReferenceable() throws RepositoryException, NotExecutableException {
        Node nonReferenceable = null;
        if (this.testRootNode.isNodeType(this.mixReferenceable)) {
            Node child = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.superuser.save();
            if (!child.isNodeType(this.mixReferenceable)) {
                nonReferenceable = child;
            }
        } else {
            nonReferenceable = this.testRootNode;
        }
        if (nonReferenceable == null) {
            throw new NotExecutableException("Test node is referenceable.");
        }
        ReferencesTest.assertFalse((boolean)nonReferenceable.getReferences().hasNext());
    }
}

