/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetPropertyCalendarTest
extends AbstractJCRTest {
    private Node testNode;
    private Calendar c1 = new GregorianCalendar(2005, 1, 10, 14, 8, 56);
    private Calendar c2 = new GregorianCalendar(1945, 1, 6, 16, 20, 0);

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    public void testNewCalendarPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.c1);
        this.superuser.save();
        SetPropertyCalendarTest.assertEquals((String)"Setting property with Node.setProperty(String, Calendar) and Session.save() not working", (Object)this.vf.createValue(this.c1), (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testModifyCalendarPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.c1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.c2);
        this.superuser.save();
        SetPropertyCalendarTest.assertEquals((String)"Modifying property with Node.setProperty(String, Calendar) and Session.save() not working", (Object)this.vf.createValue(this.c2), (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testNewCalendarPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.c1);
        this.testRootNode.save();
        SetPropertyCalendarTest.assertEquals((String)"Setting property with Node.setProperty(String, Calendar) and parentNode.save() not working", (Object)this.vf.createValue(this.c1), (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testModifyCalendarPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.c1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, this.c2);
        this.testRootNode.save();
        SetPropertyCalendarTest.assertEquals((String)"Modifying property with Node.setProperty(String, Calendar) and parentNode.save() not working", (Object)this.vf.createValue(this.c2), (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testRemoveCalendarPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.c1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (Calendar)null);
        this.superuser.save();
        SetPropertyCalendarTest.assertFalse((String)"Removing property with Node.setProperty(String, (Calendar)null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveCalendarPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.c1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, (Calendar)null);
        this.testRootNode.save();
        SetPropertyCalendarTest.assertFalse((String)"Removing property with Node.setProperty(String, (Calendar)null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }
}

