/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.math.BigDecimal;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetValueDecimalTest
extends AbstractJCRTest {
    private Value value;
    private Node node;
    private Property property1;

    protected void setUp() throws Exception {
        super.setUp();
        this.value = this.superuser.getValueFactory().createValue(new BigDecimal("457841848484454646544884.484984949849498489771174"));
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureCanSetProperty(this.node, this.propertyName1, this.node.getSession().getValueFactory().createValue(new BigDecimal(0)));
        this.property1 = this.node.setProperty(this.propertyName1, new BigDecimal(0));
        this.superuser.save();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDoubleValueSession() throws RepositoryException {
        this.property1.setValue(this.value);
        this.superuser.save();
        SetValueDecimalTest.assertEquals((String)"Decimal node property not saved", (Object)this.value.getDecimal(), (Object)this.property1.getValue().getDecimal());
    }

    public void testDoubleSession() throws RepositoryException {
        this.property1.setValue(this.value.getDecimal());
        this.superuser.save();
        SetValueDecimalTest.assertEquals((String)"Decimal node property not saved", (Object)this.value.getDecimal(), (Object)this.property1.getValue().getDecimal());
    }

    public void testRemoveDoubleSession() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueDecimalTest.fail((String)"The property should not exist anymore, as a null Decimal has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }
}

