/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class LengthTest
extends AbstractQOMTest {
    private Node node;

    protected void setUp() throws Exception {
        super.setUp();
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
    }

    protected void tearDown() throws Exception {
        this.node = null;
        super.tearDown();
    }

    public void testStringLength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, "abc");
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinaryLength() throws RepositoryException {
        byte[] data = "abc".getBytes();
        Binary b = this.vf.createBinary((InputStream)new ByteArrayInputStream(data));
        try {
            this.node.setProperty(this.propertyName1, b);
        }
        finally {
            b.dispose();
        }
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testLongLength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, 123L);
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testDoubleLength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, Math.PI);
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testDateLength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, Calendar.getInstance());
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testBooleanLength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, false);
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testNameLength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, this.vf.createValue(this.node.getName(), 7));
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testPathLength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, this.vf.createValue(this.node.getPath(), 8));
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testReferenceLength() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.node, this.mixReferenceable);
        this.superuser.save();
        this.node.setProperty(this.propertyName1, this.node);
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testWeakReferenceLength() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.node, this.mixReferenceable);
        this.superuser.save();
        this.node.setProperty(this.propertyName1, this.vf.createValue(this.node, true));
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testURILength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, this.vf.createValue("http://example.com", 11));
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testDecimalLength() throws RepositoryException {
        this.node.setProperty(this.propertyName1, new BigDecimal(123));
        this.superuser.save();
        this.checkOperators(this.propertyName1, this.node.getProperty(this.propertyName1).getLength());
    }

    public void testLengthStringLiteral() throws RepositoryException {
        this.node.setProperty(this.propertyName1, "abc");
        this.superuser.save();
        String length = String.valueOf(this.node.getProperty(this.propertyName1).getLength());
        this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLengthBinaryLiteral() throws RepositoryException {
        this.node.setProperty(this.propertyName1, "abc");
        this.superuser.save();
        String length = String.valueOf(this.node.getProperty(this.propertyName1).getLength());
        Binary b = this.vf.createBinary((InputStream)new ByteArrayInputStream(length.getBytes()));
        try {
            this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(b));
        }
        finally {
            b.dispose();
        }
    }

    public void testLengthDoubleLiteral() throws RepositoryException {
        this.node.setProperty(this.propertyName1, "abc");
        this.superuser.save();
        double length = this.node.getProperty(this.propertyName1).getLength();
        this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(length));
    }

    public void testLengthDateLiteral() throws RepositoryException {
        this.node.setProperty(this.propertyName1, "abc");
        this.superuser.save();
        Calendar length = Calendar.getInstance();
        length.setTimeInMillis(this.node.getProperty(this.propertyName1).getLength());
        this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(length));
    }

    public void testLengthBooleanLiteral() throws RepositoryException {
        try {
            this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(false));
            LengthTest.fail((String)"Boolean literal cannot be converted to long");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testLengthNameLiteral() throws RepositoryException {
        try {
            this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(this.propertyName1, 7));
            LengthTest.fail((String)"Name literal cannot be converted to long");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testLengthPathLiteral() throws RepositoryException {
        try {
            this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(this.node.getPath(), 8));
            LengthTest.fail((String)"Path literal cannot be converted to long");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testLengthReferenceLiteral() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.node, this.mixReferenceable);
        this.superuser.save();
        try {
            this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(this.node));
            LengthTest.fail((String)"Reference literal cannot be converted to long");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testLengthWeakReferenceLiteral() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.node, this.mixReferenceable);
        this.superuser.save();
        try {
            this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(this.node, true));
            LengthTest.fail((String)"Reference literal cannot be converted to long");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testLengthURILiteral() throws RepositoryException {
        try {
            this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(this.node.getPath(), 11));
            LengthTest.fail((String)"URI literal cannot be converted to long");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testLengthDecimalLiteral() throws RepositoryException {
        this.node.setProperty(this.propertyName1, "abc");
        this.superuser.save();
        BigDecimal length = new BigDecimal(this.node.getProperty(this.propertyName1).getLength());
        this.executeQueries(this.propertyName1, "jcr.operator.equal.to", this.vf.createValue(length));
    }

    private void checkOperators(String propertyName, long length) throws RepositoryException {
        this.checkLength(propertyName, "jcr.operator.equal.to", length, true);
        this.checkLength(propertyName, "jcr.operator.equal.to", length - 1L, false);
        this.checkLength(propertyName, "jcr.operator.greater.than", length - 1L, true);
        this.checkLength(propertyName, "jcr.operator.greater.than", length, false);
        this.checkLength(propertyName, "jcr.operator.greater.than.or.equal.to", length, true);
        this.checkLength(propertyName, "jcr.operator.greater.than.or.equal.to", length + 1L, false);
        this.checkLength(propertyName, "jcr.operator.less.than", length + 1L, true);
        this.checkLength(propertyName, "jcr.operator.less.than", length, false);
        this.checkLength(propertyName, "jcr.operator.less.than.or.equal.to", length, true);
        this.checkLength(propertyName, "jcr.operator.less.than.or.equal.to", length - 1L, false);
        this.checkLength(propertyName, "jcr.operator.not.equal.to", length - 1L, true);
        this.checkLength(propertyName, "jcr.operator.not.equal.to", length, false);
    }

    private void checkLength(String propertyName, String operator, long length, boolean matches) throws RepositoryException {
        Node[] expected = matches ? new Node[]{this.node} : new Node[]{};
        QueryResult[] results = this.executeQueries(propertyName, operator, length);
        for (int i = 0; i < results.length; ++i) {
            this.checkResult(results[i], expected);
        }
    }

    private QueryResult[] executeQueries(String propertyName, String operator, long length) throws RepositoryException {
        Value v = this.vf.createValue(length);
        return this.executeQueries(propertyName, operator, v);
    }

    private QueryResult[] executeQueries(String propertyName, String operator, Value length) throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.and((Constraint)this.qf.childNode("s", this.testRoot), (Constraint)this.qf.comparison((DynamicOperand)this.qf.length(this.qf.propertyValue("s", propertyName)), operator, (StaticOperand)this.qf.literal(length))), null, null);
        QueryResult[] results = new QueryResult[]{qom.execute(), this.qm.createQuery(qom.getStatement(), "JCR-SQL2").execute()};
        return results;
    }
}

