/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class NodeNameTest
extends AbstractQOMTest {
    private Node node1;

    protected void setUp() throws Exception {
        super.setUp();
        this.node1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
    }

    protected void tearDown() throws Exception {
        this.node1 = null;
        super.tearDown();
    }

    public void testStringLiteral() throws RepositoryException {
        Value literal = this.vf.createValue(this.nodeName1);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[]{this.node1});
    }

    public void testStringLiteralInvalidName() throws RepositoryException {
        Value literal = this.vf.createValue("[" + this.nodeName1);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with STRING that cannot be converted to NAME must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = '" + literal.getString() + "'";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with STRING that cannot be converted to NAME must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testBinaryLiteral() throws RepositoryException {
        Value literal = this.vf.createValue(this.nodeName1, 2);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[]{this.node1});
    }

    public void testDateLiteral() throws RepositoryException {
        Value literal = this.vf.createValue(Calendar.getInstance());
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with DATE must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST('" + literal.getString() + "' AS DATE)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with DATE must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testDoubleLiteral() throws RepositoryException {
        Value literal = this.vf.createValue(Math.PI);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with DOUBLE must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST('" + literal.getString() + "' AS DOUBLE)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with DOUBLE must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testDecimalLiteral() throws RepositoryException {
        Value literal = this.vf.createValue(new BigDecimal(283));
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with DECIMAL must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST('" + literal.getString() + "' AS DECIMAL)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with DECIMAL must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testLongLiteral() throws RepositoryException {
        Value literal = this.vf.createValue(283L);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with LONG must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST(" + literal.getString() + " AS LONG)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with LONG must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testBooleanLiteral() throws RepositoryException {
        Value literal = this.vf.createValue(true);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with BOOLEAN must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST(" + literal.getString() + " AS BOOLEAN)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with BOOLEAN must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testNameLiteral() throws RepositoryException {
        Value literal = this.vf.createValue(this.nodeName1, 7);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[]{this.node1});
    }

    public void testPathLiteral() throws RepositoryException {
        String stmt;
        Value literal = this.vf.createValue(this.nodeName1, 8);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[]{this.node1});
        literal = this.vf.createValue(this.node1.getPath(), 8);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with absolute PATH must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST('" + literal.getString() + "' AS PATH)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with absolute PATH must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        literal = this.vf.createValue(this.nodeName1 + "/" + this.nodeName1, 8);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with PATH length >1 must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST('" + literal.getString() + "' AS PATH)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with PATH length >1 must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testReferenceLiteral() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.node1, this.mixReferenceable);
        this.superuser.save();
        Value literal = this.vf.createValue(this.node1);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with REFERENCE must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST('" + literal.getString() + "' AS REFERENCE)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with REFERENCE must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testWeakReferenceLiteral() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.node1, this.mixReferenceable);
        this.superuser.save();
        Value literal = this.vf.createValue(this.node1, true);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with WEAKREFERENCE must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST('" + literal.getString() + "' AS WEAKREFERENCE)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with absolute WEAKREFERENCE must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testURILiteral() throws RepositoryException {
        Value literal = this.vf.createValue("./" + this.nodeName1, 11);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[]{this.node1});
        literal = this.vf.createValue("http://example.com", 11);
        try {
            this.createQuery("jcr.operator.equal.to", literal).execute();
            NodeNameTest.fail((String)"NodeName comparison with URI that cannot be converted to NAME must fail with InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s " + "WHERE NAME(s) = CAST('" + literal.getString() + "' AS URI)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            NodeNameTest.fail((String)"NAME() comparison with URI that cannot be converted to NAME must fail with InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testEqualTo() throws RepositoryException {
        this.checkOperator("jcr.operator.equal.to", false, true, false);
    }

    public void testNotEqualTo() throws RepositoryException {
        this.checkOperator("jcr.operator.not.equal.to", true, false, true);
    }

    private void checkOperator(String operator, boolean matchesLesser, boolean matchesEqual, boolean matchesGreater) throws RepositoryException {
        this.checkOperatorSingleLiteral(this.createLexicographicallyLesser(this.nodeName1), operator, matchesLesser);
        this.checkOperatorSingleLiteral(this.nodeName1, operator, matchesEqual);
        this.checkOperatorSingleLiteral(this.createLexicographicallyGreater(this.nodeName1), operator, matchesGreater);
    }

    private void checkOperatorSingleLiteral(String literal, String operator, boolean matches) throws RepositoryException {
        Node[] nodeArray;
        Value value = this.vf.createValue(literal);
        QueryObjectModel qom = this.createQuery(operator, value);
        if (matches) {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = this.node1;
        } else {
            nodeArray = new Node[]{};
        }
        this.checkQOM(qom, nodeArray);
    }

    private String createLexicographicallyGreater(String name) {
        StringBuffer tmp = new StringBuffer(name);
        tmp.setCharAt(tmp.length() - 1, (char)(tmp.charAt(tmp.length() - 1) + '\u0001'));
        return tmp.toString();
    }

    private String createLexicographicallyLesser(String name) {
        StringBuffer tmp = new StringBuffer(name);
        tmp.setCharAt(tmp.length() - 1, (char)(tmp.charAt(tmp.length() - 1) - '\u0001'));
        return tmp.toString();
    }

    private QueryObjectModel createQuery(String operator, Value literal) throws RepositoryException {
        return this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.and((Constraint)this.qf.childNode("s", this.testRoot), (Constraint)this.qf.comparison((DynamicOperand)this.qf.nodeName("s"), operator, (StaticOperand)this.qf.literal(literal))), null, null);
    }
}

