/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.test.api.query.qom.AbstractJoinTest;

public class SameNodeJoinConditionTest
extends AbstractJoinTest {
    private Node n1;
    private Node n2;

    protected void setUp() throws Exception {
        super.setUp();
        this.n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.n2 = this.n1.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(this.n2, this.mixReferenceable);
        this.superuser.save();
    }

    public void testInnerJoin() throws RepositoryException {
        QueryObjectModel qom = this.createQomQuery("jcr.join.type.inner", null);
        this.checkQOM(qom, new Node[][]{{this.n1, this.n1}, {this.n2, this.n2}});
    }

    public void testInnerJoinWithPath() throws RepositoryException {
        QueryObjectModel qom = this.createQomQuery("jcr.join.type.inner", this.nodeName2);
        this.checkQOM(qom, new Node[][]{{this.n2, this.n1}});
    }

    public void testLeftOuterJoin() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.join((Source)this.qf.selector(this.testNodeType, "left"), (Source)this.qf.selector(this.mixReferenceable, "right"), "jcr.join.type.left.outer", (JoinCondition)this.qf.sameNodeJoinCondition("left", "right", ".")), (Constraint)this.qf.descendantNode("left", this.testRoot), null, null);
        this.checkQOM(qom, new Node[][]{{this.n1, null}, {this.n2, this.n2}});
    }

    public void testLeftOuterJoinWithPath() throws RepositoryException {
        QueryObjectModel qom = this.createQomQuery("jcr.join.type.left.outer", this.nodeName2);
        this.checkQOM(qom, new Node[][]{{this.n1, null}, {this.n2, this.n1}});
    }

    public void testRightOuterJoin() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.join((Source)this.qf.selector(this.mixReferenceable, "left"), (Source)this.qf.selector(this.testNodeType, "right"), "jcr.join.type.right.outer", (JoinCondition)this.qf.sameNodeJoinCondition("left", "right", ".")), (Constraint)this.qf.descendantNode("right", this.testRoot), null, null);
        this.checkQOM(qom, new Node[][]{{null, this.n1}, {this.n2, this.n2}});
    }

    public void testRightOuterJoinWithPath() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.join((Source)this.qf.selector(this.mixReferenceable, "left"), (Source)this.qf.selector(this.testNodeType, "right"), "jcr.join.type.right.outer", (JoinCondition)this.qf.sameNodeJoinCondition("left", "right", this.nodeName2)), (Constraint)this.qf.descendantNode("right", this.testRoot), null, null);
        this.checkQOM(qom, new Node[][]{{this.n2, this.n1}, {null, this.n2}});
    }

    private QueryObjectModel createQomQuery(String joinType, String relPath) throws RepositoryException {
        SameNodeJoinCondition c = relPath != null ? this.qf.sameNodeJoinCondition("left", "right", relPath) : this.qf.sameNodeJoinCondition("left", "right", ".");
        return this.createQuery(joinType, (JoinCondition)c);
    }
}

