/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class UpperLowerCaseTest
extends AbstractQOMTest {
    private Node node;

    protected void setUp() throws Exception {
        super.setUp();
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.node.setProperty(this.propertyName1, "abc");
        this.node.setProperty(this.propertyName2, "ABC");
        this.superuser.save();
    }

    protected void tearDown() throws Exception {
        this.node = null;
        super.tearDown();
    }

    public void testLength() throws RepositoryException {
        String lenStr = String.valueOf(this.node.getProperty(this.propertyName1).getLength());
        this.checkQueries((DynamicOperand)this.qf.length(this.qf.propertyValue("s", this.propertyName1)), true, "jcr.operator.equal.to", new String[]{lenStr.toUpperCase()}, 1, new boolean[]{true});
        this.checkQueries((DynamicOperand)this.qf.length(this.qf.propertyValue("s", this.propertyName1)), false, "jcr.operator.equal.to", new String[]{lenStr.toLowerCase()}, 1, new boolean[]{true});
    }

    public void testNodeLocalName() throws RepositoryException {
        String localName = UpperLowerCaseTest.getLocalName(this.node.getName());
        this.checkQueries((DynamicOperand)this.qf.nodeLocalName("s"), true, "jcr.operator.equal.to", new String[]{localName.toLowerCase(), localName.toUpperCase()}, 1, new boolean[]{false, true});
        this.checkQueries((DynamicOperand)this.qf.nodeLocalName("s"), false, "jcr.operator.equal.to", new String[]{localName.toLowerCase(), localName.toUpperCase()}, 1, new boolean[]{true, false});
    }

    public void testNodeName() throws RepositoryException {
        this.checkQueries((DynamicOperand)this.qf.nodeName("s"), true, "jcr.operator.equal.to", new String[]{this.node.getName().toLowerCase(), this.node.getName().toUpperCase()}, 7, new boolean[]{false, true});
        this.checkQueries((DynamicOperand)this.qf.nodeName("s"), false, "jcr.operator.equal.to", new String[]{this.node.getName().toLowerCase(), this.node.getName().toUpperCase()}, 7, new boolean[]{true, false});
    }

    public void testPropertyValue() throws RepositoryException {
        this.checkQueries((DynamicOperand)this.qf.propertyValue("s", this.propertyName1), true, "jcr.operator.equal.to", new String[]{"abc", "Abc", "aBc", "abC", "ABC"}, 1, new boolean[]{false, false, false, false, true});
        this.checkQueries((DynamicOperand)this.qf.propertyValue("s", this.propertyName2), true, "jcr.operator.equal.to", new String[]{"abc", "Abc", "aBc", "abC", "ABC"}, 1, new boolean[]{false, false, false, false, true});
        this.checkQueries((DynamicOperand)this.qf.propertyValue("s", this.propertyName1), false, "jcr.operator.equal.to", new String[]{"abc", "Abc", "aBc", "abC", "ABC"}, 1, new boolean[]{true, false, false, false, false});
        this.checkQueries((DynamicOperand)this.qf.propertyValue("s", this.propertyName2), false, "jcr.operator.equal.to", new String[]{"abc", "Abc", "aBc", "abC", "ABC"}, 1, new boolean[]{true, false, false, false, false});
    }

    public void testUpperLowerCase() throws RepositoryException {
        this.checkQueries((DynamicOperand)this.qf.upperCase((DynamicOperand)this.qf.propertyValue("s", this.propertyName1)), false, "jcr.operator.equal.to", new String[]{"abc", "Abc", "aBc", "abC", "ABC"}, 1, new boolean[]{true, false, false, false, false});
    }

    public void testUpperCaseTwice() throws RepositoryException {
        this.checkQueries((DynamicOperand)this.qf.upperCase((DynamicOperand)this.qf.propertyValue("s", this.propertyName1)), true, "jcr.operator.equal.to", new String[]{"abc", "Abc", "aBc", "abC", "ABC"}, 1, new boolean[]{false, false, false, false, true});
    }

    public void testLowerUpperCase() throws RepositoryException {
        this.checkQueries((DynamicOperand)this.qf.lowerCase((DynamicOperand)this.qf.propertyValue("s", this.propertyName1)), true, "jcr.operator.equal.to", new String[]{"abc", "Abc", "aBc", "abC", "ABC"}, 1, new boolean[]{false, false, false, false, true});
    }

    public void testLowerCaseTwice() throws RepositoryException {
        this.checkQueries((DynamicOperand)this.qf.lowerCase((DynamicOperand)this.qf.propertyValue("s", this.propertyName1)), false, "jcr.operator.equal.to", new String[]{"abc", "Abc", "aBc", "abC", "ABC"}, 1, new boolean[]{true, false, false, false, false});
    }

    private void checkQueries(DynamicOperand operand, boolean toUpper, String operator, String[] literals, int type, boolean[] matches) throws RepositoryException {
        for (int i = 0; i < literals.length; ++i) {
            Node[] nodeArray;
            QueryObjectModel qom = this.createQuery(operand, toUpper, operator, this.vf.createValue(literals[i], type));
            if (matches[i]) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = this.node;
            } else {
                nodeArray = new Node[]{};
            }
            this.checkQOM(qom, nodeArray);
        }
    }

    private QueryObjectModel createQuery(DynamicOperand operand, boolean toUpper, String operator, Value literal) throws RepositoryException {
        operand = toUpper ? this.qf.upperCase(operand) : this.qf.lowerCase(operand);
        return this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.and((Constraint)this.qf.childNode("s", this.testRoot), (Constraint)this.qf.comparison(operand, operator, (StaticOperand)this.qf.literal(literal))), null, null);
    }
}

