/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;

public class AccessControlDiscoveryTest
extends AbstractAccessControlTest {
    public void testGetSupportedPrivileges() throws RepositoryException {
        Privilege[] privileges = this.acMgr.getSupportedPrivileges(this.testRootNode.getPath());
        ArrayList<String> names = new ArrayList<String>(privileges.length);
        for (int i = 0; i < privileges.length; ++i) {
            names.add(privileges[i].getName());
        }
        String msg = "A repository must support the privilege ";
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}read"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}read", this.superuser)));
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}addChildNodes"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}addChildNodes", this.superuser)));
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}removeChildNodes"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}removeChildNodes", this.superuser)));
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}modifyProperties"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.superuser)));
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}removeNode"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}removeNode", this.superuser)));
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}readAccessControl"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}readAccessControl", this.superuser)));
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}modifyAccessControl"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}modifyAccessControl", this.superuser)));
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}write"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}write", this.superuser)));
        AccessControlDiscoveryTest.assertTrue((String)(msg + "{http://www.jcp.org/jcr/1.0}all"), (boolean)names.contains(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}all", this.superuser)));
    }

    public void testPrivilegeFromName() throws RepositoryException {
        Privilege[] privileges = this.acMgr.getSupportedPrivileges(this.testRootNode.getPath());
        for (int i = 0; i < privileges.length; ++i) {
            Privilege p = this.acMgr.privilegeFromName(privileges[i].getName());
            AccessControlDiscoveryTest.assertEquals((String)"Expected equal privilege name.", (String)privileges[i].getName(), (String)p.getName());
            AccessControlDiscoveryTest.assertEquals((String)"Expected equal privilege.", (Object)privileges[i], (Object)p);
        }
    }

    public void testMandatoryPrivilegeFromName() throws RepositoryException {
        ArrayList<String> l = new ArrayList<String>();
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}read", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}addChildNodes", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}removeChildNodes", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}removeNode", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}readAccessControl", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}modifyAccessControl", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}write", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}all", this.superuser));
        Iterator it = l.iterator();
        while (it.hasNext()) {
            String privName = it.next().toString();
            Privilege p = this.acMgr.privilegeFromName(privName);
            AccessControlDiscoveryTest.assertEquals((String)"Expected equal privilege name.", (String)privName, (String)p.getName());
        }
    }

    public void testUnknownPrivilegeFromName() throws RepositoryException {
        String unknownPrivilegeName = Math.random() + "";
        try {
            this.acMgr.privilegeFromName(unknownPrivilegeName);
            AccessControlDiscoveryTest.fail((String)(unknownPrivilegeName + " isn't the name of a known privilege."));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testAllPrivilegeContainsAll() throws RepositoryException, NotExecutableException {
        Privilege[] supported = this.acMgr.getSupportedPrivileges(this.testRootNode.getPath());
        Privilege all = this.acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
        HashSet<Privilege> allSet = new HashSet<Privilege>();
        allSet.addAll(Arrays.asList(all.getAggregatePrivileges()));
        String msg = "The all privilege must also contain ";
        for (int i = 0; i < supported.length; ++i) {
            Privilege sp = supported[i];
            if (sp.isAggregate()) {
                List<Privilege> col = Arrays.asList(sp.getAggregatePrivileges());
                AccessControlDiscoveryTest.assertTrue((String)(msg + sp.getName()), (boolean)allSet.containsAll(col));
                continue;
            }
            AccessControlDiscoveryTest.assertTrue((String)(msg + sp.getName()), (boolean)allSet.contains(sp));
        }
    }

    public void testAllPrivilege() throws RepositoryException, NotExecutableException {
        Privilege all = this.acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
        AccessControlDiscoveryTest.assertFalse((String)"All privilege must be not be abstract.", (boolean)all.isAbstract());
        AccessControlDiscoveryTest.assertTrue((String)"All privilege must be an aggregate privilege.", (boolean)all.isAggregate());
        String expected = AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}all", this.superuser);
        AccessControlDiscoveryTest.assertEquals((String)("The name of the all privilege must be " + expected), (String)expected, (String)all.getName());
    }

    public void testWritePrivilege() throws RepositoryException, NotExecutableException {
        Privilege w = this.acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}write");
        AccessControlDiscoveryTest.assertTrue((String)"Write privilege must be an aggregate privilege.", (boolean)w.isAggregate());
        String expected = AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}write", this.superuser);
        AccessControlDiscoveryTest.assertEquals((String)("The name of the write privilege must be " + expected), (String)expected, (String)w.getName());
    }

    public void testAggregregatePrivileges() throws RepositoryException {
        ArrayList<String> l = new ArrayList<String>();
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}write", this.superuser));
        l.add(AccessControlDiscoveryTest.getJCRName("{http://www.jcp.org/jcr/1.0}all", this.superuser));
        Iterator it = l.iterator();
        while (it.hasNext()) {
            String privName = it.next().toString();
            Privilege p = this.acMgr.privilegeFromName(privName);
            AccessControlDiscoveryTest.assertTrue((String)"write and all must always be aggregate privileges.", (boolean)p.isAggregate());
            Privilege[] aggregatedPrvs = p.getAggregatePrivileges();
            Privilege[] declaredPrvs = p.getDeclaredAggregatePrivileges();
            AccessControlDiscoveryTest.assertNotNull((String)"An aggregate privilege must return the aggregated privileges", (Object)aggregatedPrvs);
            AccessControlDiscoveryTest.assertTrue((String)"An aggregate privilege must return the aggregated privileges", (aggregatedPrvs.length > 0 ? 1 : 0) != 0);
            AccessControlDiscoveryTest.assertNotNull((String)"An aggregate privilege must return the declared aggregated privileges", (Object)declaredPrvs);
            AccessControlDiscoveryTest.assertTrue((String)"An aggregate privilege must return the declared aggregated privileges", (declaredPrvs.length > 0 ? 1 : 0) != 0);
            AccessControlDiscoveryTest.assertTrue((String)"The may be at least the same amount of declared aggregated privileges.", (aggregatedPrvs.length >= declaredPrvs.length ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrivilegeName() throws RepositoryException {
        Privilege allPriv = this.acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
        try {
            String remappedPrefix = "_jcr";
            this.superuser.setNamespacePrefix(remappedPrefix, "http://www.jcp.org/jcr/1.0");
            ArrayList<Privilege> l = new ArrayList<Privilege>();
            l.add(this.acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all"));
            l.add(this.acMgr.privilegeFromName(remappedPrefix + ":all"));
            Iterator it = l.iterator();
            while (it.hasNext()) {
                Privilege p = (Privilege)it.next();
                AccessControlDiscoveryTest.assertEquals((String)"The privilege name must reflect the modified namespace prefix.", (String)(remappedPrefix + ":all"), (String)p.getName());
                AccessControlDiscoveryTest.assertEquals((String)"jcr:all privileges must be equal.", (Object)allPriv, (Object)p);
            }
            try {
                this.acMgr.privilegeFromName("jcr:all");
                AccessControlDiscoveryTest.fail((String)"Modified namespace prefix: 'jcr:all' privilege must not exist.");
            }
            catch (RepositoryException e) {
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.superuser.setNamespacePrefix("jcr", "http://www.jcp.org/jcr/1.0");
            throw throwable;
        }
        this.superuser.setNamespacePrefix("jcr", "http://www.jcp.org/jcr/1.0");
    }

    public void testGetPrivileges() throws RepositoryException {
        this.acMgr.getPrivileges(this.testRootNode.getPath());
    }

    public void testGetPrivilegesOnNonExistingNode() throws RepositoryException {
        String path = this.getPathToNonExistingNode();
        try {
            this.acMgr.getPrivileges(path);
            AccessControlDiscoveryTest.fail((String)"AccessControlManager.getPrivileges for an invalid absPath must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testGetPrivilegesOnProperty() throws RepositoryException, NotExecutableException {
        String path = this.getPathToProperty();
        try {
            this.acMgr.getPrivileges(path);
            AccessControlDiscoveryTest.fail((String)"AccessControlManager.getPrivileges for a property path must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testHasPrivileges() throws RepositoryException {
        Privilege[] privs = this.acMgr.getPrivileges(this.testRootNode.getPath());
        AccessControlDiscoveryTest.assertTrue((boolean)this.acMgr.hasPrivileges(this.testRootNode.getPath(), privs));
    }

    public void testHasIndividualPrivileges() throws RepositoryException {
        Privilege[] privs = this.acMgr.getPrivileges(this.testRootNode.getPath());
        for (int i = 0; i < privs.length; ++i) {
            Privilege[] single = new Privilege[]{privs[i]};
            AccessControlDiscoveryTest.assertTrue((boolean)this.acMgr.hasPrivileges(this.testRootNode.getPath(), single));
        }
    }

    public void testNotHasPrivileges() throws RepositoryException, NotExecutableException {
        Privilege[] privs = this.acMgr.getPrivileges(this.testRootNode.getPath());
        Privilege all = this.acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
        HashSet<Privilege> notGranted = new HashSet<Privilege>(Arrays.asList(all.getAggregatePrivileges()));
        for (int i = 0; i < privs.length; ++i) {
            if (privs[i].isAggregate()) {
                notGranted.removeAll(Arrays.asList(privs[i].getAggregatePrivileges()));
                continue;
            }
            notGranted.remove(privs[i]);
        }
        if (notGranted.isEmpty()) {
            AccessControlDiscoveryTest.assertTrue((boolean)this.acMgr.hasPrivileges(this.testRootNode.getPath(), new Privilege[]{all}));
        } else {
            Privilege[] toTest = notGranted.toArray(new Privilege[notGranted.size()]);
            AccessControlDiscoveryTest.assertTrue((!this.acMgr.hasPrivileges(this.testRootNode.getPath(), toTest) ? 1 : 0) != 0);
        }
    }

    public void testHasPrivilegesOnNotExistingNode() throws RepositoryException {
        String path = this.getPathToNonExistingNode();
        try {
            this.acMgr.hasPrivileges(path, new Privilege[0]);
            AccessControlDiscoveryTest.fail((String)"AccessControlManager.hasPrivileges for an invalid absPath must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testHasPrivilegesOnProperty() throws RepositoryException, NotExecutableException {
        String path = this.getPathToProperty();
        try {
            this.acMgr.hasPrivileges(path, new Privilege[0]);
            AccessControlDiscoveryTest.fail((String)"AccessControlManager.hasPrivileges for a property path must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testHasPrivilegesEmptyArray() throws RepositoryException, NotExecutableException {
        AccessControlDiscoveryTest.assertTrue((boolean)this.acMgr.hasPrivileges(this.testRootNode.getPath(), new Privilege[0]));
    }

    private static String getJCRName(String privilegeNameConstant, Session session) throws RepositoryException {
        int pos = privilegeNameConstant.indexOf(125);
        String uri = privilegeNameConstant.substring(1, pos);
        String localName = privilegeNameConstant.substring(pos + 1);
        return session.getNamespacePrefix(uri) + ":" + localName;
    }
}

