/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeNodeIteratorTest
extends AbstractMergeTest {
    Node[] expectedFailedNodes = new Node[3];

    protected void tearDown() throws Exception {
        for (int i = 0; i < this.expectedFailedNodes.length; ++i) {
            this.expectedFailedNodes[i] = null;
        }
        super.tearDown();
    }

    public void testNodeIterator() throws RepositoryException {
        Node nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
        Object failedNodes = nodeToMerge.merge(this.workspace.getName(), true);
        ArrayList nodeList = new ArrayList();
        while (failedNodes.hasNext()) {
            nodeList.add(failedNodes.next());
        }
        MergeNodeIteratorTest.assertEquals((String)"Node.merge() does not return a NodeIterator with expected number of elements.", (int)this.expectedFailedNodes.length, (int)nodeList.size());
        failedNodes = nodeList.iterator();
        block1: while (failedNodes.hasNext()) {
            String path = ((Node)failedNodes.next()).getPath();
            for (int i = 0; i < this.expectedFailedNodes.length; ++i) {
                String expectedPath;
                if (this.expectedFailedNodes[i] == null || !path.equals(expectedPath = this.expectedFailedNodes[i].getPath())) continue;
                this.expectedFailedNodes[i] = null;
                continue block1;
            }
            MergeNodeIteratorTest.fail((String)"Node.merge() must return a NodeIterator over all nodes that did receive a result of fail.");
        }
    }

    public void testNodeIteratorJcr2() throws RepositoryException {
        Node nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
        Object failedNodes = nodeToMerge.getSession().getWorkspace().getVersionManager().merge(nodeToMerge.getPath(), this.workspace.getName(), true);
        ArrayList nodeList = new ArrayList();
        while (failedNodes.hasNext()) {
            nodeList.add(failedNodes.next());
        }
        MergeNodeIteratorTest.assertEquals((String)"Node.merge() does not return a NodeIterator with expected number of elements.", (int)this.expectedFailedNodes.length, (int)nodeList.size());
        failedNodes = nodeList.iterator();
        block1: while (failedNodes.hasNext()) {
            String path = ((Node)failedNodes.next()).getPath();
            for (int i = 0; i < this.expectedFailedNodes.length; ++i) {
                String expectedPath;
                if (this.expectedFailedNodes[i] == null || !path.equals(expectedPath = this.expectedFailedNodes[i].getPath())) continue;
                this.expectedFailedNodes[i] = null;
                continue block1;
            }
            MergeNodeIteratorTest.fail((String)"Node.merge() must return a NodeIterator over all nodes that did receive a result of fail.");
        }
    }

    protected void initNodes() throws RepositoryException {
        VersionManager versionManager = this.testRootNode.getSession().getWorkspace().getVersionManager();
        Node mergeRootNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        Node nodeWS1_1 = mergeRootNode.addNode(this.nodeName1, this.versionableNodeType);
        Node nodeWS1_1Sub1 = nodeWS1_1.addNode(this.nodeName1, this.versionableNodeType);
        Node nodeWS1_2 = mergeRootNode.addNode(this.nodeName2, this.versionableNodeType);
        Node nodeWS1_2Sub1 = nodeWS1_2.addNode(this.nodeName1, this.versionableNodeType);
        Node nodeWS1_3 = mergeRootNode.addNode(this.nodeName3, this.versionableNodeType);
        this.testRootNode.getSession().save();
        versionManager.checkin(nodeWS1_1.getPath());
        versionManager.checkout(nodeWS1_1.getPath());
        versionManager.checkin(nodeWS1_1Sub1.getPath());
        versionManager.checkout(nodeWS1_1Sub1.getPath());
        versionManager.checkin(nodeWS1_2.getPath());
        versionManager.checkout(nodeWS1_2.getPath());
        versionManager.checkin(nodeWS1_2Sub1.getPath());
        versionManager.checkout(nodeWS1_2Sub1.getPath());
        versionManager.checkin(nodeWS1_3.getPath());
        versionManager.checkout(nodeWS1_3.getPath());
        this.workspaceW2.clone(this.workspace.getName(), mergeRootNode.getPath(), mergeRootNode.getPath(), true);
        Node nodeWS2_1 = (Node)this.superuserW2.getItem(nodeWS1_1.getPath());
        Node nodeWS2_2 = (Node)this.superuserW2.getItem(nodeWS1_2.getPath());
        Node nodeWS2_2Sub1 = (Node)this.superuserW2.getItem(nodeWS1_2Sub1.getPath());
        versionManager.checkin(nodeWS2_1.getPath());
        versionManager.checkin(nodeWS1_1.getPath());
        versionManager.checkin(nodeWS2_2.getPath());
        versionManager.checkin(nodeWS1_2.getPath());
        versionManager.checkin(nodeWS2_2Sub1.getPath());
        versionManager.checkin(nodeWS1_2Sub1.getPath());
        this.expectedFailedNodes[0] = nodeWS1_1;
        this.expectedFailedNodes[1] = nodeWS1_2;
        this.expectedFailedNodes[2] = nodeWS1_2Sub1;
    }
}

