/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeNonVersionableSubNodeTest
extends AbstractMergeTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMergeNodeNonVersionableSubNodeNonVersionableAncestor() throws RepositoryException {
        String nodeToMergePath = this.nodeName1 + "/" + this.nodeName2 + "/" + this.nodeName3;
        Node nodeToMerge = this.testRootNodeW2.getNode(nodeToMergePath);
        Node correspondingNode = this.testRootNode.getNode(nodeToMergePath);
        nodeToMerge.setProperty(this.propertyName1, "changed");
        nodeToMerge.save();
        nodeToMerge.merge(this.workspace.getName(), true);
        MergeNonVersionableSubNodeTest.assertTrue((boolean)nodeToMerge.getProperty(this.propertyName1).getString().equals(correspondingNode.getName()));
    }

    public void testMergeNodeNonVersionableSubNodeNonVersionableAncestorJcr2() throws RepositoryException {
        String nodeToMergePath = this.nodeName1 + "/" + this.nodeName2 + "/" + this.nodeName3;
        Node nodeToMerge = this.testRootNodeW2.getNode(nodeToMergePath);
        Node correspondingNode = this.testRootNode.getNode(nodeToMergePath);
        nodeToMerge.setProperty(this.propertyName1, "changed");
        nodeToMerge.getSession().save();
        nodeToMerge.getSession().getWorkspace().getVersionManager().merge(nodeToMerge.getPath(), this.workspace.getName(), true);
        MergeNonVersionableSubNodeTest.assertTrue((boolean)nodeToMerge.getProperty(this.propertyName1).getString().equals(correspondingNode.getName()));
    }

    public void testMergeNodeNonVersionableSubNodeUpdate() throws RepositoryException {
        String changedString = "changed" + System.currentTimeMillis();
        String nvSubNodePath = this.nodeName2 + "/" + this.nodeName3;
        Node n = this.testRootNodeW2.getNode(this.nodeName1);
        Node np = this.testRootNodeW2.getNode(this.nodeName1);
        n.checkout();
        Node nvSubNode = n.getNode(nvSubNodePath);
        nvSubNode.setProperty(this.propertyName1, changedString);
        n.save();
        n.checkin();
        np.merge(this.workspaceW2.getName(), true);
        Node nvSubNodeP = np.getNode(nvSubNodePath);
        MergeNonVersionableSubNodeTest.assertTrue((boolean)nvSubNodeP.getProperty(this.propertyName1).getString().equals(changedString));
    }

    public void testMergeNodeNonVersionableSubNodeUpdateJcr2() throws RepositoryException {
        String changedString = "changed" + System.currentTimeMillis();
        String nvSubNodePath = this.nodeName2 + "/" + this.nodeName3;
        Node n = this.testRootNodeW2.getNode(this.nodeName1);
        Node np = this.testRootNodeW2.getNode(this.nodeName1);
        n.getSession().getWorkspace().getVersionManager().checkout(n.getPath());
        Node nvSubNode = n.getNode(nvSubNodePath);
        nvSubNode.setProperty(this.propertyName1, changedString);
        n.getSession().save();
        n.getSession().getWorkspace().getVersionManager().checkin(n.getPath());
        np.getSession().getWorkspace().getVersionManager().merge(np.getPath(), this.workspaceW2.getName(), true);
        Node nvSubNodeP = np.getNode(nvSubNodePath);
        MergeNonVersionableSubNodeTest.assertTrue((boolean)nvSubNodeP.getProperty(this.propertyName1).getString().equals(changedString));
    }

    public void testMergeNodeNonVersionableSubNodeLeave() throws RepositoryException {
        String changedString = "changed" + System.currentTimeMillis();
        String nvSubNodePath = this.nodeName2 + "/" + this.nodeName3;
        Node n = this.testRootNodeW2.getNode(this.nodeName1);
        Node np = this.testRootNodeW2.getNode(this.nodeName1);
        np.checkout();
        Node nvSubNodeP = np.getNode(nvSubNodePath);
        nvSubNodeP.setProperty(this.propertyName1, changedString);
        np.save();
        np.checkin();
        np.merge(this.workspaceW2.getName(), true);
        Node nvSubNode = np.getNode(nvSubNodePath);
        MergeNonVersionableSubNodeTest.assertTrue((boolean)nvSubNode.getProperty(this.propertyName1).getString().equals(changedString));
    }

    public void testMergeNodeNonVersionableSubNodeLeaveJcr2() throws RepositoryException {
        String changedString = "changed" + System.currentTimeMillis();
        String nvSubNodePath = this.nodeName2 + "/" + this.nodeName3;
        Node n = this.testRootNodeW2.getNode(this.nodeName1);
        Node np = this.testRootNodeW2.getNode(this.nodeName1);
        np.getSession().getWorkspace().getVersionManager().checkout(np.getPath());
        Node nvSubNodeP = np.getNode(nvSubNodePath);
        nvSubNodeP.setProperty(this.propertyName1, changedString);
        np.getSession().save();
        np.getSession().getWorkspace().getVersionManager().checkin(np.getPath());
        np.getSession().getWorkspace().getVersionManager().merge(np.getPath(), this.workspaceW2.getName(), true);
        Node nvSubNode = np.getNode(nvSubNodePath);
        MergeNonVersionableSubNodeTest.assertTrue((boolean)nvSubNode.getProperty(this.propertyName1).getString().equals(changedString));
    }

    protected void initNodes() throws RepositoryException {
        Node topVNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        topVNode.setProperty(this.propertyName1, topVNode.getName());
        Node subNvNode = topVNode.addNode(this.nodeName2, this.testNodeType);
        subNvNode.setProperty(this.propertyName1, subNvNode.getName());
        Node subSubNvNode = subNvNode.addNode(this.nodeName3, this.testNodeType);
        subSubNvNode.setProperty(this.propertyName1, subSubNvNode.getName());
        this.testRootNode.getSession().save();
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), topVNode.getPath(), topVNode.getPath(), true);
        this.log.println(topVNode.getPath() + " cloned on " + this.superuserW2.getWorkspace().getName() + " at " + topVNode.getPath());
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
    }
}

