/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.persistence.Transient;
import org.jcrom.annotations.JcrBaseVersionCreated;
import org.jcrom.annotations.JcrBaseVersionName;
import org.jcrom.annotations.JcrCheckedout;
import org.jcrom.annotations.JcrCreated;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrReference;
import org.jcrom.annotations.JcrUUID;
import org.jcrom.annotations.JcrVersionCreated;
import org.jcrom.annotations.JcrVersionName;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.cream.JCR;
import play.modules.cream.ocm.JcrMapper;
import play.modules.cream.ocm.JcrQuery;
import play.modules.cream.ocm.JcrQueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrModelLoader
implements Model.Factory {
    private final Class<? extends Model> clazz;

    public JcrModelLoader(Class<? extends Model> modelClass) {
        this.clazz = modelClass;
    }

    public Long count(List<String> searchFields, String keywords, String where) {
        JcrQueryResult<? extends Model> queryResult = this.doQuery(null, null, searchFields, keywords, where);
        return queryResult.count();
    }

    public void deleteAll() {
        try {
            Session session = JCR.getSession();
            try {
                Node node = session.getNode(JcrMapper.getDefaultPath(this.clazz));
                if (node != null) {
                    node.remove();
                }
            }
            catch (PathNotFoundException pathNotFoundException) {}
        }
        catch (RepositoryException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public List<Model> fetch(int offset, int size, String orderBy, String order, List<String> searchFields, String keywords, String where) {
        JcrQueryResult<? extends Model> queryResult = this.doQuery(orderBy, order, searchFields, keywords, where);
        int page = offset > size ? offset / size : 1;
        return queryResult.fetch(page, size);
    }

    public Model findById(Object id) {
        if (id == null) {
            return null;
        }
        return JcrMapper.loadByUUID(this.clazz, (String)id);
    }

    public String keyName() {
        return this.keyField().getName();
    }

    public Class<?> keyType() {
        return this.keyField().getType();
    }

    public Object keyValue(Model m) {
        try {
            return this.keyField().get(m);
        }
        catch (Exception ex) {
            throw new UnexpectedException((Throwable)ex);
        }
    }

    public List<Model.Property> listProperties() {
        ArrayList<Model.Property> properties = new ArrayList<Model.Property>();
        LinkedHashSet fields = new LinkedHashSet();
        Class<? extends Model> tclazz = this.clazz;
        while (!tclazz.equals(Object.class)) {
            Collections.addAll(fields, tclazz.getDeclaredFields());
            tclazz = tclazz.getSuperclass();
        }
        for (Field f : fields) {
            Model.Property mp;
            if (Modifier.isTransient(f.getModifiers()) || f.isAnnotationPresent(Transient.class) || (mp = this.buildProperty(f)) == null) continue;
            properties.add(mp);
        }
        return properties;
    }

    Model.Property buildProperty(final Field field) {
        Model.Property modelProperty = new Model.Property();
        modelProperty.type = field.getType();
        modelProperty.field = field;
        boolean isReference = field.isAnnotationPresent(JcrReference.class);
        if (Collection.class.isAssignableFrom(field.getType())) {
            final Class fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (isReference) {
                modelProperty.isRelation = true;
                modelProperty.isMultiple = true;
                modelProperty.relationType = fieldType;
                modelProperty.choices = new Model.Choices(){

                    public List<Object> list() {
                        String path = JcrMapper.getDefaultPath(fieldType);
                        return JcrMapper.findAll(fieldType, path).fetch();
                    }
                };
            }
        } else if (Model.class.isAssignableFrom(field.getType()) && isReference) {
            modelProperty.isRelation = true;
            modelProperty.relationType = field.getType();
            modelProperty.choices = new Model.Choices(){

                public List<Object> list() {
                    String path = JcrMapper.getDefaultPath(field.getType());
                    return JcrMapper.findAll(field.getType(), path).fetch();
                }
            };
        }
        if (field.getType().isEnum()) {
            modelProperty.choices = new Model.Choices(){

                public List<Object> list() {
                    return Arrays.asList(field.getType().getEnumConstants());
                }
            };
        }
        modelProperty.name = field.getName();
        if (field.getType().equals(String.class)) {
            modelProperty.isSearchable = true;
        }
        if (field.isAnnotationPresent(JcrUUID.class) || field.isAnnotationPresent(JcrCheckedout.class) || field.isAnnotationPresent(JcrCreated.class) || field.isAnnotationPresent(JcrVersionCreated.class) || field.isAnnotationPresent(JcrBaseVersionCreated.class) || field.isAnnotationPresent(JcrVersionName.class) || field.isAnnotationPresent(JcrPath.class) || field.isAnnotationPresent(JcrBaseVersionName.class) || field.isAnnotationPresent(JcrPath.class)) {
            modelProperty.isGenerated = true;
        }
        return modelProperty;
    }

    Field keyField() {
        Class<? extends Model> c = this.clazz;
        try {
            while (!c.equals(Object.class)) {
                for (Field field : c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(JcrUUID.class)) continue;
                    field.setAccessible(true);
                    return field;
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new UnexpectedException("Error while determining the object @Id for an object of type " + this.clazz);
        }
        throw new UnexpectedException("Cannot get the object @JcrUUID for an object of type " + this.clazz);
    }

    private void appendOrderBy(String orderBy, String order, StringBuilder q) {
        if (order == null || !order.equals("ASC") && !order.equals("DESC")) {
            order = "ASC";
        }
        q.append(" order by ");
        q.append(orderBy);
        q.append(" ");
        q.append(order);
    }

    private StringBuilder buildSelect(List<String> searchFields, String keywords, String where) {
        String searchQuery;
        StringBuilder q = new StringBuilder("select * from [nt:unstructured] where ischildnode(${path})");
        if (keywords != null && !keywords.equals("") && !(searchQuery = this.getSearchQuery(searchFields, keywords)).equals("")) {
            q.append(" and (");
            q.append(searchQuery);
            q.append(')');
        }
        q.append(where != null ? " and " + where : "");
        return q;
    }

    private JcrQueryResult<? extends Model> doQuery(String orderBy, String order, List<String> searchFields, String keywords, String where) {
        StringBuilder q = this.buildSelect(searchFields, keywords, where);
        if (orderBy != null) {
            this.appendOrderBy(orderBy, order, q);
        }
        JcrQuery query = JcrQuery.builder(this.clazz, q.toString()).setString("path", JcrMapper.getDefaultPath(this.clazz)).setString("keywords", keywords).build();
        return query.excute();
    }

    private String getSearchQuery(List<String> searchFields, String keywords) {
        StringBuilder q = new StringBuilder();
        if (keywords != null && !keywords.equals("")) {
            for (Model.Property property : this.listProperties()) {
                if (!property.isSearchable || searchFields != null && !searchFields.isEmpty() && !searchFields.contains(property.name)) continue;
                if (q.length() > 1) {
                    q.append(" or ");
                }
                q.append("contains(");
                q.append(property.name);
                q.append(", ${keywords})");
            }
        }
        return q.toString();
    }
}

