/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.TransientRepository;
import org.jcrom.Jcrom;
import org.jcrom.annotations.JcrNode;
import play.Invoker;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.cream.JCR;
import play.modules.cream.JcrEnhancer;
import play.modules.cream.JcrMetadata;
import play.modules.cream.JcrModelLoader;
import play.modules.cream.Model;
import play.modules.cream.annotations.JcrNoSession;
import play.modules.cream.annotations.JcrSession;
import play.modules.cream.helpers.JcrRepositoryCreationHelper;
import play.modules.cream.helpers.JcrRepositoryHelper;
import play.modules.cream.ocm.JcrMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrPlugin
extends PlayPlugin {
    public void afterInvocation() {
        JCR.closeSession();
    }

    public void beforeInvocation() {
        Invoker.InvocationContext current = Invoker.InvocationContext.current();
        if (!current.isAnnotationPresent(JcrNoSession.class)) {
            Session currentSession = this.createCurrentSession(current);
            JCR.addSession(currentSession);
        }
    }

    public Object bind(String name, Class clazz, Type type, Annotation[] annotations, Map<String, String[]> params) {
        if (Model.class.isAssignableFrom(clazz)) {
            String keyName = Model.Manager.factoryFor((Class)clazz).keyName();
            String idKey = name + "." + keyName;
            if (params.containsKey(idKey) && params.get(idKey).length > 0 && params.get(idKey)[0] != null && params.get(idKey)[0].trim().length() > 0) {
                String id = params.get(idKey)[0];
                try {
                    Model o = (Model)JcrMapper.loadByUUID(clazz, id);
                    if (o != null) {
                        return Model.edit(o, name, params, annotations);
                    }
                }
                catch (Exception e) {
                    throw new UnexpectedException((Throwable)e);
                }
            }
            return Model.create(clazz, name, params, annotations);
        }
        return super.bind(name, clazz, type, annotations, params);
    }

    public Object bind(String name, Object o, Map<String, String[]> params) {
        if (o instanceof Model) {
            return Model.edit(o, name, params, null);
        }
        return null;
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        new JcrEnhancer().enhanceThisClass(applicationClass);
    }

    public String getStatus() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("Jcr Repository:");
        out.println("~~~~~~~~~~~~~~");
        if (JcrRepositoryHelper.repository == null) {
            out.println("(not yet initialized)");
            return sw.toString();
        }
        out.println("name: " + JcrRepositoryHelper.repository.getDescriptor("jcr.repository.name"));
        out.println("version: " + JcrRepositoryHelper.repository.getDescriptor("jcr.repository.version"));
        out.println("default workspace: " + JcrRepositoryHelper.defaultWorkspace);
        out.println("\nJcr Mapped Classes:");
        out.println("~~~~~~~~~~~~~~~~~~");
        for (Class clazz : JcrMapper.jcrom.getMappedClasses()) {
            out.println(clazz.getName());
        }
        return sw.toString();
    }

    public void invocationFinally() {
        JCR.closeSession();
    }

    public Model.Factory modelFactory(Class<? extends play.db.Model> modelClass) {
        return modelClass.isAnnotationPresent(JcrNode.class) ? new JcrModelLoader(modelClass) : null;
    }

    public void onApplicationStart() {
        this.mapJcrEntities();
        this.setUpJcrRepository();
    }

    public void onApplicationStop() {
        JcrRepositoryHelper.shutdown();
    }

    public void onInvocationException(Throwable e) {
        JCR.closeSession();
    }

    private Session createCurrentSession(Invoker.InvocationContext current) {
        JcrSession jcrConfig = (JcrSession)current.getAnnotation(JcrSession.class);
        Session currentSession = jcrConfig != null && StringUtils.isNotBlank((String)jcrConfig.workspace()) ? JcrRepositoryHelper.openSession(jcrConfig.workspace()) : JcrRepositoryHelper.openSession();
        JcrPlugin.postEvent((String)(JcrPlugin.class.getSimpleName() + ".JcrSessionCreated"), (Object)currentSession);
        return currentSession;
    }

    private void mapJcrEntities() {
        Jcrom jcrom = new Jcrom();
        List jcrClasses = Play.classloader.getAnnotatedClasses(JcrNode.class);
        for (Class jcrClass : jcrClasses) {
            Logger.trace((String)"Jcrom mapping of %s", (Object[])new Object[]{jcrClass.getName()});
            jcrom.map(jcrClass);
        }
        JcrMetadata jcrMetadata = JcrMetadata.getInstance();
        jcrMetadata.intialize(jcrom);
        JcrMapper.jcrom = jcrom;
    }

    private void setUpJcrRepository() {
        TransientRepository repository;
        Properties p = Play.configuration;
        String username = p.getProperty("cream.jcr.username", "anonymous");
        String password = p.getProperty("cream.jcr.password", "");
        String workspace = p.getProperty("cream.jcr.workspace", "default");
        String repoConfiguration = p.getProperty("cream.jcr.configuration", "/play/modules/cream/repository.xml");
        if ("transient".equals(p.getProperty("cream.jcr.mode"))) {
            repository = new TransientRepository();
        } else {
            String url = p.getProperty("cream.jcr.url", "");
            repository = JcrRepositoryCreationHelper.createRepository(url, repoConfiguration);
        }
        JcrRepositoryHelper.repository = repository;
        JcrRepositoryHelper.defaultCredentials = new SimpleCredentials(username, password.toCharArray());
        JcrRepositoryHelper.defaultWorkspace = workspace;
    }
}

