/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jcrom.annotations.JcrBaseVersionCreated;
import org.jcrom.annotations.JcrCheckedout;
import org.jcrom.annotations.JcrCreated;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrReference;
import org.jcrom.annotations.JcrUUID;
import org.jcrom.annotations.JcrVersionCreated;
import org.jcrom.annotations.JcrVersionName;
import play.Play;
import play.data.binding.BeanWrapper;
import play.data.validation.Validation;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.cream.ocm.JcrMapper;
import play.modules.cream.ocm.JcrQueryResult;
import play.modules.cream.ocm.JcrVersionMapper;
import play.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model
implements play.db.Model {
    @JcrUUID
    public String uuid;
    @JcrPath
    public String path;
    @JcrCreated
    public Date created;
    @JcrBaseVersionCreated
    public Date baseVersionCreated;
    @JcrVersionCreated
    public Date versionCreated;
    @JcrVersionName
    public String versionName;
    @JcrCheckedout
    public boolean checkedout;

    public static JcrQueryResult all() {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static JcrQueryResult all(String rootPath) {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static <T extends Model> T create(Class<T> type, String name, Map<String, String[]> params, Annotation[] annotations) {
        try {
            Constructor<T> c = type.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            Model model = (Model)c.newInstance(new Object[0]);
            if (model.path == null) {
                model.path = JcrMapper.getDefaultPath(type);
            }
            return Model.edit(model, name, params, annotations);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Model> T edit(Object o, String name, Map<String, String[]> params, Annotation[] annotations) {
        try {
            BeanWrapper bw = new BeanWrapper(o.getClass());
            HashSet fields = new HashSet();
            Class<?> clazz = o.getClass();
            while (!clazz.equals(Object.class)) {
                Collections.addAll(fields, clazz.getDeclaredFields());
                clazz = clazz.getSuperclass();
            }
            for (Field field : fields) {
                String fieldKey;
                String[] enumValues;
                Class c;
                boolean isEntity = false;
                String relation = null;
                boolean multiple = false;
                if (Collection.class.isAssignableFrom(field.getType()) && field.isAnnotationPresent(JcrReference.class)) {
                    Class fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    isEntity = true;
                    relation = fieldType.getName();
                    multiple = true;
                } else if (field.isAnnotationPresent(JcrReference.class)) {
                    isEntity = true;
                    relation = field.getType().getName();
                }
                if (isEntity && Model.class.isAssignableFrom(c = Play.classloader.loadClass(relation))) {
                    String keyName = Model.Manager.factoryFor((Class)c).keyName();
                    if (multiple && Collection.class.isAssignableFrom(field.getType())) {
                        AbstractCollection l = new ArrayList();
                        if (SortedSet.class.isAssignableFrom(field.getType())) {
                            l = new TreeSet();
                        } else if (Set.class.isAssignableFrom(field.getType())) {
                            l = new HashSet();
                        }
                        String[] ids = params.get(name + "." + field.getName() + "." + keyName);
                        if (ids != null) {
                            params.remove(name + "." + field.getName() + "." + keyName);
                            for (String _id : ids) {
                                if (_id.equals("")) continue;
                                Constructor ctor = c.getDeclaredConstructor(new Class[0]);
                                try {
                                    Model to = (Model)ctor.newInstance(new Object[0]);
                                    to.uuid = _id;
                                    l.add(to);
                                }
                                catch (Exception e) {
                                    Validation.addError((String)(name + "." + field.getName()), (String)"validation.notFound", (String[])new String[]{_id});
                                }
                            }
                            bw.set(field.getName(), o, l);
                        }
                    } else {
                        String[] ids = params.get(name + "." + field.getName() + "." + keyName);
                        if (ids != null && ids.length > 0 && !ids[0].equals("")) {
                            params.remove(name + "." + field.getName() + "." + keyName);
                            Constructor ctor = c.getDeclaredConstructor(new Class[0]);
                            try {
                                String localName = name + "." + field.getName();
                                Model to = (Model)ctor.newInstance(new Object[0]);
                                to.uuid = ids[0];
                                Model.edit(to, localName, params, field.getAnnotations());
                                params = Utils.filterMap(params, (String)localName);
                                bw.set(field.getName(), o, (Object)to);
                            }
                            catch (Exception e) {
                                Validation.addError((String)(name + "." + field.getName()), (String)"validation.notFound", (String[])new String[]{ids[0]});
                            }
                        } else if (ids != null && ids.length > 0 && ids[0].equals("")) {
                            bw.set(field.getName(), o, null);
                            params.remove(name + "." + field.getName() + "." + keyName);
                        }
                    }
                }
                if (!field.getType().isEnum() || (enumValues = params.get(fieldKey = name + "." + field.getName())) == null) continue;
                Object enumValue = Enum.valueOf(field.getType(), enumValues[0]);
                bw.set(field.getName(), o, enumValue);
                params.remove(fieldKey);
            }
            bw.bind(name, o.getClass(), params, "", o, annotations);
            return (T)((Model)o);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static JcrQueryResult find(String query, Object ... params) {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static <T extends Model> List<T> findAll() {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static <T extends Model> List<T> findAll(String rootPath) {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static JcrQueryResult findBy(String where, Object ... params) {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static <T extends Model> T findById(Object id) {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static JcrQueryResult findByPath(String path, String where, Object ... params) {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static <T extends Model> T get() {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public static <T extends Model> T get(String path) {
        throw new UnsupportedOperationException("Class not enhanced.");
    }

    public void _delete() {
        JcrMapper.remove(this);
    }

    public Object _key() {
        return this.getId();
    }

    public void _save() {
        if (this.path == null) {
            this.path = JcrMapper.getDefaultPath(this.getClass());
            JcrMapper.create(this);
        } else if (this.uuid == null) {
            JcrMapper.create(this);
        } else {
            JcrMapper.update(this);
        }
    }

    public boolean create() {
        JcrMapper.create(this);
        return true;
    }

    public <T extends Model> T delete() {
        this._delete();
        return (T)this;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getId() {
        return this.uuid;
    }

    public String getPath() {
        return this.path;
    }

    public Date getUpdated() {
        return this.versionCreated;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public <T> List<T> getVersions() {
        return JcrVersionMapper.getVersionList(this.getClass(), this.path);
    }

    public boolean isCheckedout() {
        return this.checkedout;
    }

    public <T> T merge() {
        return (T)JcrMapper.merge(this);
    }

    public <T> T merge(String childNodeFilter, int maxDepth) {
        return (T)JcrMapper.merge(this, childNodeFilter, maxDepth);
    }

    public <T extends Model> T save() {
        this._save();
        return (T)this;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public <T> T update() {
        return (T)JcrMapper.update(this);
    }

    public <T> T update(String childNodeFilter, int maxDepth) {
        return (T)JcrMapper.update(this, childNodeFilter, maxDepth);
    }

    public boolean validateAndCreate() {
        if (Validation.current().valid((Object)this).ok) {
            return this.create();
        }
        return false;
    }

    public boolean validateAndSave() {
        if (Validation.current().valid((Object)this).ok) {
            this.save();
            return true;
        }
        return false;
    }
}

