/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Repository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import play.Play;
import play.exceptions.UnexpectedException;
import play.modules.cream.helpers.RmiRepositoryFactory;
import play.vfs.VirtualFile;

public class JcrRepositoryCreationHelper {
    public static void copyResourceToFile(String source, File destination) {
        VirtualFile conf = Play.getVirtualFile((String)source);
        InputStream in = conf == null || !conf.exists() ? JcrRepositoryCreationHelper.class.getResourceAsStream(source) : conf.inputstream();
        if (in == null) {
            throw new UnexpectedException("Resource: " + source + " does not exist");
        }
        try {
            FileOutputStream fos = new FileOutputStream(destination);
            JcrRepositoryCreationHelper.copyStream(in, fos, 4096);
            fos.close();
            in.close();
        }
        catch (IOException e) {
            throw new UnexpectedException("Could not copy class resource: " + source + " to destination: " + destination.getAbsolutePath());
        }
    }

    public static int copyStream(InputStream in, OutputStream out, int bufSize) throws IOException {
        int byteCount;
        if (bufSize <= 0) {
            throw new IllegalArgumentException("The parameter 'bufSize' must not be <= 0");
        }
        byte[] buffer = new byte[bufSize];
        int bytesCopied = 0;
        while ((byteCount = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, byteCount);
            bytesCopied += byteCount;
        }
        return bytesCopied;
    }

    public static Repository createFileRepository(String url, String repoConfiguration) {
        try {
            File home = new File(url.substring(6));
            JcrRepositoryCreationHelper.mkdirs(home);
            File cfg = new File(home, "repository.xml");
            if (!cfg.exists()) {
                JcrRepositoryCreationHelper.copyResourceToFile(repoConfiguration, cfg);
            }
            FileInputStream configStream = new FileInputStream(cfg);
            RepositoryConfig config = RepositoryConfig.create((InputStream)configStream, (String)home.getAbsolutePath());
            return RepositoryImpl.create((RepositoryConfig)config);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create file repository at url: " + url, e);
        }
    }

    public static Repository createRepository(String url, String repoConfiguration) {
        if (url.startsWith("rmi://")) {
            return JcrRepositoryCreationHelper.createRmiRepository(url);
        }
        if (url.startsWith("file://")) {
            return JcrRepositoryCreationHelper.createFileRepository(url, repoConfiguration);
        }
        throw new RuntimeException("Unsupported repository location url. Only prefix rmi:// and file:// are supported");
    }

    public static Repository createRmiRepository(String url) {
        try {
            JcrRepositoryCreationHelper.class.getClassLoader().loadClass("org.apache.jackrabbit.rmi.client.ClientRepositoryFactory");
            return RmiRepositoryFactory.getRmiRepository(url);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create rmi repository instance at url: " + url, e);
        }
    }

    public static void mkdirs(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Could not create directory: " + file.getAbsolutePath());
        }
    }

    private JcrRepositoryCreationHelper() {
    }
}

