/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream.helpers;

import org.apache.commons.lang.StringUtils;

public class JcrUtils {
    public static String buildSelect(String path, String where, String nodeType) {
        StringBuilder queryString = new StringBuilder("select * from ");
        queryString.append('[');
        queryString.append(nodeType);
        queryString.append(']');
        boolean hasPath = StringUtils.isNotBlank((String)path);
        boolean hasWhere = StringUtils.isNotBlank((String)where);
        if (hasPath || hasWhere) {
            queryString.append(" where ");
            if (hasPath) {
                queryString.append("ISCHILDNODE('");
                queryString.append(JcrUtils.escapeSingleQuote(path));
                queryString.append("')");
            }
            if (hasPath && hasWhere && !where.toLowerCase().startsWith("order by")) {
                queryString.append(" and ");
            }
            queryString.append(where);
        }
        return queryString.toString();
    }

    public static String escapeSingleQuote(String keywords) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keywords.length(); ++i) {
            char c = keywords.charAt(i);
            if (c == '\'') {
                sb.append('\\');
                sb.append(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String queryFormat(String queryString, Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof String)) continue;
            params[i] = "'" + JcrUtils.escapeSingleQuote((String)params[i]) + "'";
        }
        return String.format(queryString, params);
    }
}

