/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream.ocm;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionManager;
import org.jcrom.JcrMappingException;
import org.jcrom.Jcrom;
import play.Play;
import play.exceptions.UnexpectedException;
import play.modules.cream.JCR;
import play.modules.cream.JcrMetadata;
import play.modules.cream.Model;
import play.modules.cream.helpers.JcrUtils;
import play.modules.cream.helpers.NullAwareBeanUtilsBean;
import play.modules.cream.ocm.JcrQueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrMapper {
    public static Jcrom jcrom;
    public static NullAwareBeanUtilsBean beanUtils;

    public static Node addNode(Node parentNode, Object entity) throws JcrMappingException {
        return jcrom.addNode(parentNode, entity);
    }

    public static Node addNode(Node arg0, Object arg1, String[] arg2) throws JcrMappingException {
        return jcrom.addNode(arg0, arg1, arg2);
    }

    public static <T> T create(String parentNodePath, T entity) {
        try {
            String relativePath;
            JcrMetadata.MD md = JcrMapper.getMetadata(entity.getClass());
            String entityName = jcrom.getName(entity);
            if (entityName == null || entityName.equals("")) {
                throw new JcrMappingException("The name of the entity being created is empty!");
            }
            if (parentNodePath == null || parentNodePath.equals("")) {
                throw new JcrMappingException("The parent path of the entity being created is empty!");
            }
            Session session = JcrMapper.getSession();
            Node rootNode = session.getRootNode();
            Node parentNode = parentNodePath.equals("/") ? rootNode : (rootNode.hasNode(relativePath = JcrMapper.relativePath(parentNodePath)) ? rootNode.getNode(relativePath) : rootNode.addNode(relativePath));
            Node newNode = jcrom.addNode(parentNode, entity, md.mixinTypes);
            session.save();
            if (md.isVersionable) {
                JcrMapper.checkinRecursively(session.getWorkspace().getVersionManager(), newNode);
            }
            return entity;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not create node", (Throwable)e);
        }
    }

    public static <T> T create(T entity) {
        return JcrMapper.create(jcrom.getPath(entity), entity);
    }

    public static boolean exists(String path) {
        try {
            return JcrMapper.getSession().getRootNode().hasNode(JcrMapper.relativePath(path));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not check if node exists", (Throwable)e);
        }
    }

    public static <T> JcrQueryResult<T> find(String className, String queryString, Object ... params) throws RepositoryException {
        Class clazz = Play.classloader.getClassIgnoreCase(className);
        return JcrMapper.executeQuery(clazz, queryString, params);
    }

    public static <T> JcrQueryResult<T> findAll(Class<T> clazz, String rootPath) {
        return JcrMapper.findAll(clazz, rootPath, "*", -1);
    }

    public static <T> JcrQueryResult<T> findAll(Class<T> clazz, String rootPath, String childNameFilter, int maxDepth) {
        try {
            NodeIterator nodeIterator = JcrMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(rootPath)).getNodes();
            return JcrMapper.toJcrQuery(clazz, nodeIterator);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes", (Throwable)e);
        }
    }

    public static <T> JcrQueryResult<T> findAll(String className) {
        Class clazz = Play.classloader.getClassIgnoreCase(className);
        return JcrMapper.findAll(clazz, JcrMapper.getDefaultPath(clazz));
    }

    public static <T> JcrQueryResult<T> findAll(String className, String rootPath) {
        return JcrMapper.findAll(Play.classloader.getClassIgnoreCase(className), rootPath);
    }

    public static <T> JcrQueryResult<T> findBy(Class<T> clazz, String path, String where, Object ... params) throws RepositoryException {
        String nodeType = JcrMapper.getMetadata(clazz).nodeType;
        String queryString = JcrUtils.buildSelect(path, where, nodeType);
        return JcrMapper.executeQuery(clazz, queryString, params);
    }

    public static <T> JcrQueryResult<T> findBy(String className, String where, Object ... params) throws RepositoryException {
        Class clazz = Play.classloader.getClassIgnoreCase(className);
        return JcrMapper.findBy(clazz, JcrMapper.getDefaultPath(clazz), where, params);
    }

    public static <T> JcrQueryResult<T> findByPath(String className, String path, String where, Object ... params) throws RepositoryException {
        Class clazz = Play.classloader.getClassIgnoreCase(className);
        return JcrMapper.findBy(clazz, path, where, params);
    }

    public static <T> T fromNode(Class<T> entityClass, Node node) throws JcrMappingException {
        return (T)jcrom.fromNode(entityClass, node);
    }

    public static <T> T fromNode(Class<T> entityClass, Node node, String childNodeFilter, int maxDepth) throws JcrMappingException {
        return (T)jcrom.fromNode(entityClass, node, childNodeFilter, maxDepth);
    }

    public static <T> T get(Class<T> clazz, String path) {
        return JcrMapper.get(clazz, path, "*", -1);
    }

    public static <T> T get(Class<T> clazz, String path, String childNodeFilter, int maxDepth) {
        if (JcrMapper.exists(path)) {
            Node node;
            try {
                node = JcrMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(path));
            }
            catch (RepositoryException e) {
                throw new JcrMappingException("Could not get node", (Throwable)e);
            }
            return (T)jcrom.fromNode(clazz, node, childNodeFilter, maxDepth);
        }
        return null;
    }

    public static <T extends Model> T get(String className) {
        Class clazz = Play.classloader.getClassIgnoreCase(className);
        return (T)((Model)JcrMapper.get(clazz, JcrMapper.getDefaultPath(clazz)));
    }

    public static <T extends Model> T get(String className, String path) {
        Class clazz = Play.classloader.getClassIgnoreCase(className);
        return (T)((Model)JcrMapper.get(clazz, path));
    }

    public static String getDefaultPath(Class<?> modelClass) {
        return "/" + modelClass.getSimpleName().toLowerCase();
    }

    public static String getName(Object arg0) throws JcrMappingException {
        return jcrom.getName(arg0);
    }

    public static String getPath(Object arg0) throws JcrMappingException {
        return jcrom.getPath(arg0);
    }

    public static long getSize(String rootPath) {
        try {
            NodeIterator nodeIterator = JcrMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(rootPath)).getNodes();
            return nodeIterator.getSize();
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get list size", (Throwable)e);
        }
    }

    public static boolean isMapped(Class entityClass) {
        return jcrom.isMapped(entityClass);
    }

    public static <T> T loadByUUID(Class<T> clazz, String uuid) {
        return JcrMapper.loadByUUID(clazz, uuid, "*", -1);
    }

    public static <T> T loadByUUID(Class<T> clazz, String uuid, String childNodeFilter, int maxDepth) {
        Node node;
        try {
            node = JcrMapper.getSession().getNodeByIdentifier(uuid);
        }
        catch (RepositoryException e) {
            return null;
        }
        return (T)jcrom.fromNode(clazz, node, childNodeFilter, maxDepth);
    }

    public static <T extends Model> T loadByUUID(String className, String uuid) {
        return (T)((Model)JcrMapper.loadByUUID(Play.classloader.getClassIgnoreCase(className), uuid));
    }

    public static void map(Class classToMap) {
        jcrom.map(classToMap);
    }

    public static <T extends Model> T merge(T entity) {
        return JcrMapper.merge(entity, "*", -1);
    }

    public static <T extends Model> T merge(T entity, String childNodeFilter, int maxDepth) {
        Model original = (Model)JcrMapper.loadByUUID(entity.getClass(), entity.uuid);
        try {
            beanUtils.copyProperties(original, entity);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedException((Throwable)e);
        }
        return (T)JcrMapper.update(original, childNodeFilter, maxDepth);
    }

    public static <T> T move(T entity, String newParentPath) {
        try {
            String sourcePath = jcrom.getPath(entity);
            String entityName = jcrom.getName(entity);
            Node oldParent = null;
            Node newParent = null;
            JcrMetadata.MD md = JcrMapper.getMetadata(entity.getClass());
            Session session = JcrMapper.getSession();
            VersionManager versionManager = null;
            if (md.isVersionable) {
                versionManager = session.getWorkspace().getVersionManager();
                oldParent = session.getRootNode().getNode(JcrMapper.relativePath(sourcePath)).getParent();
                Node node = newParent = newParentPath.equals("/") ? session.getRootNode() : session.getRootNode().getNode(JcrMapper.relativePath(newParentPath));
                if (JcrMapper.hasMixinType(oldParent, "mix:versionable")) {
                    versionManager.checkout(oldParent.getPath());
                }
                if (JcrMapper.hasMixinType(newParent, "mix:versionable")) {
                    versionManager.checkout(newParent.getPath());
                }
            }
            if (newParentPath.equals("/")) {
                session.move(sourcePath, newParentPath + entityName);
            } else {
                session.move(sourcePath, newParentPath + "/" + entityName);
            }
            session.save();
            if (md.isVersionable) {
                if (JcrMapper.hasMixinType(oldParent, "mix:versionable") && oldParent.isCheckedOut()) {
                    versionManager.checkin(oldParent.getPath());
                }
                if (JcrMapper.hasMixinType(newParent, "mix:versionable") && newParent.isCheckedOut()) {
                    versionManager.checkin(newParent.getPath());
                }
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not move node", (Throwable)e);
        }
        return entity;
    }

    public static void remove(Model model) {
        JcrMapper.remove(jcrom.getPath((Object)model), model.getClass());
    }

    public static void remove(String path, Class<?> clazz) {
        try {
            Node parent = null;
            JcrMetadata.MD md = JcrMapper.getMetadata(clazz);
            Session session = JcrMapper.getSession();
            VersionManager versionManager = null;
            if (md.isVersionable) {
                versionManager = JcrMapper.getSession().getWorkspace().getVersionManager();
                parent = session.getRootNode().getNode(JcrMapper.relativePath(path)).getParent();
                if (JcrMapper.hasMixinType(parent, "mix:versionable")) {
                    versionManager.checkout(parent.getPath());
                }
            }
            session.getRootNode().getNode(JcrMapper.relativePath(path)).remove();
            session.save();
            if (md.isVersionable && JcrMapper.hasMixinType(parent, "mix:versionable") && parent.isCheckedOut()) {
                versionManager.checkin(parent.getPath());
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove node", (Throwable)e);
        }
    }

    public static void removeByUUID(String uuid, Class<?> clazz) {
        try {
            Session session = JcrMapper.getSession();
            Node node = session.getNodeByIdentifier(uuid);
            Node parent = null;
            JcrMetadata.MD md = JcrMapper.getMetadata(clazz);
            VersionManager versionManager = null;
            if (md.isVersionable) {
                versionManager = session.getWorkspace().getVersionManager();
                parent = node.getParent();
                if (JcrMapper.hasMixinType(parent, "mix:versionable")) {
                    versionManager.checkout(parent.getPath());
                }
            }
            node.remove();
            session.save();
            if (md.isVersionable && JcrMapper.hasMixinType(parent, "mix:versionable") && parent.isCheckedOut()) {
                versionManager.checkin(parent.getPath());
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove node", (Throwable)e);
        }
    }

    public static void setBaseVersionInfo(Object object, String name, Calendar created) {
        jcrom.setBaseVersionInfo(object, name, created);
    }

    public static <T> List<T> toList(Class<T> clazz, NodeIterator nodeIterator, String childNameFilter, int maxDepth) {
        ArrayList<Object> objects = new ArrayList<Object>();
        while (nodeIterator.hasNext()) {
            objects.add(jcrom.fromNode(clazz, nodeIterator.nextNode(), childNameFilter, maxDepth));
        }
        return objects;
    }

    public static <T> List<T> toList(Class<T> clazz, NodeIterator nodeIterator, String childNameFilter, int maxDepth, long resultSize) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (long counter = 0L; nodeIterator.hasNext() && counter != resultSize; ++counter) {
            objects.add(jcrom.fromNode(clazz, nodeIterator.nextNode(), childNameFilter, maxDepth));
        }
        return objects;
    }

    public static <T> T update(T entity) {
        return JcrMapper.update(entity, "*", -1);
    }

    public static <T> T update(T entity, String childNodeFilter, int maxDepth) {
        Node node;
        try {
            node = JcrMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(jcrom.getPath(entity)));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", (Throwable)e);
        }
        return JcrMapper.update(node, entity, childNodeFilter, maxDepth);
    }

    public static <T> T updateByUUID(T entity, String uuid) {
        return JcrMapper.updateByUUID(entity, uuid, "*", -1);
    }

    public static <T> T updateByUUID(T entity, String uuid, String childNodeFilter, int maxDepth) {
        Node node;
        try {
            node = JcrMapper.getSession().getNodeByIdentifier(uuid);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", (Throwable)e);
        }
        return JcrMapper.update(node, entity, childNodeFilter, maxDepth);
    }

    public static String updateNode(Node node, Object entity) throws JcrMappingException {
        return jcrom.updateNode(node, entity);
    }

    public static String updateNode(Node node, Object entity, String arg2, int arg3) throws JcrMappingException {
        return jcrom.updateNode(node, entity, arg2, arg3);
    }

    protected static <T> JcrQueryResult<T> executeQuery(Class<T> clazz, String queryString, Object ... params) throws RepositoryException {
        QueryManager queryManager = JCR.getQueryManager();
        Query query = queryManager.createQuery(params == null ? queryString : JcrUtils.queryFormat(queryString, params), "JCR-SQL2");
        QueryResult queryResult = query.execute();
        NodeIterator nodeItor = queryResult.getNodes();
        return JcrMapper.toJcrQuery(clazz, nodeItor);
    }

    protected static JcrMetadata.MD getMetadata(Class<?> clazz) {
        return JcrMetadata.getInstance().lookup(clazz);
    }

    protected static Session getSession() {
        return JCR.getSession();
    }

    protected static boolean hasMixinType(Node node, String mixinType) throws RepositoryException {
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!nodeType.getName().equals(mixinType)) continue;
            return true;
        }
        return false;
    }

    protected static String relativePath(String absolutePath) {
        if (absolutePath.startsWith("/")) {
            return absolutePath.substring(1);
        }
        return absolutePath;
    }

    protected static <T> JcrQueryResult<T> toJcrQuery(Class<T> clazz, NodeIterator nodeIterator) {
        return new JcrQueryResult<T>(clazz, nodeIterator);
    }

    protected static <T> T update(Node node, T entity, String childNodeFilter, int maxDepth) {
        try {
            Session session = JcrMapper.getSession();
            VersionManager versionManager = null;
            JcrMetadata.MD md = JcrMapper.getMetadata(entity.getClass());
            if (md.isVersionable) {
                versionManager = session.getWorkspace().getVersionManager();
                JcrMapper.checkoutRecursively(versionManager, node);
            }
            jcrom.updateNode(node, entity, childNodeFilter, maxDepth);
            session.save();
            if (md.isVersionable) {
                JcrMapper.checkinRecursively(versionManager, node);
            }
            return entity;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", (Throwable)e);
        }
    }

    private static void checkinRecursively(VersionManager versionManager, Node node) {
        try {
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                JcrMapper.checkinRecursively(versionManager, it.nextNode());
            }
            if (node.isCheckedOut() && node.isNodeType("mix:versionable")) {
                versionManager.checkin(node.getPath());
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not perform check-in", (Throwable)e);
        }
    }

    private static void checkoutRecursively(VersionManager versionManager, Node node) {
        try {
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                JcrMapper.checkoutRecursively(versionManager, it.nextNode());
            }
            if (!node.isCheckedOut() && node.isNodeType("mix:versionable")) {
                versionManager.checkout(node.getPath());
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not perform check-in", (Throwable)e);
        }
    }

    private JcrMapper() {
    }

    static {
        beanUtils = new NullAwareBeanUtilsBean();
    }
}

