/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream.ocm;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import play.exceptions.UnexpectedException;
import play.modules.cream.helpers.JcrUtils;
import play.modules.cream.ocm.JcrMapper;
import play.modules.cream.ocm.JcrQueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrQuery {
    private final String formattedQuery;
    private final Class<?> clazz;

    public static JcrQueryBuilder builder(Class<?> clazz, String query) {
        return new JcrQueryBuilder(clazz, query);
    }

    public static JcrQueryBuilder builder(String query) {
        return new JcrQueryBuilder(null, query);
    }

    private JcrQuery(JcrQueryBuilder builder) {
        this.formattedQuery = this.format(builder.query, builder.params);
        this.clazz = builder.clazz;
    }

    public <T> JcrQueryResult<T> excute() {
        try {
            return JcrMapper.executeQuery(this.clazz, this.formattedQuery, new Object[0]);
        }
        catch (RepositoryException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public String format(String query, Map<String, Object> params) {
        StringBuilder builder = new StringBuilder(query);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            int start;
            String pattern = String.format("${%s}", entry.getKey());
            String value = entry.getValue().toString();
            while ((start = builder.indexOf(pattern)) != -1) {
                builder.replace(start, start + pattern.length(), value);
            }
        }
        return builder.toString();
    }

    public String getQuery() {
        return this.formattedQuery;
    }

    public String toString() {
        return "JcrQuery [query=" + this.formattedQuery + ", clazz=" + this.clazz + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JcrQueryBuilder {
        private final String query;
        private final Class<?> clazz;
        private Map<String, Object> params = new HashMap<String, Object>();

        public JcrQueryBuilder(Class<?> clazz, String query) {
            this.query = query;
            this.clazz = clazz;
        }

        public JcrQuery build() {
            return new JcrQuery(this);
        }

        public JcrQueryBuilder setBoolean(String name, boolean value) {
            this.put(name, value);
            return this;
        }

        public JcrQueryBuilder setDouble(String name, double value) {
            this.put(name, value);
            return this;
        }

        public JcrQueryBuilder setFloat(String name, float value) {
            this.put(name, Float.valueOf(value));
            return this;
        }

        public JcrQueryBuilder setInt(String name, int value) {
            this.put(name, value);
            return this;
        }

        public JcrQueryBuilder setLong(String name, long value) {
            this.put(name, value);
            return this;
        }

        public JcrQueryBuilder setNumber(String name, Number value) {
            this.put(name, value);
            return this;
        }

        public JcrQueryBuilder setObject(String name, Object value) {
            this.put(name, value);
            return this;
        }

        public JcrQueryBuilder setString(String name, String value) {
            if (value != null) {
                this.params.put(name, '\'' + JcrUtils.escapeSingleQuote(value) + '\'');
            }
            return this;
        }

        private void put(String name, Object value) {
            if (value != null) {
                this.params.put(name, value);
            }
        }
    }
}

