/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream.ocm;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NodeIterator;
import play.modules.cream.ocm.JcrMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrQueryResult<T> {
    private final NodeIterator iterator;
    private final Class<T> entityClass;

    public JcrQueryResult(Class<T> clazz, NodeIterator nodeIterator) {
        this.iterator = nodeIterator;
        this.entityClass = clazz;
    }

    public long count() {
        return this.iterator.getSize();
    }

    public List<T> fetch() {
        return JcrMapper.toList(this.entityClass, this.iterator, "*", -1);
    }

    public List<T> fetch(int max) {
        ArrayList<T> list = new ArrayList<T>();
        for (int c = 0; this.iterator.hasNext() && c < max; ++c) {
            list.add(JcrMapper.fromNode(this.entityClass, this.iterator.nextNode()));
        }
        return list;
    }

    public List<T> fetch(int page, int length) {
        ArrayList<T> list = new ArrayList<T>();
        if (!this.isEmpty()) {
            int offset = (Math.max(page, 1) - 1) * length;
            if (offset > 0) {
                this.iterator.skip((long)offset);
            }
            for (int c = 0; this.iterator.hasNext() && c < length; ++c) {
                list.add(JcrMapper.fromNode(this.entityClass, this.iterator.nextNode()));
            }
        }
        return list;
    }

    public T first() {
        return this.iterator.hasNext() ? (T)JcrMapper.fromNode(this.entityClass, this.iterator.nextNode()) : null;
    }

    public JcrQueryResult from(int position) {
        this.iterator.skip((long)position);
        return this;
    }

    public boolean isEmpty() {
        return this.iterator.getSize() < 1L;
    }
}

