/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cream.ocm;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.jcrom.JcrMappingException;
import play.modules.cream.JCR;
import play.modules.cream.ocm.JcrMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrVersionMapper {
    public static <T> T getVersion(Class<T> clazz, String path, String versionName) {
        return JcrVersionMapper.getVersion(clazz, path, versionName, "*", -1);
    }

    public static <T> T getVersion(Class<T> clazz, String path, String versionName, String childNodeFilter, int maxDepth) {
        try {
            return JcrVersionMapper.getVersion(clazz, JcrVersionMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(path)), versionName, childNodeFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", (Throwable)e);
        }
    }

    public static <T> T getVersionByUUID(Class<T> clazz, String uuid, String versionName) {
        return JcrVersionMapper.getVersionByUUID(clazz, uuid, versionName, "*", -1);
    }

    public static <T> T getVersionByUUID(Class<T> clazz, String uuid, String versionName, String childNodeFilter, int maxDepth) {
        try {
            return JcrVersionMapper.getVersion(clazz, JcrVersionMapper.getSession().getNodeByIdentifier(uuid), versionName, childNodeFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", (Throwable)e);
        }
    }

    public static <T> List<T> getVersionList(Class<T> clazz, String path) {
        try {
            return JcrVersionMapper.getVersionList(clazz, JcrVersionMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(path)), "*", -1);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", (Throwable)e);
        }
    }

    public static <T> List<T> getVersionList(Class<T> clazz, String path, String childNameFilter, int maxDepth) {
        try {
            return JcrVersionMapper.getVersionList(clazz, JcrVersionMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(path)), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", (Throwable)e);
        }
    }

    public static <T> List<T> getVersionList(Class<T> clazz, String path, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            return JcrVersionMapper.getVersionList(clazz, JcrVersionMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(path)), childNameFilter, maxDepth, startIndex, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", (Throwable)e);
        }
    }

    public static <T> List<T> getVersionListByUUID(Class<T> clazz, String uuid) {
        try {
            return JcrVersionMapper.getVersionList(clazz, JcrVersionMapper.getSession().getNodeByIdentifier(uuid), "*", -1);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", (Throwable)e);
        }
    }

    public static <T> List<T> getVersionListByUUID(Class<T> clazz, String uuid, String childNameFilter, int maxDepth) {
        try {
            return JcrVersionMapper.getVersionList(clazz, JcrVersionMapper.getSession().getNodeByIdentifier(uuid), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", (Throwable)e);
        }
    }

    public static <T> List<T> getVersionListByUUID(Class<T> clazz, String uuid, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            return JcrVersionMapper.getVersionList(clazz, JcrVersionMapper.getSession().getNodeByIdentifier(uuid), childNameFilter, maxDepth, startIndex, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", (Throwable)e);
        }
    }

    public static long getVersionSize(String path) {
        try {
            return JcrVersionMapper.getVersionSize(JcrVersionMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(path)));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", (Throwable)e);
        }
    }

    public static long getVersionSizeByUUID(String uuid) {
        try {
            return JcrVersionMapper.getVersionSize(JcrVersionMapper.getSession().getNodeByIdentifier(uuid));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", (Throwable)e);
        }
    }

    public static void removeVersion(String path, String versionName) {
        try {
            JcrVersionMapper.removeVersion(JcrVersionMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(path)), versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", (Throwable)e);
        }
    }

    public static void removeVersionByUUID(String uuid, String versionName) {
        try {
            JcrVersionMapper.removeVersion(JcrVersionMapper.getSession().getNodeByIdentifier(uuid), versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", (Throwable)e);
        }
    }

    public static void restoreVersion(String path, String versionName) {
        JcrVersionMapper.restoreVersion(path, versionName, true);
    }

    public static void restoreVersion(String path, String versionName, boolean removeExisting) {
        try {
            JcrVersionMapper.restoreVersion(JcrVersionMapper.getSession().getRootNode().getNode(JcrMapper.relativePath(path)), versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", (Throwable)e);
        }
    }

    public static void restoreVersionByUUID(String uuid, String versionName) {
        JcrVersionMapper.restoreVersionByUUID(uuid, versionName, true);
    }

    public static void restoreVersionByUUID(String uuid, String versionName, boolean removeExisting) {
        try {
            JcrVersionMapper.restoreVersion(JcrVersionMapper.getSession().getNodeByIdentifier(uuid), versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", (Throwable)e);
        }
    }

    public static void setBaseVersionInfo(Object object, String name, Calendar created) throws JcrMappingException {
        JcrMapper.setBaseVersionInfo(object, name, created);
    }

    protected static Session getSession() {
        return JCR.getSession();
    }

    protected static <T> T getVersion(Class<T> clazz, Node node, String versionName, String childNodeFilter, int maxDepth) {
        try {
            VersionManager versionManager = JCR.getVersionManager();
            VersionHistory versionHistory = versionManager.getVersionHistory(node.getPath());
            Version version = versionHistory.getVersion(versionName);
            return JcrMapper.fromNode(clazz, version.getNodes().nextNode(), childNodeFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", (Throwable)e);
        }
    }

    protected static <T> List<T> getVersionList(Class<T> clazz, Node node, String childNameFilter, int maxDepth) {
        try {
            ArrayList<T> versionList = new ArrayList<T>();
            VersionManager versionManager = JCR.getVersionManager();
            VersionHistory versionHistory = versionManager.getVersionHistory(node.getPath());
            VersionIterator versionIterator = versionHistory.getAllVersions();
            versionIterator.skip(1L);
            while (versionIterator.hasNext()) {
                Version version = versionIterator.nextVersion();
                NodeIterator nodeIterator = version.getNodes();
                while (nodeIterator.hasNext()) {
                    T entityVersion = JcrMapper.fromNode(clazz, nodeIterator.nextNode(), childNameFilter, maxDepth);
                    Version baseVersion = versionManager.getBaseVersion(node.getPath());
                    JcrMapper.setBaseVersionInfo(entityVersion, baseVersion.getName(), baseVersion.getCreated());
                    versionList.add(entityVersion);
                }
            }
            return versionList;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", (Throwable)e);
        }
    }

    protected static <T> List<T> getVersionList(Class<T> clazz, Node node, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            ArrayList<T> versionList = new ArrayList<T>();
            VersionManager versionManager = JCR.getVersionManager();
            VersionHistory versionHistory = versionManager.getVersionHistory(node.getPath());
            VersionIterator versionIterator = versionHistory.getAllVersions();
            versionIterator.skip(1L + startIndex);
            for (long counter = 0L; versionIterator.hasNext() && counter != resultSize; ++counter) {
                Version version = versionIterator.nextVersion();
                NodeIterator nodeIterator = version.getNodes();
                while (nodeIterator.hasNext()) {
                    versionList.add(JcrMapper.fromNode(clazz, nodeIterator.nextNode(), childNameFilter, maxDepth));
                }
            }
            return versionList;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", (Throwable)e);
        }
    }

    protected static long getVersionSize(Node node) {
        try {
            VersionManager versionManager = JCR.getVersionManager();
            VersionHistory versionHistory = versionManager.getVersionHistory(node.getPath());
            return versionHistory.getAllVersions().getSize() - 1L;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", (Throwable)e);
        }
    }

    protected static void removeVersion(Node node, String versionName) {
        try {
            VersionManager versionManager = JCR.getVersionManager();
            versionManager.getVersionHistory(node.getPath()).removeVersion(versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", (Throwable)e);
        }
    }

    protected static void restoreVersion(Node node, String versionName, boolean removeExisting) {
        try {
            VersionManager versionManager = JCR.getVersionManager();
            versionManager.checkout(node.getPath());
            versionManager.restore(node.getPath(), versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", (Throwable)e);
        }
    }

    private JcrVersionMapper() {
    }
}

