/*
 * Decompiled with CFR 0.152.
 */
package play.modules.crudsiena;

import java.util.List;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.OValException;
import play.exceptions.UnexpectedException;
import play.modules.crudsiena.CrudUnique;
import play.modules.crudsiena.SienaUtils;
import siena.Model;
import siena.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrudUniqueCheck
extends AbstractAnnotationCheck<CrudUnique> {
    public static final String mes = "validation.unique";
    private CrudUnique unique;

    public void configure(CrudUnique unique) {
        this.setMessage(unique.message());
        this.unique = unique;
    }

    public boolean isSatisfied(Object validatedObject, Object value, OValContext context, Validator validator) throws OValException {
        if (value == null) {
            return true;
        }
        if (validatedObject instanceof Model) {
            Model ss = (Model)validatedObject;
            try {
                if (context != null && context instanceof FieldContext) {
                    FieldContext ctx = (FieldContext)context;
                    String fieldName = ctx.getField().getName();
                    Query all = Model.all(validatedObject.getClass());
                    List fetched = all.filter(fieldName, value).fetch();
                    if (fetched.size() == 0) {
                        return true;
                    }
                    Object sskey = SienaUtils.findKey(ss);
                    if (sskey == null) {
                        return false;
                    }
                    for (Object o : fetched) {
                        Model s = (Model)o;
                        Object skey = SienaUtils.findKey(s);
                        if (skey == null || !skey.equals(sskey)) continue;
                        return true;
                    }
                    return false;
                }
            }
            catch (Exception e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
        return false;
    }
}

