/*
 * Decompiled with CFR 0.152.
 */
package play.modules.crudsiena;

import java.util.HashMap;
import javassist.CtClass;
import javassist.CtField;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import play.Logger;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.data.binding.As;
import play.data.validation.MaxSize;
import play.data.validation.Required;
import siena.DateTime;
import siena.Id;
import siena.Json;
import siena.Max;
import siena.Model;
import siena.NotNull;

public class CrudSienaEnhancer
extends Enhancer {
    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        CtClass ctClass = this.makeClass(applicationClass);
        if (ctClass == null) {
            return;
        }
        String pack = ctClass.getPackageName();
        if (pack == null || pack.startsWith("java.")) {
            return;
        }
        if (ctClass.subtypeOf(this.classPool.get(Json.class.getName()))) {
            return;
        }
        boolean isModel = false;
        if (ctClass.subclassOf(this.classPool.get(Model.class.getName()))) {
            isModel = true;
        } else {
            CtField[] fields = ctClass.getDeclaredFields();
            block0: for (CtClass cl = ctClass; cl != null; cl = cl.getSuperclass()) {
                for (CtField field : fields) {
                    Object[] annotations;
                    for (Object ann : annotations = field.getAnnotations()) {
                        if (ann.getClass() != Id.class) continue;
                        isModel = true;
                        break;
                    }
                    if (isModel) continue block0;
                }
            }
        }
        if (!isModel) {
            return;
        }
        Logger.debug((String)("CrudSiena: Enhancing class:" + applicationClass.name), (Object[])new Object[0]);
        for (CtField cf : ctClass.getDeclaredFields()) {
            AnnotationsAttribute attr;
            if (this.hasAnnotation(cf, Max.class.getName())) {
                attr = CrudSienaEnhancer.getAnnotations((CtField)cf);
                Annotation orig = attr.getAnnotation(Max.class.getName());
                int val = ((IntegerMemberValue)orig.getMemberValue("value")).getValue();
                HashMap<String, IntegerMemberValue> map = new HashMap<String, IntegerMemberValue>();
                map.put("value", new IntegerMemberValue(attr.getConstPool(), val));
                CrudSienaEnhancer.createAnnotation((AnnotationsAttribute)attr, MaxSize.class, map);
            }
            if (this.hasAnnotation(cf, NotNull.class.getName())) {
                attr = CrudSienaEnhancer.getAnnotations((CtField)cf);
                CrudSienaEnhancer.createAnnotation((AnnotationsAttribute)attr, Required.class);
            }
            if (!this.hasAnnotation(cf, DateTime.class.getName())) continue;
            attr = CrudSienaEnhancer.getAnnotations((CtField)cf);
            HashMap<String, ArrayMemberValue> map = new HashMap<String, ArrayMemberValue>();
            ConstPool cp = attr.getConstPool();
            MemberValue[] langArray = new MemberValue[]{new StringMemberValue("*", cp)};
            ArrayMemberValue langMember = new ArrayMemberValue(cp);
            langMember.setValue(langArray);
            map.put("lang", langMember);
            MemberValue[] valArray = new MemberValue[]{new StringMemberValue("yyyy-MM-dd HH:mm:ss", cp)};
            ArrayMemberValue valMember = new ArrayMemberValue(cp);
            valMember.setValue(valArray);
            map.put("value", valMember);
            CrudSienaEnhancer.createAnnotation((AnnotationsAttribute)attr, As.class, map);
        }
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.defrost();
    }
}

