/*
 * Decompiled with CFR 0.152.
 */
package play.modules.crudsiena;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.Logger;
import play.data.binding.BeanWrapper;
import play.data.binding.Binder;
import play.data.validation.Validation;
import play.exceptions.UnexpectedException;
import play.modules.siena.SienaPlugin;
import siena.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrudSienaUtils {
    public static <T> T addListElement(T o, String fieldName) {
        try {
            Class<?> clazz = o.getClass();
            BeanWrapper bw = new BeanWrapper(o.getClass());
            Field field = clazz.getField(fieldName);
            if (List.class.isAssignableFrom(field.getType())) {
                ArrayList<Object> l = (ArrayList<Object>)field.get(o);
                if (l == null) {
                    l = new ArrayList<Object>();
                }
                Class embedClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                BeanWrapper embedbw = new BeanWrapper(embedClass);
                Object embedObj = Util.createObjectInstance((Class)embedClass);
                l.add(embedObj);
                Logger.debug((String)embedObj.toString(), (Object[])new Object[0]);
                bw.set(field.getName(), o, l);
            } else {
                Validation.addError((String)(clazz.getName() + "." + field.getName()), (String)"validation.fieldList.badType", (String[])new String[]{fieldName});
            }
            SienaPlugin.pm().update(o);
            return o;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static <T> T deleteListElement(T o, String fieldName, int idx) {
        try {
            Class<?> clazz = o.getClass();
            BeanWrapper bw = new BeanWrapper(o.getClass());
            Field field = clazz.getField(fieldName);
            if (List.class.isAssignableFrom(field.getType())) {
                List l = (List)field.get(o);
                if (l == null) {
                    Validation.addError((String)(clazz.getName() + "." + field.getName()), (String)"validation.fieldList.empty", (String[])new String[]{fieldName});
                } else if (idx < 0 || idx > l.size() - 1) {
                    Validation.addError((String)(clazz.getName() + "." + field.getName()), (String)"validation.fieldList.indexOutOfBound", (String[])new String[]{fieldName});
                } else {
                    l.remove(idx);
                }
            } else {
                Validation.addError((String)(clazz.getName() + "." + field.getName()), (String)"validation.fieldList.badType", (String[])new String[]{fieldName});
            }
            SienaPlugin.pm().update(o);
            return o;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static <T> T addMapElement(T o, String fieldName, String key) {
        try {
            Class<?> clazz = o.getClass();
            BeanWrapper bw = new BeanWrapper(o.getClass());
            Field field = clazz.getField(fieldName);
            if (Map.class.isAssignableFrom(field.getType())) {
                HashMap l = (HashMap)field.get(o);
                Class embedKeyClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                Class embedClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
                if (l == null) {
                    l = new HashMap();
                }
                Object embedObj = embedClass.newInstance();
                Object embedKey = Binder.directBind((String)key, (Class)embedKeyClass);
                if (l.get(embedKey) != null) {
                    Logger.debug((String)"element with key %s already existing", (Object[])new Object[]{embedKey});
                    Validation.addError((String)fieldName, (String)"validation.fieldMap.alreadyExists", (String[])new String[]{embedKey.toString()});
                } else {
                    l.put(embedKey, embedObj);
                    Logger.debug((String)"map added {%s:%s}", (Object[])new Object[]{embedKey, embedObj});
                }
                bw.set(field.getName(), o, l);
            } else {
                Validation.addError((String)(clazz.getName() + "." + field.getName()), (String)"validation.fieldMap.badType", (String[])new String[]{fieldName});
            }
            SienaPlugin.pm().update(o);
            return o;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static <T> T deleteMapElement(T o, String fieldName, String key) {
        try {
            Class<?> clazz = o.getClass();
            BeanWrapper bw = new BeanWrapper(o.getClass());
            Field field = clazz.getField(fieldName);
            if (Map.class.isAssignableFrom(field.getType())) {
                Map l = (Map)field.get(o);
                if (l == null) {
                    Validation.addError((String)(clazz.getName() + "." + field.getName()), (String)"validation.fieldMap.empty", (String[])new String[]{fieldName});
                } else {
                    Class embedKeyClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    BeanWrapper keybw = new BeanWrapper(embedKeyClass);
                    try {
                        Object embedKey = Binder.directBind((String)key, (Class)embedKeyClass);
                        l.remove(embedKey);
                    }
                    catch (Exception ex) {
                        Validation.addError((String)(clazz.getName() + "." + field.getName() + "." + key), (String)"validation.fieldMap.keyBadFormat", (String[])new String[]{fieldName, key});
                    }
                }
            } else {
                Validation.addError((String)(clazz.getName() + "." + field.getName()), (String)"validation.fieldMap.badType", (String[])new String[]{fieldName});
            }
            SienaPlugin.pm().update(o);
            return o;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

