/*
 * Decompiled with CFR 0.152.
 */
package play.modules.db;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Entity;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import play.Play;

public class Exporter {
    public static void main(String[] args) throws Exception {
        String url;
        String password;
        String user;
        String driver;
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        List entities = Play.classloader.getAnnotatedClasses(Entity.class);
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        for (Class _class : entities) {
            cfg.addAnnotatedClass(_class);
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
        String dialect = Play.configuration.getProperty("jpa.dialect");
        if (dialect != null) {
            cfg.setProperty("hibernate.dialect", dialect);
        }
        if ((driver = Play.configuration.getProperty("db.driver")) != null) {
            cfg.setProperty("hibernate.connection.driver_class", driver);
        }
        if ((user = Play.configuration.getProperty("db.user")) != null) {
            cfg.setProperty("hibernate.connection.username", user);
        }
        if ((password = Play.configuration.getProperty("db.pass")) != null) {
            cfg.setProperty("hibernate.connection.password", password);
        }
        if ((url = Play.configuration.getProperty("db.url")) != null) {
            cfg.setProperty("hibernate.connection.url", url);
        }
        boolean script = true;
        boolean drop = false;
        boolean create = false;
        boolean halt = false;
        boolean export = false;
        String outFile = null;
        String importFile = "/import.sql";
        String propFile = null;
        boolean format = true;
        String delim = ";";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--")) continue;
            if (args[i].equals("--quiet")) {
                script = false;
                continue;
            }
            if (args[i].equals("--drop")) {
                drop = true;
                continue;
            }
            if (args[i].equals("--create")) {
                create = true;
                continue;
            }
            if (args[i].equals("--haltonerror")) {
                halt = true;
                continue;
            }
            if (args[i].equals("--export")) {
                export = true;
                continue;
            }
            if (args[i].startsWith("--output=")) {
                outFile = args[i].substring(9);
                continue;
            }
            if (args[i].startsWith("--import=")) {
                importFile = args[i].substring(9);
                continue;
            }
            if (args[i].startsWith("--properties=")) {
                propFile = args[i].substring(13);
                continue;
            }
            if (args[i].equals("--noformat")) {
                format = false;
                continue;
            }
            if (args[i].startsWith("--delimiter=")) {
                delim = args[i].substring(12);
                continue;
            }
            if (args[i].startsWith("--config=")) {
                cfg.configure(args[i].substring(9));
                continue;
            }
            if (!args[i].startsWith("--naming=")) continue;
            cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName((String)args[i].substring(9)).newInstance());
        }
        if (propFile != null) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)cfg.getProperties());
            props.load(new FileInputStream(propFile));
            cfg.setProperties(props);
        }
        SchemaExport se = new SchemaExport((Configuration)cfg).setHaltOnError(halt).setOutputFile(outFile).setImportFile(importFile).setDelimiter(delim);
        if (format) {
            se.setFormat(true);
        }
        se.execute(script, export, drop, create);
    }
}

