/*
 * Decompiled with CFR 0.152.
 */
package play.modules.db;

import java.io.File;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.tool.hbm2x.POJOExporter;
import play.Play;

public class Importer {
    public static void main(String[] args) throws Exception {
        String url;
        String password;
        String user;
        String driver;
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
        JDBCMetaDataConfiguration cfg = new JDBCMetaDataConfiguration();
        cfg.setPreferBasicCompositeIds(true);
        DefaultReverseEngineeringStrategy reverseEngineeringStrategy = new DefaultReverseEngineeringStrategy();
        ReverseEngineeringSettings settings = new ReverseEngineeringSettings();
        settings.setDefaultPackageName("models");
        reverseEngineeringStrategy.setSettings(settings);
        cfg.setReverseEngineeringStrategy((ReverseEngineeringStrategy)reverseEngineeringStrategy);
        cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        String dialect = Play.configuration.getProperty("jpa.dialect");
        if (dialect != null) {
            cfg.setProperty("hibernate.dialect", dialect);
        }
        if ((driver = Play.configuration.getProperty("db.driver")) != null) {
            cfg.setProperty("hibernate.connection.driver_class", driver);
        }
        if ((user = Play.configuration.getProperty("db.user")) != null) {
            cfg.setProperty("hibernate.connection.username", user);
        }
        if ((password = Play.configuration.getProperty("db.pass")) != null) {
            cfg.setProperty("hibernate.connection.password", password);
        }
        if ((url = Play.configuration.getProperty("db.url")) != null) {
            cfg.setProperty("hibernate.connection.url", url);
        }
        cfg.readFromJDBC();
        POJOExporter se = new POJOExporter();
        se.setProperties(cfg.getProperties());
        se.setConfiguration((Configuration)cfg);
        se.getProperties().setProperty("ejb3", "true");
        se.getProperties().setProperty("jdk5", "true");
        se.setOutputDirectory(new File(Play.applicationPath, "app/"));
        se.start();
    }
}

