/*
 * Decompiled with CFR 0.152.
 */
package play.modules.db;

import java.io.File;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.tool.hbm2x.POJOExporter;
import play.Logger;
import play.Play;
import play.modules.db.CRUDControllerExporter;

public class Importer {
    public static void main(String[] args) throws Exception {
        Object se;
        String defaultSchema;
        String url;
        String password;
        String user;
        String driver;
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
        JDBCMetaDataConfiguration cfg = new JDBCMetaDataConfiguration();
        cfg.setPreferBasicCompositeIds(true);
        DefaultReverseEngineeringStrategy reverseEngineeringStrategy = new DefaultReverseEngineeringStrategy();
        ReverseEngineeringSettings settings = new ReverseEngineeringSettings();
        settings.setDefaultPackageName("models");
        reverseEngineeringStrategy.setSettings(settings);
        String hibernateRevengXmlFilename = null;
        boolean generateCRUDControllers = false;
        boolean generatePOJOs = true;
        Logger.info((String)("Iterating on arguments, args.length = " + args.length), (Object[])new Object[0]);
        for (int i = 0; i < args.length; ++i) {
            Logger.info((String)("args[" + i + "] = " + args[i]), (Object[])new Object[0]);
            if (!args[i].startsWith("--")) continue;
            Logger.info((String)("... args[" + i + "] starts with '--'"), (Object[])new Object[0]);
            if (args[i].equals("--reveng")) {
                Logger.info((String)("... args[" + i + "] starts with '--reveng'"), (Object[])new Object[0]);
                if (i + 1 >= args.length) continue;
                hibernateRevengXmlFilename = args[i + 1];
                Logger.info((String)("... hibernateRevengXmlFilename = '" + hibernateRevengXmlFilename + "'"), (Object[])new Object[0]);
                continue;
            }
            if (args[i].startsWith("--reveng=")) {
                Logger.info((String)("... args[" + i + "] starts with '--reveng='"), (Object[])new Object[0]);
                hibernateRevengXmlFilename = args[i].substring(9);
                Logger.info((String)("... hibernateRevengXmlFilename = '" + hibernateRevengXmlFilename + "'"), (Object[])new Object[0]);
                continue;
            }
            if (args[i].startsWith("--reveng:")) {
                Logger.info((String)("... args[" + i + "] starts with '--reveng:'"), (Object[])new Object[0]);
                hibernateRevengXmlFilename = args[i].substring(9);
                Logger.info((String)("... hibernateRevengXmlFilename = '" + hibernateRevengXmlFilename + "'"), (Object[])new Object[0]);
                continue;
            }
            if (args[i].startsWith("--crud")) {
                Logger.info((String)("... args[" + i + "] starts with '--crud'"), (Object[])new Object[0]);
                generateCRUDControllers = true;
                Logger.info((String)("... generateCRUDControllers = '" + generateCRUDControllers + "'"), (Object[])new Object[0]);
                continue;
            }
            if (!args[i].startsWith("--no-pojo")) continue;
            Logger.info((String)("... args[" + i + "] starts with '--no-pojo'"), (Object[])new Object[0]);
            generatePOJOs = false;
            Logger.info((String)("... generatePOJOs = '" + generatePOJOs + "'"), (Object[])new Object[0]);
        }
        if (hibernateRevengXmlFilename != null) {
            if (!(hibernateRevengXmlFilename.startsWith(Play.applicationPath.toString()) || hibernateRevengXmlFilename.startsWith("/") || hibernateRevengXmlFilename.startsWith("\\"))) {
                hibernateRevengXmlFilename = Play.applicationPath + "/" + hibernateRevengXmlFilename;
                Logger.info((String)("hibernateRevengXmlFilename which used a relative path, becomes = '" + hibernateRevengXmlFilename + "'"), (Object[])new Object[0]);
            }
            Logger.info((String)("Checking for '" + hibernateRevengXmlFilename + "'"), (Object[])new Object[0]);
            File revengXmlConf = new File(hibernateRevengXmlFilename);
            if (revengXmlConf.exists()) {
                Logger.info((String)("File '" + hibernateRevengXmlFilename + "' found, Importer will use it."), (Object[])new Object[0]);
                OverrideRepository or = new OverrideRepository();
                or.addFile(revengXmlConf);
                reverseEngineeringStrategy = or.getReverseEngineeringStrategy((ReverseEngineeringStrategy)reverseEngineeringStrategy);
            } else {
                Logger.error((String)("File '" + hibernateRevengXmlFilename + "' not found, Importer will continue without it."), (Object[])new Object[0]);
            }
        }
        cfg.setReverseEngineeringStrategy((ReverseEngineeringStrategy)reverseEngineeringStrategy);
        cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        String dialect = Play.configuration.getProperty("jpa.dialect");
        if (dialect != null) {
            cfg.setProperty("hibernate.dialect", dialect);
            Logger.info((String)("Importer will use jpa.dialect = " + dialect), (Object[])new Object[0]);
        }
        if ((driver = Play.configuration.getProperty("db.driver")) != null) {
            cfg.setProperty("hibernate.connection.driver_class", driver);
            Logger.info((String)("Importer will use db.driver = " + driver), (Object[])new Object[0]);
        }
        if ((user = Play.configuration.getProperty("db.user")) != null) {
            cfg.setProperty("hibernate.connection.username", user);
            Logger.info((String)("Importer will use db.user = " + user), (Object[])new Object[0]);
        }
        if ((password = Play.configuration.getProperty("db.pass")) != null) {
            cfg.setProperty("hibernate.connection.password", password);
            Logger.info((String)"Importer will use db.password", (Object[])new Object[0]);
        }
        if ((url = Play.configuration.getProperty("db.url")) != null) {
            cfg.setProperty("hibernate.connection.url", url);
            Logger.info((String)("Importer will use db.url = " + url), (Object[])new Object[0]);
        }
        if ((defaultSchema = Play.configuration.getProperty("db.default.schema")) != null) {
            cfg.setProperty("hibernate.default_schema", defaultSchema);
            Logger.info((String)("Importer will use db.default.schema = " + defaultSchema), (Object[])new Object[0]);
        }
        cfg.readFromJDBC();
        Logger.info((String)"DB metadata reading done.", (Object[])new Object[0]);
        if (generatePOJOs) {
            Logger.info((String)"POJO generation enabled.", (Object[])new Object[0]);
            se = new POJOExporter();
            se.setProperties(cfg.getProperties());
            se.setConfiguration((Configuration)cfg);
            se.getProperties().setProperty("ejb3", "true");
            se.getProperties().setProperty("jdk5", "true");
            se.setOutputDirectory(new File(Play.applicationPath, "app/"));
            Logger.info((String)"Starting POJO Exporter ...", (Object[])new Object[0]);
            se.start();
            Logger.info((String)"POJO Exporter done.", (Object[])new Object[0]);
        }
        if (generateCRUDControllers) {
            Logger.info((String)"CRUD generation enabled.", (Object[])new Object[0]);
            se = new CRUDControllerExporter();
            se.setProperties(cfg.getProperties());
            se.setConfiguration((Configuration)cfg);
            se.getProperties().setProperty("secure", "true");
            se.setOutputDirectory(new File(Play.applicationPath, "app/"));
            Logger.info((String)"Starting CRUD Controller Exporter ...", (Object[])new Object[0]);
            se.start();
            Logger.info((String)"CRUD Controller Exporter done.", (Object[])new Object[0]);
        }
    }
}

