/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.reveng.dialect.AbstractMetaDataDialect;
import org.hibernate.cfg.reveng.dialect.ResultSetIterator;
import org.hibernate.mapping.Table;

public class JDBCMetaDataDialect
extends AbstractMetaDataDialect {
    public Iterator getTables(String xcatalog, String xschema, String xtable) {
        try {
            final String catalog = this.caseForSearch(xcatalog);
            final String schema = this.caseForSearch(xschema);
            String table = this.caseForSearch(xtable);
            this.log.debug((Object)("getTables(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getMetaData().getTables(catalog, schema, table, new String[]{"TABLE", "VIEW"});
            return new ResultSetIterator(tableRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet tableRs) throws SQLException {
                    this.element.clear();
                    JDBCMetaDataDialect.this.putTablePart(this.element, tableRs);
                    this.element.put("TABLE_TYPE", tableRs.getString("TABLE_TYPE"));
                    this.element.put("REMARKS", tableRs.getString("REMARKS"));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    String databaseStructure = JDBCMetaDataDialect.this.getDatabaseStructure(catalog, schema);
                    throw this.getSQLExceptionConverter().convert(e, "Could not get list of tables from database. Probably a JDBC driver problem. " + databaseStructure, null);
                }
            };
        }
        catch (SQLException e) {
            String databaseStructure = this.getDatabaseStructure(xcatalog, xschema);
            throw this.getSQLExceptionConverter().convert(e, "Could not get list of tables from database. Probably a JDBC driver problem. " + databaseStructure, null);
        }
    }

    private void dumpHeader(ResultSet columnRs) throws SQLException {
        ResultSetMetaData md2 = columnRs.getMetaData();
        int columnCount = md2.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            System.out.print(md2.getColumnName(i) + "|");
        }
        System.out.println();
    }

    private void dumpRow(ResultSet columnRs) throws SQLException {
        ResultSetMetaData md2 = columnRs.getMetaData();
        int columnCount = md2.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            System.out.print(columnRs.getObject(i) + "|");
        }
        System.out.println();
    }

    public Iterator getIndexInfo(String xcatalog, String xschema, String xtable) {
        try {
            final String catalog = this.caseForSearch(xcatalog);
            final String schema = this.caseForSearch(xschema);
            final String table = this.caseForSearch(xtable);
            this.log.debug((Object)("getIndexInfo(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getMetaData().getIndexInfo(catalog, schema, table, false, true);
            return new ResultSetIterator(tableRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    JDBCMetaDataDialect.this.putTablePart(this.element, rs);
                    this.element.put("INDEX_NAME", rs.getString("INDEX_NAME"));
                    this.element.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                    this.element.put("NON_UNIQUE", rs.getBoolean("NON_UNIQUE"));
                    this.element.put("TYPE", new Short(rs.getShort("TYPE")));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Exception while getting index info for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Exception while getting index info for " + Table.qualify((String)xcatalog, (String)xschema, (String)xtable), null);
        }
    }

    private void putTablePart(Map element, ResultSet tableRs) throws SQLException {
        element.put("TABLE_NAME", tableRs.getString("TABLE_NAME"));
        element.put("TABLE_SCHEM", tableRs.getString("TABLE_SCHEM"));
        element.put("TABLE_CAT", tableRs.getString("TABLE_CAT"));
    }

    public Iterator getColumns(String xcatalog, String xschema, String xtable, String xcolumn) {
        try {
            final String catalog = this.caseForSearch(xcatalog);
            final String schema = this.caseForSearch(xschema);
            final String table = this.caseForSearch(xtable);
            String column = this.caseForSearch(xcolumn);
            this.log.debug((Object)("getColumns(" + catalog + "." + schema + "." + table + "." + column + ")"));
            ResultSet tableRs = this.getMetaData().getColumns(catalog, schema, table, column);
            return new ResultSetIterator(tableRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    JDBCMetaDataDialect.this.putTablePart(this.element, rs);
                    this.element.put("DATA_TYPE", new Integer(rs.getInt("DATA_TYPE")));
                    this.element.put("TYPE_NAME", rs.getString("TYPE_NAME"));
                    this.element.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                    this.element.put("NULLABLE", new Integer(rs.getInt("NULLABLE")));
                    this.element.put("COLUMN_SIZE", new Integer(rs.getInt("COLUMN_SIZE")));
                    this.element.put("DECIMAL_DIGITS", new Integer(rs.getInt("DECIMAL_DIGITS")));
                    this.element.put("REMARKS", rs.getString("REMARKS"));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Error while reading column meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Error while reading column meta data for " + Table.qualify((String)xcatalog, (String)xschema, (String)xtable), null);
        }
    }

    public Iterator getPrimaryKeys(String xcatalog, String xschema, String xtable) {
        try {
            final String catalog = this.caseForSearch(xcatalog);
            final String schema = this.caseForSearch(xschema);
            final String table = this.caseForSearch(xtable);
            this.log.debug((Object)("getPrimaryKeys(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getMetaData().getPrimaryKeys(catalog, schema, table);
            return new ResultSetIterator(tableRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    JDBCMetaDataDialect.this.putTablePart(this.element, rs);
                    this.element.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                    this.element.put("KEY_SEQ", new Short(rs.getShort("KEY_SEQ")));
                    this.element.put("PK_NAME", rs.getString("PK_NAME"));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Error while reading primary key meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Error while reading primary key meta data for " + Table.qualify((String)xcatalog, (String)xschema, (String)xtable), null);
        }
    }

    public Iterator getExportedKeys(String xcatalog, String xschema, String xtable) {
        try {
            final String catalog = this.caseForSearch(xcatalog);
            final String schema = this.caseForSearch(xschema);
            final String table = this.caseForSearch(xtable);
            this.log.debug((Object)("getExportedKeys(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getMetaData().getExportedKeys(catalog, schema, table);
            return new ResultSetIterator(tableRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    this.element.put("PKTABLE_NAME", rs.getString("PKTABLE_NAME"));
                    this.element.put("PKTABLE_SCHEM", rs.getString("PKTABLE_SCHEM"));
                    this.element.put("PKTABLE_CAT", rs.getString("PKTABLE_CAT"));
                    this.element.put("FKTABLE_CAT", rs.getString("FKTABLE_CAT"));
                    this.element.put("FKTABLE_SCHEM", rs.getString("FKTABLE_SCHEM"));
                    this.element.put("FKTABLE_NAME", rs.getString("FKTABLE_NAME"));
                    this.element.put("FKCOLUMN_NAME", rs.getString("FKCOLUMN_NAME"));
                    this.element.put("PKCOLUMN_NAME", rs.getString("PKCOLUMN_NAME"));
                    this.element.put("FK_NAME", rs.getString("FK_NAME"));
                    this.element.put("KEY_SEQ", new Short(rs.getShort("KEY_SEQ")));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Error while reading exported keys meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Error while reading exported keys meta data for " + Table.qualify((String)xcatalog, (String)xschema, (String)xtable), null);
        }
    }
}

