/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Component;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ConfigurationNavigator;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.TemplateProducer;
import org.hibernate.tool.hbm2x.pojo.ComponentPOJOClass;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.util.StringHelper;

public class GenericExporter
extends AbstractExporter {
    private String templateName;
    private String filePattern;

    public GenericExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    public GenericExporter() {
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    protected void doStart() {
        if (this.filePattern == null) {
            throw new ExporterException("File pattern not set on " + this.getClass());
        }
        if (this.templateName == null) {
            throw new ExporterException("Template name not set on " + this.getClass());
        }
        if (this.filePattern.indexOf("{class-name}") >= 0) {
            this.exportClasses();
        } else {
            TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
            producer.produce(new HashMap(), this.getTemplateName(), new File(this.getOutputDirectory(), this.filePattern), this.templateName);
        }
    }

    private void exportClasses() {
        HashMap components = new HashMap();
        Iterator iterator = this.getCfg2JavaTool().getPOJOIterator(this.getConfiguration().getClassMappings());
        HashMap additionalContext = new HashMap();
        while (iterator.hasNext()) {
            POJOClass element = (POJOClass)iterator.next();
            ConfigurationNavigator.collectComponents(components, element);
            this.exportPersistentClass(additionalContext, element);
        }
        iterator = components.values().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            ComponentPOJOClass element = new ComponentPOJOClass(component, this.getCfg2JavaTool());
            this.exportComponent(additionalContext, element);
        }
    }

    protected void exportComponent(Map additionalContext, POJOClass element) {
        this.exportPOJO(additionalContext, element);
    }

    protected void exportPersistentClass(Map additionalContext, POJOClass element) {
        this.exportPOJO(additionalContext, element);
    }

    protected void exportPOJO(Map additionalContext, POJOClass element) {
        TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
        additionalContext.put("pojo", element);
        additionalContext.put("clazz", element.getDecoratedObject());
        String filename = this.resolveFilename(element);
        if (filename.endsWith(".java") && filename.indexOf(36) >= 0) {
            this.log.warn((Object)("Filename for " + this.getClassNameForFile(element) + " contains a $. Innerclass generation is not supported."));
        }
        producer.produce(additionalContext, this.getTemplateName(), new File(this.getOutputDirectory(), filename), this.templateName);
    }

    protected String resolveFilename(POJOClass element) {
        String filename = StringHelper.replace((String)this.filePattern, (String)"{class-name}", (String)this.getClassNameForFile(element));
        String packageLocation = StringHelper.replace((String)this.getPackageNameForFile(element), (String)".", (String)"/");
        if (StringHelper.isEmpty((String)packageLocation)) {
            packageLocation = ".";
        }
        filename = StringHelper.replace((String)filename, (String)"{package-name}", (String)packageLocation);
        return filename;
    }

    protected String getPackageNameForFile(POJOClass element) {
        return element.getPackageName();
    }

    protected String getClassNameForFile(POJOClass element) {
        return element.getDeclarationName();
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getFilePattern() {
        return this.filePattern;
    }
}

