/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ExporterException;

public class HibernateConfigurationExporter
extends AbstractExporter {
    private Writer output;
    private Properties customProperties = new Properties();

    public HibernateConfigurationExporter(Configuration configuration, File outputdir) {
        super(configuration, outputdir);
    }

    public HibernateConfigurationExporter() {
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
    }

    public Writer getOutput() {
        return this.output;
    }

    public void setOutput(Writer output) {
        this.output = output;
    }

    public void doStart() throws ExporterException {
        PrintWriter pw = null;
        File file = null;
        try {
            if (this.output == null) {
                file = new File(this.getOutputDirectory(), "hibernate.cfg.xml");
                this.getTemplateHelper().ensureExistence(file);
                pw = new PrintWriter(new FileWriter(file));
                this.getArtifactCollector().addFile(file, "cfg.xml");
            } else {
                pw = new PrintWriter(this.output);
            }
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE hibernate-configuration PUBLIC\r\n\t\t\"-//Hibernate/Hibernate Configuration DTD 3.0//EN\"\r\n\t\t\"http://hibernate.sourceforge.net/hibernate-configuration-3.0.dtd\">\r\n<hibernate-configuration>");
            boolean ejb3 = Boolean.valueOf((String)this.getProperties().get("ejb3"));
            TreeMap<Object, Object> props = new TreeMap<Object, Object>();
            if (this.getConfiguration() != null) {
                props.putAll(this.getConfiguration().getProperties());
            }
            if (this.customProperties != null) {
                props.putAll(this.customProperties);
            }
            String sfname = (String)props.get("hibernate.session_factory_name");
            pw.println("    <session-factory" + (sfname == null ? "" : " name=\"" + sfname + "\"") + ">");
            Set set = props.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry element = iterator.next();
                String key = (String)element.getKey();
                if (key.equals("hibernate.session_factory_name") || !key.startsWith("hibernate.")) continue;
                pw.println("        <property name=\"" + key + "\">" + element.getValue() + "</property>");
            }
            if (this.getConfiguration() != null) {
                Iterator classMappings = this.getConfiguration().getClassMappings();
                while (classMappings.hasNext()) {
                    PersistentClass element = (PersistentClass)classMappings.next();
                    if (!(element instanceof RootClass)) continue;
                    this.dump(pw, ejb3, element);
                }
            }
            pw.println("    </session-factory>\r\n</hibernate-configuration>");
        }
        catch (IOException e) {
            throw new ExporterException("Problems while creating hibernate.cfg.xml", e);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    private void dump(PrintWriter pw, boolean useClass, PersistentClass element) {
        if (useClass) {
            pw.println("<mapping class=\"" + element.getClassName() + "\"/>");
        } else {
            pw.println("<mapping resource=\"" + this.getMappingFileResource(element) + "\"/>");
        }
        Iterator directSubclasses = element.getDirectSubclasses();
        while (directSubclasses.hasNext()) {
            PersistentClass subclass = (PersistentClass)directSubclasses.next();
            this.dump(pw, useClass, subclass);
        }
    }

    private String getMappingFileResource(PersistentClass element) {
        return element.getClassName().replace('.', '/') + ".hbm.xml";
    }

    public String getName() {
        return "cfg2cfgxml";
    }
}

