/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ExporterException;

public class QueryExporter
extends AbstractExporter {
    private String filename;
    private List queryStrings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        Session session = null;
        SessionFactory sessionFactory = null;
        Transaction transaction = null;
        try {
            sessionFactory = this.getConfiguration().buildSessionFactory();
            session = sessionFactory.openSession();
            transaction = session.beginTransaction();
            Iterator iter = this.queryStrings.iterator();
            while (iter.hasNext()) {
                String query = (String)iter.next();
                List list = session.createQuery(query).list();
                if (this.getFileName() == null) continue;
                PrintWriter pw = null;
                try {
                    File file = new File(this.getOutputDirectory(), this.getFileName());
                    this.getTemplateHelper().ensureExistence(file);
                    pw = new PrintWriter(new FileWriter(file, true));
                    this.getArtifactCollector().addFile(file, "query-output");
                    Iterator iter1 = list.iterator();
                    while (iter1.hasNext()) {
                        Object element = iter1.next();
                        pw.println(element);
                    }
                }
                catch (IOException e) {
                    throw new ExporterException("Could not write query output", e);
                }
                finally {
                    if (pw == null) continue;
                    pw.flush();
                    pw.close();
                }
            }
            transaction.commit();
        }
        catch (HibernateException he) {
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            session.close();
            session.getSessionFactory().close();
        }
    }

    private String getFileName() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setQueries(List queryStrings) {
        this.queryStrings = queryStrings;
    }
}

