/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint.detector;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.DefaultDatabaseCollector;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbmlint.Issue;
import org.hibernate.tool.hbmlint.IssueCollector;
import org.hibernate.tool.hbmlint.detector.RelationalModelDetector;
import org.hibernate.tool.hbmlint.detector.TableSelectorStrategy;
import org.hibernate.util.StringHelper;

public class SchemaByMetaDataDetector
extends RelationalModelDetector {
    JDBCReader reader;
    private TableSelectorStrategy tableSelector;
    private DefaultDatabaseCollector dbc;
    private Dialect dialect;
    private Mapping mapping;
    Table currentDbTable = null;

    public String getName() {
        return "schema";
    }

    public void initialize(Configuration cfg, Settings settings) {
        super.initialize(cfg, settings);
        this.dialect = settings.getDialect();
        this.tableSelector = new TableSelectorStrategy(new DefaultReverseEngineeringStrategy());
        this.reader = JDBCReaderFactory.newJDBCReader(cfg.getProperties(), settings, this.tableSelector);
        this.dbc = new DefaultDatabaseCollector();
        this.mapping = cfg.buildMapping();
    }

    public void visit(Configuration cfg, IssueCollector collector) {
        super.visit(cfg, collector);
        this.visitGenerators(cfg, collector);
    }

    public void visitGenerators(Configuration cfg, IssueCollector collector) {
        Iterator iter = this.iterateGenerators(cfg);
        Set sequences = Collections.EMPTY_SET;
        if (this.dialect.supportsSequences()) {
            sequences = this.reader.readSequences(this.dialect.getQuerySequencesString());
        }
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (this.isSequence(key, sequences) || this.isTable(key)) continue;
            collector.reportIssue(new Issue("MISSING_ID_GENERATOR", 100, "Missing sequence or table: " + key));
        }
    }

    private boolean isSequence(Object key, Set sequences) {
        if (key instanceof String) {
            if (sequences.contains(key)) {
                return true;
            }
            String[] strings = StringHelper.split((String)".", (String)((String)key));
            if (strings.length == 3) {
                return sequences.contains(strings[2]);
            }
            if (strings.length == 2) {
                return sequences.contains(strings[1]);
            }
        }
        return false;
    }

    private boolean isTable(Object key) throws HibernateException {
        if (key instanceof String) {
            String[] strings = StringHelper.split((String)".", (String)((String)key));
            if (strings.length == 1) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(new SchemaSelection(null, null, strings[0]));
                List list = this.reader.readDatabaseSchema(this.dbc, null, null);
                return !list.isEmpty();
            }
            if (strings.length == 3) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(new SchemaSelection(strings[0], strings[1], strings[2]));
                List list = this.reader.readDatabaseSchema(this.dbc, null, null);
                return !list.isEmpty();
            }
            if (strings.length == 2) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(new SchemaSelection(null, strings[0], strings[1]));
                List list = this.reader.readDatabaseSchema(this.dbc, null, null);
                return !list.isEmpty();
            }
        }
        return false;
    }

    public void visit(Configuration cfg, Table table, IssueCollector pc) {
        if (table.isPhysicalTable()) {
            this.setSchemaSelection(table);
            List list = this.reader.readDatabaseSchema(this.dbc, null, null);
            if (list.isEmpty()) {
                pc.reportIssue(new Issue("SCHEMA_TABLE_MISSING", 100, "Missing table " + Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName())));
                return;
            }
            if (list.size() > 1) {
                pc.reportIssue(new Issue("SCHEMA_TABLE_MISSING", 50, "Found " + list.size() + " tables for " + Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName())));
                return;
            }
            this.currentDbTable = (Table)list.get(0);
            this.visitColumns(cfg, table, pc);
        }
    }

    String table(Table t) {
        return Table.qualify((String)t.getCatalog(), (String)t.getSchema(), (String)t.getName());
    }

    public void visit(Configuration cfg, Table table, Column col, IssueCollector pc) {
        if (this.currentDbTable == null) {
            return;
        }
        Column dbColumn = this.currentDbTable.getColumn(new Column(col.getName()));
        if (dbColumn == null) {
            pc.reportIssue(new Issue("SCHEMA_COLUMN_MISSING", 100, this.table(table) + " is missing column: " + col.getName()));
        } else {
            int modelTypeCode;
            String sqlType = col.getSqlType(this.dialect, this.mapping);
            int dbTypeCode = dbColumn.getSqlTypeCode();
            if (dbTypeCode != (modelTypeCode = col.getSqlTypeCode(this.mapping))) {
                pc.reportIssue(new Issue("SCHEMA_COLUMN_TYPE_MISMATCH", 50, this.table(table) + " has a wrong column type for " + col.getName() + ", expected: " + JDBCToHibernateTypeHelper.getJDBCTypeName(modelTypeCode) + " but was " + JDBCToHibernateTypeHelper.getJDBCTypeName(dbTypeCode) + " in db"));
            }
        }
    }

    private void setSchemaSelection(Table table) {
        this.tableSelector.clearSchemaSelections();
        this.tableSelector.addSchemaSelection(new SchemaSelection(table.getCatalog(), table.getSchema(), table.getName()));
    }

    private Iterator iterateGenerators(Configuration cfg) throws MappingException {
        IdentifierGenerator ig;
        TreeMap<Object, IdentifierGenerator> generators = new TreeMap<Object, IdentifierGenerator>();
        String defaultCatalog = this.getSettings().getDefaultCatalogName();
        String defaultSchema = this.getSettings().getDefaultSchemaName();
        Iterator iter = cfg.getClassMappings();
        while (iter.hasNext()) {
            PersistentClass pc = (PersistentClass)iter.next();
            if (pc.isInherited() || !((ig = pc.getIdentifier().createIdentifierGenerator((IdentifierGeneratorFactory)cfg.getIdentifierGeneratorFactory(), this.dialect, defaultCatalog, defaultSchema, (RootClass)pc)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        iter = this.getConfiguration().getCollectionMappings();
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator((IdentifierGeneratorFactory)cfg.getIdentifierGeneratorFactory(), this.dialect, defaultCatalog, defaultSchema, null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }
}

