/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.codec.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextReplacedElementFactory;
import org.xhtmlrenderer.render.BlockBox;

public class ExtendedITextReplacedElementFactory
extends ITextReplacedElementFactory {
    private static final Logger log = Logger.getLogger(ExtendedITextReplacedElementFactory.class);

    public ExtendedITextReplacedElementFactory(ITextOutputDevice outputDevice) {
        super(outputDevice);
    }

    public ReplacedElement createReplacedElement(LayoutContext layoutContext, BlockBox blockBox, UserAgentCallback userAgentCallback, int cssWidth, int cssHeight) {
        Element element = blockBox.getElement();
        if (this.isDataUriImage(element)) {
            String src = element.getAttribute("src");
            try {
                String encoded = StringUtils.substringAfter((String)src, (String)";base64,");
                if (!encoded.isEmpty()) {
                    byte[] decoded = Base64.decode((String)encoded);
                    ITextFSImage image = new ITextFSImage(Image.getInstance((byte[])decoded));
                    if (cssWidth != -1 || cssHeight != -1) {
                        image.scale(cssWidth, cssHeight);
                    }
                    log.trace((Object)"Replaced data uri image successfully");
                    return new ITextImageElement((FSImage)image);
                }
                log.warn((Object)"Unable to replace data uri image because of empty data");
            }
            catch (Exception exception) {
                log.warn((Object)"Unable to replace data uri image", (Throwable)exception);
            }
            return null;
        }
        return super.createReplacedElement(layoutContext, blockBox, userAgentCallback, cssWidth, cssHeight);
    }

    protected boolean isDataUriImage(Element element) {
        String src;
        String tag;
        if (element != null && (tag = element.getNodeName()).equalsIgnoreCase("img") && (src = element.getAttribute("src")) != null) {
            src = src.trim().toLowerCase();
            return src.startsWith("data:image/");
        }
        return false;
    }
}

