/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.bean;

import java.io.Serializable;

public final class CallStack
implements Serializable {
    private static final long serialVersionUID = -8590644046907438578L;
    private final int zeroHash;
    private final int pathHash;
    private final StackTraceElement[] callStack;

    public CallStack(StackTraceElement[] callStack) {
        this.callStack = callStack;
        this.zeroHash = callStack[0].hashCode();
        int hc = 0;
        for (int i = 1; i < callStack.length; ++i) {
            hc = 31 * hc + callStack[i].hashCode();
        }
        this.pathHash = hc;
    }

    public StackTraceElement getFirstStackTraceElement() {
        return this.callStack[0];
    }

    public StackTraceElement[] getCallStack() {
        return this.callStack;
    }

    public int getZeroHash() {
        return this.zeroHash;
    }

    public int getPathHash() {
        return this.pathHash;
    }

    public String toString() {
        return this.zeroHash + ":" + this.pathHash + ":" + this.callStack[0];
    }
}

