/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.AdminLogging;
import com.avaje.ebean.config.AutofetchConfig;
import com.avaje.ebean.config.ConfigPropertyMap;
import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.EncryptDeployManager;
import com.avaje.ebean.config.EncryptKeyManager;
import com.avaje.ebean.config.Encryptor;
import com.avaje.ebean.config.ExternalTransactionManager;
import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.PropertyExpression;
import com.avaje.ebean.config.PstmtDelegate;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbEncrypt;
import com.avaje.ebean.config.ldap.LdapConfig;
import com.avaje.ebean.config.ldap.LdapContextFactory;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebean.event.BeanQueryAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfig {
    private String name;
    private String resourceDirectory;
    private int enhanceLogLevel;
    private boolean register = true;
    private boolean defaultServer;
    private boolean validateOnSave = true;
    private List<Class<?>> classes = new ArrayList();
    private List<String> packages = new ArrayList<String>();
    private List<String> searchJars = new ArrayList<String>();
    private AutofetchConfig autofetchConfig = new AutofetchConfig();
    private String databasePlatformName;
    private DatabasePlatform databasePlatform;
    private int databaseSequenceBatchSize = 20;
    private boolean persistBatching;
    private int persistBatchSize = 20;
    private int lazyLoadBatchSize = 1;
    private boolean ddlGenerate;
    private boolean ddlRun;
    private boolean debugSql;
    private boolean debugLazyLoad;
    private boolean useJtaTransactionManager;
    private ExternalTransactionManager externalTransactionManager;
    private boolean loggingToJavaLogger;
    private String loggingDirectory = "logs";
    private AdminLogging.LogFileSharing loggingLogFileSharing = AdminLogging.LogFileSharing.EXPLICIT;
    private AdminLogging.LogLevel loggingLevel = AdminLogging.LogLevel.ALL;
    private AdminLogging.LogLevelStmt loggingLevelIud = AdminLogging.LogLevelStmt.SQL;
    private AdminLogging.LogLevelStmt loggingLevelQuery = AdminLogging.LogLevelStmt.SQL;
    private AdminLogging.LogLevelStmt loggingLevelSqlQuery = AdminLogging.LogLevelStmt.SQL;
    private AdminLogging.LogLevelTxnCommit loggingLevelTxnCommit;
    private PstmtDelegate pstmtDelegate;
    private DataSource dataSource;
    private DataSourceConfig dataSourceConfig = new DataSourceConfig();
    private String dataSourceJndiName;
    private String databaseBooleanTrue;
    private String databaseBooleanFalse;
    private NamingConvention namingConvention;
    private boolean updateChangesOnly = true;
    private List<BeanPersistController> persistControllers = new ArrayList<BeanPersistController>();
    private List<BeanPersistListener<?>> persistListeners = new ArrayList();
    private List<BeanQueryAdapter> queryAdapters = new ArrayList<BeanQueryAdapter>();
    private EncryptKeyManager encryptKeyManager;
    private EncryptDeployManager encryptDeployManager;
    private Encryptor encryptor;
    private DbEncrypt dbEncrypt;
    private LdapConfig ldapConfig;
    private boolean vanillaMode;
    private boolean vanillaRefMode;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRegister() {
        return this.register;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public boolean isDefaultServer() {
        return this.defaultServer;
    }

    public void setDefaultServer(boolean defaultServer) {
        this.defaultServer = defaultServer;
    }

    public boolean isPersistBatching() {
        return this.persistBatching;
    }

    public boolean isUsePersistBatching() {
        return this.persistBatching;
    }

    public void setPersistBatching(boolean persistBatching) {
        this.persistBatching = persistBatching;
    }

    public void setUsePersistBatching(boolean persistBatching) {
        this.persistBatching = persistBatching;
    }

    public int getPersistBatchSize() {
        return this.persistBatchSize;
    }

    public void setPersistBatchSize(int persistBatchSize) {
        this.persistBatchSize = persistBatchSize;
    }

    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    public void setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.lazyLoadBatchSize = lazyLoadBatchSize;
    }

    public void setDatabaseSequenceBatchSize(int databaseSequenceBatchSize) {
        this.databaseSequenceBatchSize = databaseSequenceBatchSize;
    }

    public boolean isUseJtaTransactionManager() {
        return this.useJtaTransactionManager;
    }

    public void setUseJtaTransactionManager(boolean useJtaTransactionManager) {
        this.useJtaTransactionManager = useJtaTransactionManager;
    }

    public ExternalTransactionManager getExternalTransactionManager() {
        return this.externalTransactionManager;
    }

    public void setExternalTransactionManager(ExternalTransactionManager externalTransactionManager) {
        this.externalTransactionManager = externalTransactionManager;
    }

    public boolean isVanillaMode() {
        return this.vanillaMode;
    }

    public void setVanillaMode(boolean vanillaMode) {
        this.vanillaMode = vanillaMode;
    }

    public boolean isVanillaRefMode() {
        return this.vanillaRefMode;
    }

    public void setVanillaRefMode(boolean vanillaRefMode) {
        this.vanillaRefMode = vanillaRefMode;
    }

    public boolean isValidateOnSave() {
        return this.validateOnSave;
    }

    public void setValidateOnSave(boolean validateOnSave) {
        this.validateOnSave = validateOnSave;
    }

    public int getEnhanceLogLevel() {
        return this.enhanceLogLevel;
    }

    public void setEnhanceLogLevel(int enhanceLogLevel) {
        this.enhanceLogLevel = enhanceLogLevel;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public AutofetchConfig getAutofetchConfig() {
        return this.autofetchConfig;
    }

    public void setAutofetchConfig(AutofetchConfig autofetchConfig) {
        this.autofetchConfig = autofetchConfig;
    }

    public PstmtDelegate getPstmtDelegate() {
        return this.pstmtDelegate;
    }

    public void setPstmtDelegate(PstmtDelegate pstmtDelegate) {
        this.pstmtDelegate = pstmtDelegate;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public String getDatabaseBooleanTrue() {
        return this.databaseBooleanTrue;
    }

    public void setDatabaseBooleanTrue(String databaseTrue) {
        this.databaseBooleanTrue = databaseTrue;
    }

    public String getDatabaseBooleanFalse() {
        return this.databaseBooleanFalse;
    }

    public void setDatabaseBooleanFalse(String databaseFalse) {
        this.databaseBooleanFalse = databaseFalse;
    }

    public int getDatabaseSequenceBatchSize() {
        return this.databaseSequenceBatchSize;
    }

    public void setDatabaseSequenceBatch(int databaseSequenceBatchSize) {
        this.databaseSequenceBatchSize = databaseSequenceBatchSize;
    }

    public String getDatabasePlatformName() {
        return this.databasePlatformName;
    }

    public void setDatabasePlatformName(String databasePlatformName) {
        this.databasePlatformName = databasePlatformName;
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public EncryptKeyManager getEncryptKeyManager() {
        return this.encryptKeyManager;
    }

    public void setEncryptKeyManager(EncryptKeyManager encryptKeyManager) {
        this.encryptKeyManager = encryptKeyManager;
    }

    public EncryptDeployManager getEncryptDeployManager() {
        return this.encryptDeployManager;
    }

    public void setEncryptDeployManager(EncryptDeployManager encryptDeployManager) {
        this.encryptDeployManager = encryptDeployManager;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public DbEncrypt getDbEncrypt() {
        return this.dbEncrypt;
    }

    public void setDbEncrypt(DbEncrypt dbEncrypt) {
        this.dbEncrypt = dbEncrypt;
    }

    public boolean isDebugSql() {
        return this.debugSql;
    }

    public void setDebugSql(boolean debugSql) {
        this.debugSql = debugSql;
    }

    public boolean isDebugLazyLoad() {
        return this.debugLazyLoad;
    }

    public void setDebugLazyLoad(boolean debugLazyLoad) {
        this.debugLazyLoad = debugLazyLoad;
    }

    public AdminLogging.LogLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(AdminLogging.LogLevel logging) {
        this.loggingLevel = logging;
    }

    public AdminLogging.LogLevelStmt getLoggingLevelIud() {
        return this.loggingLevelIud;
    }

    public void setLoggingLevelIud(AdminLogging.LogLevelStmt iudLoglevel) {
        this.loggingLevelIud = iudLoglevel;
    }

    public AdminLogging.LogLevelStmt getLoggingLevelQuery() {
        return this.loggingLevelQuery;
    }

    public void setLoggingLevelQuery(AdminLogging.LogLevelStmt queryLogLevel) {
        this.loggingLevelQuery = queryLogLevel;
    }

    public AdminLogging.LogLevelStmt getLoggingLevelSqlQuery() {
        return this.loggingLevelSqlQuery;
    }

    public void setLoggingLevelSqlQuery(AdminLogging.LogLevelStmt sqlQueryLogLevel) {
        this.loggingLevelSqlQuery = sqlQueryLogLevel;
    }

    public AdminLogging.LogLevelTxnCommit getLoggingLevelTxnCommit() {
        return this.loggingLevelTxnCommit;
    }

    public void setLoggingLevelTxnCommit(AdminLogging.LogLevelTxnCommit transactionDebugLevel) {
        this.loggingLevelTxnCommit = transactionDebugLevel;
    }

    public AdminLogging.LogFileSharing getLoggingLogFileSharing() {
        if (this.externalTransactionManager != null) {
            return AdminLogging.LogFileSharing.ALL;
        }
        return this.loggingLogFileSharing;
    }

    public void setLoggingLogFileSharing(AdminLogging.LogFileSharing logSharing) {
        this.loggingLogFileSharing = logSharing;
    }

    public String getLoggingDirectory() {
        return this.loggingDirectory;
    }

    public String getLoggingDirectoryWithEval() {
        return PropertyExpression.eval(this.loggingDirectory);
    }

    public void setLoggingDirectory(String loggingDirectory) {
        this.loggingDirectory = loggingDirectory;
    }

    public boolean isLoggingToJavaLogger() {
        return this.loggingToJavaLogger;
    }

    public void setLoggingToJavaLogger(boolean transactionLogToJavaLogger) {
        this.loggingToJavaLogger = transactionLogToJavaLogger;
    }

    public boolean isUseJuliTransactionLogger() {
        return this.isLoggingToJavaLogger();
    }

    public void setUseJuliTransactionLogger(boolean transactionLogToJavaLogger) {
        this.setLoggingToJavaLogger(transactionLogToJavaLogger);
    }

    public void setDdlGenerate(boolean ddlGenerate) {
        this.ddlGenerate = ddlGenerate;
    }

    public void setDdlRun(boolean ddlRun) {
        this.ddlRun = ddlRun;
    }

    public boolean isDdlGenerate() {
        return this.ddlGenerate;
    }

    public boolean isDdlRun() {
        return this.ddlRun;
    }

    public LdapConfig getLdapConfig() {
        return this.ldapConfig;
    }

    public void setLdapConfig(LdapConfig ldapConfig) {
        this.ldapConfig = ldapConfig;
    }

    public void addClass(Class<?> cls) {
        if (this.classes == null) {
            this.classes = new ArrayList();
        }
        this.classes.add(cls);
    }

    public void addPackage(String packageName) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        this.packages.add(packageName);
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public void addJar(String jarName) {
        if (this.searchJars == null) {
            this.searchJars = new ArrayList<String>();
        }
        this.searchJars.add(jarName);
    }

    public List<String> getJars() {
        return this.searchJars;
    }

    public void setJars(List<String> searchJars) {
        this.searchJars = searchJars;
    }

    public void setClasses(List<Class<?>> classes) {
        this.classes = classes;
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }

    public boolean isUpdateChangesOnly() {
        return this.updateChangesOnly;
    }

    public void setUpdateChangesOnly(boolean updateChangesOnly) {
        this.updateChangesOnly = updateChangesOnly;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public void add(BeanQueryAdapter beanQueryAdapter) {
        this.queryAdapters.add(beanQueryAdapter);
    }

    public List<BeanQueryAdapter> getQueryAdapters() {
        return this.queryAdapters;
    }

    public void setQueryAdapters(List<BeanQueryAdapter> queryAdapters) {
        this.queryAdapters = queryAdapters;
    }

    public void add(BeanPersistController beanPersistController) {
        this.persistControllers.add(beanPersistController);
    }

    public List<BeanPersistController> getPersistControllers() {
        return this.persistControllers;
    }

    public void setPersistControllers(List<BeanPersistController> persistControllers) {
        this.persistControllers = persistControllers;
    }

    public void add(BeanPersistListener<?> beanPersistListener) {
        this.persistListeners.add(beanPersistListener);
    }

    public List<BeanPersistListener<?>> getPersistListeners() {
        return this.persistListeners;
    }

    public void setPersistListeners(List<BeanPersistListener<?>> persistListeners) {
        this.persistListeners = persistListeners;
    }

    public void loadFromProperties() {
        ConfigPropertyMap p = new ConfigPropertyMap(this.name);
        this.loadSettings(p);
    }

    public String getProperty(String propertyName, String defaultValue) {
        ConfigPropertyMap p = new ConfigPropertyMap(this.name);
        return p.get(propertyName, defaultValue);
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    private <T> T createInstance(ConfigPropertyMap p, Class<T> type, String key) {
        String classname = p.get(key, null);
        if (classname == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(classname);
            return (T)cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadSettings(ConfigPropertyMap p) {
        LdapContextFactory ctxFact;
        if (this.autofetchConfig == null) {
            this.autofetchConfig = new AutofetchConfig();
        }
        this.autofetchConfig.loadSettings(p);
        if (this.dataSourceConfig == null) {
            this.dataSourceConfig = new DataSourceConfig();
        }
        this.dataSourceConfig.loadSettings(p.getServerName());
        if (this.ldapConfig == null && (ctxFact = this.createInstance(p, LdapContextFactory.class, "ldapContextFactory")) != null) {
            this.ldapConfig = new LdapConfig();
            this.ldapConfig.setContextFactory(ctxFact);
            this.ldapConfig.setVanillaMode(p.getBoolean("ldapVanillaMode", false));
        }
        this.useJtaTransactionManager = p.getBoolean("useJtaTransactionManager", false);
        this.namingConvention = this.createInstance(p, NamingConvention.class, "namingconvention");
        this.databasePlatform = this.createInstance(p, DatabasePlatform.class, "databasePlatform");
        this.encryptKeyManager = this.createInstance(p, EncryptKeyManager.class, "encryptKeyManager");
        this.encryptDeployManager = this.createInstance(p, EncryptDeployManager.class, "encryptDeployManager");
        this.encryptor = this.createInstance(p, Encryptor.class, "encryptor");
        this.dbEncrypt = this.createInstance(p, DbEncrypt.class, "dbEncrypt");
        String jarsProp = p.get("search.jars", p.get("jars", null));
        if (jarsProp != null) {
            this.searchJars = this.getSearchJarsPackages(jarsProp);
        }
        String packagesProp = p.get("search.packages", p.get("packages", null));
        if (this.packages != null) {
            this.packages = this.getSearchJarsPackages(packagesProp);
        }
        this.vanillaMode = p.getBoolean("vanillaMode", false);
        this.vanillaRefMode = p.getBoolean("vanillaRefMode", false);
        this.updateChangesOnly = p.getBoolean("updateChangesOnly", true);
        boolean batchMode = p.getBoolean("batch.mode", false);
        this.persistBatching = p.getBoolean("persistBatching", batchMode);
        int batchSize = p.getInt("batch.size", 20);
        this.persistBatchSize = p.getInt("persistBatchSize", batchSize);
        this.dataSourceJndiName = p.get("dataSourceJndiName", null);
        this.databaseSequenceBatchSize = p.getInt("databaseSequenceBatchSize", 20);
        this.databaseBooleanTrue = p.get("databaseBooleanTrue", null);
        this.databaseBooleanFalse = p.get("databaseBooleanFalse", null);
        this.lazyLoadBatchSize = p.getInt("lazyLoadBatchSize", 1);
        this.ddlGenerate = p.getBoolean("ddl.generate", false);
        this.ddlRun = p.getBoolean("ddl.run", false);
        this.debugSql = p.getBoolean("debug.sql", false);
        this.debugLazyLoad = p.getBoolean("debug.lazyload", false);
        this.loggingLevel = p.getEnum(AdminLogging.LogLevel.class, "logging", AdminLogging.LogLevel.ALL);
        this.loggingLogFileSharing = this.getLogFileSharing(p);
        String s = p.get("useJuliTransactionLogger", null);
        s = p.get("loggingToJavaLogger", s);
        this.loggingToJavaLogger = "true".equalsIgnoreCase(s);
        s = p.get("log.directory", "logs");
        this.loggingDirectory = p.get("logging.directory", s);
        this.loggingLevelIud = p.getEnum(AdminLogging.LogLevelStmt.class, "logging.iud", AdminLogging.LogLevelStmt.SQL);
        this.loggingLevelSqlQuery = p.getEnum(AdminLogging.LogLevelStmt.class, "logging.sqlquery", AdminLogging.LogLevelStmt.SQL);
        this.loggingLevelQuery = p.getEnum(AdminLogging.LogLevelStmt.class, "logging.query", AdminLogging.LogLevelStmt.SQL);
        this.loggingLevelTxnCommit = this.getOldTxnCommitLogLevel(p);
        if (this.loggingLevelTxnCommit == null) {
            this.loggingLevelTxnCommit = this.getTxnCommitLogLevel(p);
        }
        this.classes = this.getClasses(p);
    }

    private AdminLogging.LogFileSharing getLogFileSharing(ConfigPropertyMap p) {
        if (p.get("logging.logfilesharing", null) != null) {
            return p.getEnum(AdminLogging.LogFileSharing.class, "logging.logfilesharing", AdminLogging.LogFileSharing.EXPLICIT);
        }
        return p.getEnum(AdminLogging.LogFileSharing.class, "logsharing", AdminLogging.LogFileSharing.EXPLICIT);
    }

    private AdminLogging.LogLevelTxnCommit getTxnCommitLogLevel(ConfigPropertyMap p) {
        return p.getEnum(AdminLogging.LogLevelTxnCommit.class, "logging.txnCommit", AdminLogging.LogLevelTxnCommit.NONE);
    }

    private AdminLogging.LogLevelTxnCommit getOldTxnCommitLogLevel(ConfigPropertyMap p) {
        if (p.get("logging.txnCommit", null) != null) {
            return this.getTxnCommitLogLevel(p);
        }
        String dt = p.get("debug.transaction", null);
        if (dt != null) {
            try {
                int i = Integer.parseInt(dt);
                switch (i) {
                    case 0: {
                        return AdminLogging.LogLevelTxnCommit.NONE;
                    }
                    case 1: {
                        return AdminLogging.LogLevelTxnCommit.DEBUG;
                    }
                }
                return AdminLogging.LogLevelTxnCommit.VERBOSE;
            }
            catch (NumberFormatException e) {
                dt = dt.toLowerCase();
                if (dt.indexOf("all") > -1) {
                    return AdminLogging.LogLevelTxnCommit.VERBOSE;
                }
                if (dt.indexOf("rollback") > -1) {
                    return AdminLogging.LogLevelTxnCommit.DEBUG;
                }
                if (dt.indexOf("none") > -1) {
                    return AdminLogging.LogLevelTxnCommit.NONE;
                }
                return null;
            }
        }
        return null;
    }

    private ArrayList<Class<?>> getClasses(ConfigPropertyMap p) {
        String classNames = p.get("classes", null);
        if (classNames == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        String[] split = classNames.split("[ ,;]");
        for (int i = 0; i < split.length; ++i) {
            String cn = split[i].trim();
            if (cn.length() <= 0 || "class".equalsIgnoreCase(cn)) continue;
            try {
                classes.add(Class.forName(cn));
                continue;
            }
            catch (ClassNotFoundException e) {
                String msg = "Error registering class [" + cn + "] from [" + classNames + "]";
                throw new RuntimeException(msg, e);
            }
        }
        return classes;
    }

    private List<String> getSearchJarsPackages(String searchPackages) {
        ArrayList<String> hitList = new ArrayList<String>();
        if (searchPackages != null) {
            String[] entries = searchPackages.split("[ ,;]");
            for (int i = 0; i < entries.length; ++i) {
                hitList.add(entries[i].trim());
            }
        }
        return hitList;
    }
}

