/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransactionEventTable
implements Serializable {
    private static final long serialVersionUID = 2236555729767483264L;
    private final Map<String, TableIUD> map = new HashMap<String, TableIUD>();

    public void add(TransactionEventTable table) {
        for (TableIUD iud : table.values()) {
            this.add(iud);
        }
    }

    public void add(String table, boolean insert, boolean update, boolean delete) {
        table = table.toUpperCase();
        this.add(new TableIUD(table, insert, update, delete));
    }

    public void add(TableIUD newTableIUD) {
        TableIUD existingTableIUD = this.map.put(newTableIUD.getTable(), newTableIUD);
        if (existingTableIUD != null) {
            newTableIUD.add(existingTableIUD);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Collection<TableIUD> values() {
        return this.map.values();
    }

    public static class TableIUD
    implements Serializable {
        private static final long serialVersionUID = -1958317571064162089L;
        private String table;
        private boolean insert;
        private boolean update;
        private boolean delete;

        private TableIUD(String table, boolean insert, boolean update, boolean delete) {
            this.table = table;
            this.insert = insert;
            this.update = update;
            this.delete = delete;
        }

        private void add(TableIUD other) {
            if (other.insert) {
                this.insert = true;
            }
            if (other.update) {
                this.update = true;
            }
            if (other.delete) {
                this.delete = true;
            }
        }

        public String getTable() {
            return this.table;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean isDelete() {
            return this.delete;
        }

        public boolean isUpdateOrDelete() {
            return this.update || this.delete;
        }
    }
}

